/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.security.ISecurityCard;
import com.raoulvdberge.refinedstorage.api.network.security.ISecurityCardContainer;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.security.SecurityCard;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerListenerNetworkNode;
import com.raoulvdberge.refinedstorage.inventory.ItemValidatorBasic;
import com.raoulvdberge.refinedstorage.item.ItemSecurityCard;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class NetworkNodeSecurityManager
extends NetworkNode
implements ISecurityCardContainer {
    public static final String ID = "security_manager";
    private List<ISecurityCard> actualCards = new ArrayList<ISecurityCard>();
    private ItemHandlerBase cards = new ItemHandlerBase(18, new ItemHandlerListenerNetworkNode(this), new Predicate[]{new ItemValidatorBasic(RSItems.SECURITY_CARD)}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (!NetworkNodeSecurityManager.this.world.field_72995_K) {
                NetworkNodeSecurityManager.this.rebuildCards();
            }
            if (NetworkNodeSecurityManager.this.network != null) {
                NetworkNodeSecurityManager.this.network.getSecurityManager().rebuild();
            }
        }
    };
    private ItemHandlerBase editCard = new ItemHandlerBase(1, new ItemHandlerListenerNetworkNode(this), new ItemValidatorBasic(RSItems.SECURITY_CARD));

    public NetworkNodeSecurityManager(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        int usage = RS.INSTANCE.config.securityManagerUsage;
        for (int i = 0; i < this.cards.getSlots(); ++i) {
            if (this.cards.getStackInSlot(i).func_190926_b()) continue;
            usage += RS.INSTANCE.config.securityManagerPerSecurityCardUsage;
        }
        return usage;
    }

    @Override
    public void update() {
        super.update();
        if (this.ticks == 1) {
            this.rebuildCards();
        }
    }

    private void rebuildCards() {
        this.actualCards.clear();
        for (int i = 0; i < this.cards.getSlots(); ++i) {
            UUID uuid;
            ItemStack stack = this.cards.getStackInSlot(i);
            if (stack.func_190926_b() || (uuid = ItemSecurityCard.getOwner(stack)) == null) continue;
            SecurityCard card = new SecurityCard(uuid);
            for (Permission permission : Permission.values()) {
                card.getPermissions().put(permission, ItemSecurityCard.hasPermission(stack, permission));
            }
            this.actualCards.add(card);
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.cards, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.editCard, 1, tag);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.cards, 0, tag);
        StackUtils.writeItems((IItemHandler)this.editCard, 1, tag);
        return tag;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getSecurityManager().rebuild();
    }

    public ItemHandlerBase getCardsItems() {
        return this.cards;
    }

    public ItemHandlerBase getEditCard() {
        return this.editCard;
    }

    public void updatePermission(Permission permission, boolean state) {
        ItemStack card = this.getEditCard().getStackInSlot(0);
        if (!card.func_190926_b()) {
            ItemSecurityCard.setPermission(card, permission, state);
        }
    }

    @Override
    public List<ISecurityCard> getCards() {
        return this.actualCards;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.cards, this.editCard});
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }
}

