/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.network.MessageGridItemDelta;
import com.raoulvdberge.refinedstorage.network.MessageGridItemUpdate;
import com.raoulvdberge.refinedstorage.tile.grid.portable.IPortableGrid;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StorageCacheItemPortable
implements IStorageCache<ItemStack> {
    private IPortableGrid portableGrid;
    private IStackList<ItemStack> list = API.instance().createItemStackList();
    private List<Runnable> listeners = new LinkedList<Runnable>();

    public StorageCacheItemPortable(IPortableGrid portableGrid) {
        this.portableGrid = portableGrid;
    }

    @Override
    public void invalidate() {
        this.list.clear();
        if (this.portableGrid.getStorage() != null) {
            this.portableGrid.getStorage().getStacks().forEach(this.list::add);
        }
        this.listeners.forEach(Runnable::run);
        this.portableGrid.getWatchers().forEach(this::sendUpdateTo);
    }

    @Override
    public void add(@Nonnull ItemStack stack, int size, boolean rebuilding, boolean batched) {
        this.list.add(stack, size);
        if (!rebuilding) {
            this.portableGrid.getWatchers().forEach(w -> RS.INSTANCE.network.sendTo((IMessage)new MessageGridItemDelta(null, this.portableGrid.getStorageTracker(), stack, size), (EntityPlayerMP)w));
            this.listeners.forEach(Runnable::run);
        }
    }

    @Override
    public void remove(@Nonnull ItemStack stack, int size, boolean batched) {
        if (this.list.remove(stack, size)) {
            this.portableGrid.getWatchers().forEach(w -> RS.INSTANCE.network.sendTo((IMessage)new MessageGridItemDelta(null, this.portableGrid.getStorageTracker(), stack, -size), (EntityPlayerMP)w));
            this.listeners.forEach(Runnable::run);
        }
    }

    @Override
    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Runnable listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void sort() {
    }

    @Override
    public IStackList<ItemStack> getList() {
        return this.list;
    }

    @Override
    public List<IStorage<ItemStack>> getStorages() {
        return Collections.emptyList();
    }

    public void sendUpdateTo(EntityPlayer player) {
        RS.INSTANCE.network.sendTo((IMessage)new MessageGridItemUpdate(buf -> {
            buf.writeInt(this.list.getStacks().size());
            for (ItemStack stack : this.list.getStacks()) {
                StackUtils.writeItemStack(buf, stack, null, false);
                IStorageTracker.IStorageTrackerEntry entry = this.portableGrid.getStorageTracker().get(stack);
                buf.writeBoolean(entry != null);
                if (entry == null) continue;
                buf.writeLong(entry.getTime());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getName());
            }
        }, false), (EntityPlayerMP)player);
    }
}

