/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.storage;

import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageTrackerEntry;
import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fluids.FluidStack;

public class StorageTrackerFluid
implements IStorageTracker<FluidStack> {
    private static final String NBT_STACK = "Stack";
    private static final String NBT_NAME = "Name";
    private static final String NBT_TIME = "Time";
    private Map<FluidStack, IStorageTracker.IStorageTrackerEntry> changes = new TCustomHashMap((HashingStrategy)new HashingStrategy<FluidStack>(){

        public int computeHashCode(FluidStack stack) {
            return API.instance().getFluidStackHashCode(stack);
        }

        public boolean equals(FluidStack left, FluidStack right) {
            return API.instance().getComparer().isEqual(left, right, 2);
        }
    });
    private Runnable listener;

    public StorageTrackerFluid(Runnable listener) {
        this.listener = listener;
    }

    @Override
    public void changed(EntityPlayer player, FluidStack stack) {
        this.changes.put(stack, new StorageTrackerEntry(MinecraftServer.func_130071_aq(), player.func_70005_c_()));
        this.listener.run();
    }

    @Override
    public IStorageTracker.IStorageTrackerEntry get(FluidStack stack) {
        return this.changes.get(stack);
    }

    public void readFromNBT(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l(NBT_STACK));
            if (stack == null) continue;
            this.changes.put(stack, new StorageTrackerEntry(tag.func_74763_f(NBT_TIME), tag.func_74779_i(NBT_NAME)));
        }
    }

    public NBTTagList serializeNBT() {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<FluidStack, IStorageTracker.IStorageTrackerEntry> entry : this.changes.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a(NBT_TIME, entry.getValue().getTime());
            tag.func_74778_a(NBT_NAME, entry.getValue().getName());
            tag.func_74782_a(NBT_STACK, (NBTBase)entry.getKey().writeToNBT(new NBTTagCompound()));
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }
}

