/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.raoulvdberge.refinedstorage.api.util.IComparer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraftforge.fluids.FluidStack;

public class Comparer
implements IComparer {
    @Override
    public boolean isEqual(@Nullable ItemStack left, @Nullable ItemStack right, int flags) {
        EnumActionResult validity = this.validityCheck(left, right);
        if (validity == EnumActionResult.FAIL || validity == EnumActionResult.SUCCESS) {
            return validity == EnumActionResult.SUCCESS;
        }
        if ((flags & 8) == 8 && this.isEqualOredict(left, right)) {
            return true;
        }
        if (left.func_77973_b() != right.func_77973_b()) {
            return false;
        }
        if ((flags & 1) == 1 && left.func_77952_i() != Short.MAX_VALUE && right.func_77952_i() != Short.MAX_VALUE && left.func_77952_i() != right.func_77952_i()) {
            return false;
        }
        if ((flags & 2) == 2) {
            if ((flags & 0x10) == 16) {
                left = Comparer.stripTags(left.func_77946_l());
                right = Comparer.stripTags(right.func_77946_l());
            }
            if (!this.isEqualNBT(left, right)) {
                return false;
            }
        }
        return (flags & 4) != 4 || left.func_190916_E() == right.func_190916_E();
    }

    @Override
    public boolean isEqual(@Nullable FluidStack left, @Nullable FluidStack right, int flags) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right != null || left != null && right == null) {
            return false;
        }
        if (left.getFluid() != right.getFluid()) {
            return false;
        }
        if ((flags & 4) == 4 && left.amount != right.amount) {
            return false;
        }
        return (flags & 2) != 2 || left.tag == null || left.tag.equals((Object)right.tag);
    }

    @Override
    public boolean isEqualNBT(@Nullable ItemStack left, @Nullable ItemStack right) {
        EnumActionResult validity = this.validityCheck(left, right);
        if (validity == EnumActionResult.FAIL || validity == EnumActionResult.SUCCESS) {
            return validity == EnumActionResult.SUCCESS;
        }
        if (!ItemStack.func_77970_a((ItemStack)left, (ItemStack)right)) {
            if (left.func_77942_o() && !right.func_77942_o() && left.func_77978_p().func_82582_d()) {
                return true;
            }
            return !left.func_77942_o() && right.func_77942_o() && right.func_77978_p().func_82582_d();
        }
        return true;
    }

    @Override
    public boolean isEqualOredict(@Nullable ItemStack left, @Nullable ItemStack right) {
        EnumActionResult validity = this.validityCheck(left, right);
        if (validity == EnumActionResult.FAIL || validity == EnumActionResult.SUCCESS) {
            return validity == EnumActionResult.SUCCESS;
        }
        return StackUtils.areStacksEquivalent(left, right);
    }

    private EnumActionResult validityCheck(@Nullable ItemStack left, @Nullable ItemStack right) {
        if (left == null && right == null) {
            return EnumActionResult.SUCCESS;
        }
        if (left == null && right != null || left != null && right == null) {
            return EnumActionResult.FAIL;
        }
        boolean leftEmpty = left.func_190926_b();
        boolean rightEmpty = right.func_190926_b();
        if (leftEmpty && rightEmpty) {
            return EnumActionResult.SUCCESS;
        }
        if (leftEmpty && !rightEmpty || !leftEmpty && rightEmpty) {
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    @Nullable
    public static ItemStack stripTags(@Nullable ItemStack stack) {
        if (stack != null && stack.func_77942_o()) {
            switch (stack.func_77973_b().getRegistryName().func_110624_b()) {
                case "mekanism": 
                case "mekanismgenerators": 
                case "mekanismtools": {
                    stack.func_77978_p().func_82580_o("mekData");
                    break;
                }
                case "enderio": {
                    stack.func_77978_p().func_82580_o("entity");
                    stack.func_77978_p().func_82580_o("isStub");
                    stack.func_77978_p().func_82580_o("Energy");
                    stack.func_77978_p().func_82580_o("paintSource__null");
                    stack.func_77978_p().func_82580_o("paintSource");
                    stack.func_77978_p().func_82580_o("faceModes__null");
                    stack.func_77978_p().func_82580_o("faceModes");
                    stack.func_77978_p().func_82580_o("tank");
                    stack.func_77978_p().func_82580_o("voidMode");
                    stack.func_77978_p().func_82580_o("inventory");
                    stack.func_77978_p().func_82580_o("display");
                    stack.func_77978_p().func_82580_o("eio.abstractMachine");
                    break;
                }
                case "simplyjetpacks": {
                    stack.func_77978_p().func_82580_o("sjData");
                    stack.func_77978_p().func_82580_o("PackOn");
                    break;
                }
                case "refinedstorage": {
                    stack.func_77978_p().func_82580_o("RefinedStorageData");
                    break;
                }
                case "immersiveengineering": {
                    stack.func_77978_p().func_82580_o("hammerDmg");
                    stack.func_77978_p().func_82580_o("cutterDmg");
                    break;
                }
                case "modularrouters": {
                    stack.func_77978_p().func_82580_o("ModuleFilter");
                    stack.func_77978_p().func_82580_o("Flags");
                    break;
                }
                case "fluxnetworks": {
                    stack.func_77978_p().func_82580_o("dropped");
                    stack.func_77978_p().func_82580_o("energy");
                    break;
                }
                case "draconicevolution": {
                    stack.func_77978_p().func_82580_o("Energy");
                    stack.func_77978_p().func_82580_o("DEUpgrades");
                    Set profiles = stack.func_77978_p().func_150296_c().stream().filter(key -> key.startsWith("Profile")).collect(Collectors.toSet());
                    for (String profile : profiles) {
                        stack.func_77978_p().func_82580_o(profile);
                    }
                    break;
                }
                case "minecraft": {
                    stack.func_77978_p().func_82580_o("RepairCost");
                }
            }
        }
        return stack;
    }
}

