/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawer;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.container.ContainerCraftingMonitor;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.Scrollbar;
import com.raoulvdberge.refinedstorage.gui.sidebutton.SideButtonCraftingMonitorViewAutomated;
import com.raoulvdberge.refinedstorage.gui.sidebutton.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.network.MessageCraftingMonitorCancel;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCraftingMonitor
extends GuiBase {
    public static List<ICraftingMonitorElement> ELEMENTS = Collections.emptyList();
    private static final int VISIBLE_ROWS = 5;
    private static final int ITEM_WIDTH = 143;
    private static final int ITEM_HEIGHT = 18;
    private GuiButton cancelButton;
    private GuiButton cancelAllButton;
    private ICraftingMonitor craftingMonitor;
    private IElementDrawers drawers = new CraftingMonitorElementDrawers();
    private int itemSelected = -1;
    private int itemSelectedX = -1;
    private int itemSelectedY = -1;

    public GuiCraftingMonitor(ContainerCraftingMonitor container, ICraftingMonitor craftingMonitor) {
        super(container, 210, 230);
        this.craftingMonitor = craftingMonitor;
        this.scrollbar = new Scrollbar(157, 20, 12, 89);
    }

    private List<ICraftingMonitorElement> getElements() {
        return this.craftingMonitor.isActive() ? ELEMENTS : Collections.emptyList();
    }

    @Override
    public void init(int x, int y) {
        if (this.craftingMonitor.getRedstoneModeParameter() != null) {
            this.addSideButton(new SideButtonRedstoneMode(this, this.craftingMonitor.getRedstoneModeParameter()));
        }
        this.addSideButton(new SideButtonCraftingMonitorViewAutomated(this, this.craftingMonitor));
        String cancel = GuiCraftingMonitor.t("gui.cancel", new Object[0]);
        String cancelAll = GuiCraftingMonitor.t("misc.refinedstorage:cancel_all", new Object[0]);
        int cancelButtonWidth = 14 + this.field_146289_q.func_78256_a(cancel);
        int cancelAllButtonWidth = 14 + this.field_146289_q.func_78256_a(cancelAll);
        this.cancelButton = this.addButton(x + 7, y + 113, cancelButtonWidth, 20, cancel, false, true);
        this.cancelAllButton = this.addButton(x + 7 + cancelButtonWidth + 4, y + 113, cancelAllButtonWidth, 20, cancelAll, false, true);
    }

    @Override
    public void update(int x, int y) {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > 5);
            this.scrollbar.setMaxOffset(this.getRows() - 5);
        }
        if (this.itemSelected >= this.getElements().size()) {
            this.itemSelected = -1;
        }
        if (this.cancelButton != null) {
            boolean bl = this.cancelButton.field_146124_l = this.itemSelected != -1 && this.getElements().get(this.itemSelected).getTaskId() != -1;
        }
        if (this.cancelAllButton != null) {
            this.cancelAllButton.field_146124_l = this.getElements().size() > 0;
        }
    }

    @Override
    public void drawBackground(int x, int y, int mouseX, int mouseY) {
        this.bindTexture("gui/crafting_monitor.png");
        this.drawTexture(x, y, 0, 0, this.screenWidth, this.screenHeight);
        if (this.itemSelectedX != -1 && this.itemSelectedY != -1 && this.itemSelected >= 0 && this.itemSelected < this.getElements().size() && this.getElements().get(this.itemSelected).canDrawSelection()) {
            this.drawTexture(x + this.itemSelectedX, y + this.itemSelectedY, 0, 232, 143, 18);
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7, GuiCraftingMonitor.t(this.craftingMonitor.getGuiTitle(), new Object[0]));
        this.drawString(7, 137, GuiCraftingMonitor.t("container.inventory", new Object[0]));
        int item = this.scrollbar != null ? this.scrollbar.getOffset() : 0;
        RenderHelper.func_74520_c();
        int x = 8;
        int y = 20;
        this.itemSelectedX = -1;
        this.itemSelectedY = -1;
        String itemSelectedTooltip = null;
        for (int i = 0; i < 5; ++i) {
            if (item < this.getElements().size()) {
                ICraftingMonitorElement element = this.getElements().get(item);
                if (item == this.itemSelected) {
                    this.itemSelectedX = x;
                    this.itemSelectedY = y;
                }
                if (this.inBounds(x, y, 143, 18, mouseX, mouseY)) {
                    itemSelectedTooltip = element.getTooltip();
                }
                element.draw(x, y, this.drawers);
                y += 18;
            }
            ++item;
        }
        if (itemSelectedTooltip != null && !itemSelectedTooltip.isEmpty()) {
            this.drawTooltip(mouseX, mouseY, I18n.func_135052_a((String)itemSelectedTooltip, (Object[])new Object[0]));
        }
    }

    private int getRows() {
        return this.getElements().size();
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.cancelButton && this.itemSelected != -1) {
            ICraftingMonitorElement element = this.getElements().get(this.itemSelected);
            if (element.getTaskId() != -1) {
                RS.INSTANCE.network.sendToServer((IMessage)new MessageCraftingMonitorCancel(element.getTaskId()));
            }
        } else if (button == this.cancelAllButton && this.getElements().size() > 0) {
            RS.INSTANCE.network.sendToServer((IMessage)new MessageCraftingMonitorCancel(-1));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.itemSelected = -1;
        if (mouseButton == 0 && this.inBounds(8, 20, 144, 90, mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            int item = this.scrollbar != null ? this.scrollbar.getOffset() : 0;
            for (int i = 0; i < 5; ++i) {
                int ix = 8;
                int iy = 20 + i * 18;
                if (!this.inBounds(ix, iy, 143, 18, mouseX - this.field_147003_i, mouseY - this.field_147009_r) || item + i >= this.getElements().size()) continue;
                this.itemSelected = item + i;
            }
        }
    }

    public class CraftingMonitorElementDrawers
    extends GuiBase.ElementDrawers {
        private IElementDrawer<Integer> overlayDrawer = (x, y, colour) -> {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            Gui.func_73734_a((int)x, (int)y, (int)(x + 143), (int)(y + 18 - 1), (int)colour);
        };

        @Override
        public IElementDrawer<Integer> getOverlayDrawer() {
            return this.overlayDrawer;
        }
    }
}

