/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiReaderWriter;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiStorage;
import com.raoulvdberge.refinedstorage.container.ContainerConstructor;
import com.raoulvdberge.refinedstorage.container.ContainerController;
import com.raoulvdberge.refinedstorage.container.ContainerCrafter;
import com.raoulvdberge.refinedstorage.container.ContainerCraftingMonitor;
import com.raoulvdberge.refinedstorage.container.ContainerDestructor;
import com.raoulvdberge.refinedstorage.container.ContainerDetector;
import com.raoulvdberge.refinedstorage.container.ContainerDiskDrive;
import com.raoulvdberge.refinedstorage.container.ContainerDiskManipulator;
import com.raoulvdberge.refinedstorage.container.ContainerExporter;
import com.raoulvdberge.refinedstorage.container.ContainerExternalStorage;
import com.raoulvdberge.refinedstorage.container.ContainerFilter;
import com.raoulvdberge.refinedstorage.container.ContainerFluidInterface;
import com.raoulvdberge.refinedstorage.container.ContainerFluidStorage;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.container.ContainerImporter;
import com.raoulvdberge.refinedstorage.container.ContainerInterface;
import com.raoulvdberge.refinedstorage.container.ContainerNetworkTransmitter;
import com.raoulvdberge.refinedstorage.container.ContainerReaderWriter;
import com.raoulvdberge.refinedstorage.container.ContainerRelay;
import com.raoulvdberge.refinedstorage.container.ContainerSecurityManager;
import com.raoulvdberge.refinedstorage.container.ContainerSolderer;
import com.raoulvdberge.refinedstorage.container.ContainerStorage;
import com.raoulvdberge.refinedstorage.container.ContainerStorageMonitor;
import com.raoulvdberge.refinedstorage.container.ContainerWirelessTransmitter;
import com.raoulvdberge.refinedstorage.gui.GuiConstructor;
import com.raoulvdberge.refinedstorage.gui.GuiController;
import com.raoulvdberge.refinedstorage.gui.GuiCrafter;
import com.raoulvdberge.refinedstorage.gui.GuiCraftingMonitor;
import com.raoulvdberge.refinedstorage.gui.GuiDestructor;
import com.raoulvdberge.refinedstorage.gui.GuiDetector;
import com.raoulvdberge.refinedstorage.gui.GuiDiskManipulator;
import com.raoulvdberge.refinedstorage.gui.GuiExporter;
import com.raoulvdberge.refinedstorage.gui.GuiFilter;
import com.raoulvdberge.refinedstorage.gui.GuiFluidInterface;
import com.raoulvdberge.refinedstorage.gui.GuiImporter;
import com.raoulvdberge.refinedstorage.gui.GuiInterface;
import com.raoulvdberge.refinedstorage.gui.GuiNetworkTransmitter;
import com.raoulvdberge.refinedstorage.gui.GuiReaderWriter;
import com.raoulvdberge.refinedstorage.gui.GuiRelay;
import com.raoulvdberge.refinedstorage.gui.GuiSecurityManager;
import com.raoulvdberge.refinedstorage.gui.GuiSolderer;
import com.raoulvdberge.refinedstorage.gui.GuiStorage;
import com.raoulvdberge.refinedstorage.gui.GuiStorageMonitor;
import com.raoulvdberge.refinedstorage.gui.GuiWirelessTransmitter;
import com.raoulvdberge.refinedstorage.gui.grid.GridDisplayDummy;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.integration.mcmp.IntegrationMCMP;
import com.raoulvdberge.refinedstorage.integration.mcmp.RSMCMPAddon;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import com.raoulvdberge.refinedstorage.tile.TileConstructor;
import com.raoulvdberge.refinedstorage.tile.TileController;
import com.raoulvdberge.refinedstorage.tile.TileCrafter;
import com.raoulvdberge.refinedstorage.tile.TileDestructor;
import com.raoulvdberge.refinedstorage.tile.TileDetector;
import com.raoulvdberge.refinedstorage.tile.TileDiskDrive;
import com.raoulvdberge.refinedstorage.tile.TileDiskManipulator;
import com.raoulvdberge.refinedstorage.tile.TileExporter;
import com.raoulvdberge.refinedstorage.tile.TileExternalStorage;
import com.raoulvdberge.refinedstorage.tile.TileFluidInterface;
import com.raoulvdberge.refinedstorage.tile.TileFluidStorage;
import com.raoulvdberge.refinedstorage.tile.TileImporter;
import com.raoulvdberge.refinedstorage.tile.TileInterface;
import com.raoulvdberge.refinedstorage.tile.TileNetworkTransmitter;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.TileRelay;
import com.raoulvdberge.refinedstorage.tile.TileSecurityManager;
import com.raoulvdberge.refinedstorage.tile.TileSolderer;
import com.raoulvdberge.refinedstorage.tile.TileStorage;
import com.raoulvdberge.refinedstorage.tile.TileStorageMonitor;
import com.raoulvdberge.refinedstorage.tile.TileWirelessTransmitter;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.TileCraftingMonitor;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.WirelessCraftingMonitor;
import com.raoulvdberge.refinedstorage.tile.grid.TileGrid;
import com.raoulvdberge.refinedstorage.tile.grid.portable.TilePortableGrid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class GuiHandler
implements IGuiHandler {
    private Container getContainer(int ID, EntityPlayer player, TileEntity tile) {
        switch (ID) {
            case 0: {
                return new ContainerController((TileController)tile, player);
            }
            case 1: {
                return new ContainerGrid((IGrid)((Object)((TileGrid)tile).getNode()), new GridDisplayDummy(), (TileGrid)tile, player);
            }
            case 26: {
                return new ContainerGrid((TilePortableGrid)tile, new GridDisplayDummy(), (TilePortableGrid)tile, player);
            }
            case 2: {
                return new ContainerDiskDrive((TileDiskDrive)tile, player);
            }
            case 3: {
                return new ContainerImporter((TileImporter)tile, player);
            }
            case 4: {
                return new ContainerExporter((TileExporter)tile, player);
            }
            case 5: {
                return new ContainerDetector((TileDetector)tile, player);
            }
            case 6: {
                return new ContainerSolderer((TileSolderer)tile, player);
            }
            case 7: {
                return new ContainerDestructor((TileDestructor)tile, player);
            }
            case 8: {
                return new ContainerConstructor((TileConstructor)tile, player);
            }
            case 9: {
                return new ContainerStorage((TileStorage)tile, player);
            }
            case 19: {
                return new ContainerExternalStorage((TileExternalStorage)tile, player);
            }
            case 10: {
                return new ContainerRelay((TileRelay)tile, player);
            }
            case 11: {
                return new ContainerInterface((TileInterface)tile, player);
            }
            case 13: {
                return new ContainerCraftingMonitor((ICraftingMonitor)((Object)((TileCraftingMonitor)tile).getNode()), (TileCraftingMonitor)tile, player);
            }
            case 14: {
                return new ContainerWirelessTransmitter((TileWirelessTransmitter)tile, player);
            }
            case 15: {
                return new ContainerCrafter((TileCrafter)tile, player);
            }
            case 17: {
                return new ContainerNetworkTransmitter((TileNetworkTransmitter)tile, player);
            }
            case 18: {
                return new ContainerFluidInterface((TileFluidInterface)tile, player);
            }
            case 20: {
                return new ContainerFluidStorage((TileFluidStorage)tile, player);
            }
            case 21: {
                return new ContainerDiskManipulator((TileDiskManipulator)tile, player);
            }
            case 23: {
                return new ContainerReaderWriter((IGuiReaderWriter)((Object)((TileNode)tile).getNode()), (TileBase)tile, player);
            }
            case 24: {
                return new ContainerSecurityManager((TileSecurityManager)tile, player);
            }
            case 25: {
                return new ContainerStorageMonitor((TileStorageMonitor)tile, player);
            }
        }
        return null;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 12) {
            return this.getGridContainer(player, x, y, z);
        }
        if (ID == 16) {
            return this.getFilterContainer(player, x);
        }
        if (ID == 22) {
            return this.getCraftingMonitorContainer(player, x, y);
        }
        return this.getContainer(ID, player, IntegrationMCMP.isLoaded() ? RSMCMPAddon.unwrapTile((IBlockAccess)world, new BlockPos(x, y, z)) : world.func_175625_s(new BlockPos(x, y, z)));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = IntegrationMCMP.isLoaded() ? RSMCMPAddon.unwrapTile((IBlockAccess)world, new BlockPos(x, y, z)) : world.func_175625_s(new BlockPos(x, y, z));
        switch (ID) {
            case 0: {
                return new GuiController((ContainerController)this.getContainer(ID, player, tile), (TileController)tile);
            }
            case 1: 
            case 26: {
                TilePortableGrid grid = ID == 1 ? (IGrid)((Object)((TileGrid)tile).getNode()) : (TilePortableGrid)tile;
                GuiGrid gui = new GuiGrid(null, grid);
                gui.field_147002_h = new ContainerGrid(grid, gui, null, player);
                return gui;
            }
            case 12: {
                return this.getGridGui(player, x, y, z);
            }
            case 2: {
                return new GuiStorage((ContainerDiskDrive)this.getContainer(ID, player, tile), (IGuiStorage)((Object)((TileDiskDrive)tile).getNode()), "gui/disk_drive.png");
            }
            case 3: {
                return new GuiImporter((ContainerImporter)this.getContainer(ID, player, tile));
            }
            case 4: {
                return new GuiExporter((ContainerExporter)this.getContainer(ID, player, tile));
            }
            case 5: {
                return new GuiDetector((ContainerDetector)this.getContainer(ID, player, tile));
            }
            case 6: {
                return new GuiSolderer((ContainerSolderer)this.getContainer(ID, player, tile));
            }
            case 7: {
                return new GuiDestructor((ContainerDestructor)this.getContainer(ID, player, tile));
            }
            case 8: {
                return new GuiConstructor((ContainerConstructor)this.getContainer(ID, player, tile));
            }
            case 9: {
                return new GuiStorage((ContainerStorage)this.getContainer(ID, player, tile), (IGuiStorage)((Object)((TileStorage)tile).getNode()));
            }
            case 19: {
                return new GuiStorage((ContainerExternalStorage)this.getContainer(ID, player, tile), (IGuiStorage)((Object)((TileExternalStorage)tile).getNode()));
            }
            case 10: {
                return new GuiRelay((ContainerRelay)this.getContainer(ID, player, tile));
            }
            case 11: {
                return new GuiInterface((ContainerInterface)this.getContainer(ID, player, tile));
            }
            case 13: {
                return new GuiCraftingMonitor((ContainerCraftingMonitor)this.getContainer(ID, player, tile), (ICraftingMonitor)((Object)((TileCraftingMonitor)tile).getNode()));
            }
            case 14: {
                return new GuiWirelessTransmitter((ContainerWirelessTransmitter)this.getContainer(ID, player, tile));
            }
            case 15: {
                return new GuiCrafter((ContainerCrafter)this.getContainer(ID, player, tile));
            }
            case 16: {
                return new GuiFilter(this.getFilterContainer(player, x));
            }
            case 17: {
                return new GuiNetworkTransmitter((ContainerNetworkTransmitter)this.getContainer(ID, player, tile), (TileNetworkTransmitter)tile);
            }
            case 18: {
                return new GuiFluidInterface((ContainerFluidInterface)this.getContainer(ID, player, tile));
            }
            case 20: {
                return new GuiStorage((ContainerFluidStorage)this.getContainer(ID, player, tile), (IGuiStorage)((Object)((TileFluidStorage)tile).getNode()));
            }
            case 21: {
                return new GuiDiskManipulator((ContainerDiskManipulator)this.getContainer(ID, player, tile));
            }
            case 22: {
                return this.getCraftingMonitorGui(player, x, y);
            }
            case 23: {
                return new GuiReaderWriter((ContainerReaderWriter)this.getContainer(ID, player, tile), (IGuiReaderWriter)((Object)((TileNode)tile).getNode()));
            }
            case 24: {
                return new GuiSecurityManager((ContainerSecurityManager)this.getContainer(ID, player, tile), (TileSecurityManager)tile);
            }
            case 25: {
                return new GuiStorageMonitor((ContainerStorageMonitor)this.getContainer(ID, player, tile));
            }
        }
        return null;
    }

    private IGrid getGrid(EntityPlayer player, int hand, int networkDimension, int id) {
        return API.instance().getWirelessGridRegistry().get(id).create(player, EnumHand.values()[hand], networkDimension);
    }

    private GuiGrid getGridGui(EntityPlayer player, int hand, int networkDimension, int id) {
        IGrid grid = this.getGrid(player, hand, networkDimension, id);
        GuiGrid gui = new GuiGrid(null, grid);
        gui.field_147002_h = new ContainerGrid(grid, gui, null, player);
        return gui;
    }

    private ContainerGrid getGridContainer(EntityPlayer player, int hand, int networkDimension, int id) {
        return new ContainerGrid(this.getGrid(player, hand, networkDimension, id), new GridDisplayDummy(), null, player);
    }

    private WirelessCraftingMonitor getCraftingMonitor(EntityPlayer player, int hand, int networkDimension) {
        return new WirelessCraftingMonitor(networkDimension, player.func_184586_b(EnumHand.values()[hand]));
    }

    private GuiCraftingMonitor getCraftingMonitorGui(EntityPlayer player, int hand, int networkDimension) {
        WirelessCraftingMonitor craftingMonitor = this.getCraftingMonitor(player, hand, networkDimension);
        return new GuiCraftingMonitor(new ContainerCraftingMonitor(craftingMonitor, null, player), craftingMonitor);
    }

    private ContainerCraftingMonitor getCraftingMonitorContainer(EntityPlayer player, int hand, int networkDimension) {
        return new ContainerCraftingMonitor(this.getCraftingMonitor(player, hand, networkDimension), null, player);
    }

    private ContainerFilter getFilterContainer(EntityPlayer player, int hand) {
        return new ContainerFilter(player, player.func_184586_b(EnumHand.values()[hand]));
    }
}

