/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.grid.stack;

import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.apiimpl.storage.StorageTrackerEntry;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreDictionary;

public class GridStackItem
implements IGridStack {
    private int hash;
    private ItemStack stack;
    private boolean craftable;
    private boolean displayCraftText;
    private String[] oreIds = null;
    @Nullable
    private IStorageTracker.IStorageTrackerEntry entry;

    public GridStackItem(ByteBuf buf) {
        this.stack = StackUtils.readItemStack(buf);
        this.hash = buf.readInt();
        this.craftable = buf.readBoolean();
        this.setDisplayCraftText(buf.readBoolean());
        if (buf.readBoolean()) {
            this.entry = new StorageTrackerEntry(buf);
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isCraftable() {
        return this.craftable;
    }

    public boolean doesDisplayCraftText() {
        return this.displayCraftText;
    }

    public void setDisplayCraftText(boolean displayCraftText) {
        this.displayCraftText = displayCraftText;
        if (displayCraftText) {
            this.stack.func_190920_e(1);
        }
    }

    @Override
    public int getHash() {
        return this.hash;
    }

    @Override
    public String getName() {
        try {
            return this.stack.func_82833_r();
        }
        catch (Throwable t) {
            return "";
        }
    }

    @Override
    public String getModId() {
        return ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.stack.func_77973_b())).func_110624_b();
    }

    @Override
    public String[] getOreIds() {
        if (this.oreIds == null) {
            this.oreIds = this.stack.func_190926_b() ? new String[0] : Arrays.stream(OreDictionary.getOreIDs((ItemStack)this.stack)).mapToObj(OreDictionary::getOreName).collect(Collectors.toList()).toArray(new String[0]);
        }
        return this.oreIds;
    }

    @Override
    public String getTooltip() {
        try {
            List lines = this.stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            for (int i = 0; i < lines.size(); ++i) {
                if (i == 0) {
                    lines.set(i, this.stack.func_77953_t().field_77937_e + (String)lines.get(i));
                    continue;
                }
                lines.set(i, TextFormatting.GRAY + (String)lines.get(i));
            }
            return lines.stream().collect(Collectors.joining("\n"));
        }
        catch (Throwable t) {
            return "";
        }
    }

    @Override
    public int getQuantity() {
        return this.stack.func_190916_E();
    }

    @Override
    public String getFormattedFullQuantity() {
        return RenderUtils.QUANTITY_FORMATTER_UNFORMATTED.format(this.getQuantity());
    }

    @Override
    public void draw(GuiBase gui, int x, int y) {
        String text = null;
        if (this.displayCraftText) {
            text = I18n.func_135052_a((String)"gui.refinedstorage:grid.craft", (Object[])new Object[0]);
        } else if (this.stack.func_190916_E() > 1) {
            text = RenderUtils.formatQuantity(this.stack.func_190916_E());
        }
        gui.drawItem(x, y, this.stack, true, text);
    }

    @Override
    public Object getIngredient() {
        return this.stack;
    }

    @Override
    @Nullable
    public IStorageTracker.IStorageTrackerEntry getTrackerEntry() {
        return this.entry;
    }

    @Override
    public void setTrackerEntry(@Nullable IStorageTracker.IStorageTrackerEntry entry) {
        this.entry = entry;
    }

    public boolean equals(Object obj) {
        return obj instanceof IGridStack && ((GridStackItem)obj).getHash() == this.hash;
    }
}

