/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.oc;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.Map;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EnvironmentNetwork
extends AbstractManagedEnvironment {
    protected final INetworkNode node;

    public EnvironmentNetwork(INetworkNode node) {
        this.node = node;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("refinedstorage", Visibility.Network).create());
    }

    @Callback(doc="function():boolean -- Whether the node is connected.")
    public Object[] isConnected(Context context, Arguments args) {
        return new Object[]{this.node.getNetwork() != null};
    }

    @Callback(doc="function():number -- Gets the energy usage of this network.")
    public Object[] getEnergyUsage(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, "not connected"};
        }
        return new Object[]{this.node.getNetwork().getEnergyUsage()};
    }

    @Callback(doc="function():table -- Gets the crafting tasks of this network.")
    public Object[] getTasks(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, "not connected"};
        }
        return new Object[]{this.node.getNetwork().getCraftingManager().getTasks()};
    }

    @Callback(doc="function():table -- Gets the patterns of this network.")
    public Object[] getPatterns(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, "not connected"};
        }
        return new Object[]{this.node.getNetwork().getCraftingManager().getPatterns()};
    }

    @Callback(doc="function(stack:table):boolean -- Whether a crafting pattern exists for this item.")
    public Object[] hasPattern(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, "not connected"};
        }
        ItemStack stack = args.checkItemStack(0);
        return new Object[]{this.node.getNetwork().getCraftingManager().hasPattern(stack)};
    }

    @Callback(doc="function(stack:table[, count: number]):table -- Gets a list of missing items for a crafting task.")
    public Object[] getMissingItems(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, "not connected"};
        }
        ItemStack stack = args.checkItemStack(0);
        if (!this.node.getNetwork().getCraftingManager().hasPattern(stack)) {
            throw new IllegalArgumentException("No pattern for this item exists");
        }
        int count = args.optInteger(1, 1);
        ICraftingPattern pattern = this.node.getNetwork().getCraftingManager().getPattern(stack);
        ICraftingTask task = this.node.getNetwork().getCraftingManager().create(stack, pattern, count, true);
        task.calculate();
        return new Object[]{task.getMissing().getStacks()};
    }

    @Callback(doc="function(stack:table[, count: number]) -- Schedules a crafting task.")
    public Object[] scheduleTask(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{"not connected"};
        }
        ItemStack stack = args.checkItemStack(0);
        if (!this.node.getNetwork().getCraftingManager().hasPattern(stack)) {
            throw new IllegalArgumentException("No pattern for this item stack exists");
        }
        int amount = args.optInteger(1, 1);
        ICraftingPattern pattern = this.node.getNetwork().getCraftingManager().getPattern(stack);
        ICraftingTask task = this.node.getNetwork().getCraftingManager().create(stack, pattern, amount, true);
        task.calculate();
        this.node.getNetwork().getCraftingManager().add(task);
        return new Object[0];
    }

    @Callback(doc="function(stack:table):number -- Cancels a task and returns the amount of tasks cancelled.")
    public Object[] cancelTask(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, "not connected"};
        }
        ItemStack stack = args.checkItemStack(0);
        int count = 0;
        for (ICraftingTask task : this.node.getNetwork().getCraftingManager().getTasks()) {
            if (!API.instance().getComparer().isEqual(task.getRequested(), stack, 3)) continue;
            this.node.getNetwork().getCraftingManager().cancel(task);
            ++count;
        }
        return new Object[]{count};
    }

    @Callback(doc="function(stack:table[, amount:number[, direction:number]]):table -- Extracts a fluid from the network.")
    public Object[] extractFluid(Context context, Arguments args) {
        int amount;
        if (this.node.getNetwork() == null) {
            return new Object[]{null, "not connected"};
        }
        Map fluidMap = args.checkTable(0);
        if (!fluidMap.containsKey("name") || !(fluidMap.get("name") instanceof String) || ((String)fluidMap.get("name")).length() == 0) {
            throw new IllegalArgumentException("no fluid name");
        }
        String fluid = (String)fluidMap.get("name");
        FluidStack stack = FluidRegistry.getFluidStack((String)fluid, (int)(amount = Math.max(1, args.checkInteger(1))));
        if (stack == null) {
            throw new IllegalArgumentException("invalid fluid stack, does not exist");
        }
        EnumFacing facing = EnumFacing.func_82600_a((int)args.optInteger(2, 0));
        TileEntity targetEntity = this.node.getNetwork().world().func_175625_s(this.node.getPos().func_177972_a(facing));
        if (targetEntity == null || !targetEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) {
            throw new IllegalArgumentException("No fluid tank on the given side");
        }
        FluidStack extractedSim = this.node.getNetwork().extractFluid(stack, amount, true);
        if (extractedSim == null || extractedSim.amount <= 0) {
            return new Object[]{null, "could not extract the specified fluid"};
        }
        IFluidHandler handler = (IFluidHandler)targetEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
        int filledAmountSim = handler.fill(extractedSim, false);
        if (filledAmountSim <= 0) {
            return new Object[]{0};
        }
        FluidStack extracted = this.node.getNetwork().extractFluid(stack, amount, false);
        handler.fill(extracted, true);
        return new Object[]{filledAmountSim};
    }

    @Callback(doc="function(stack:table):table -- Gets a fluid from the network.")
    public Object[] getFluid(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, "not connected"};
        }
        Map fluidMap = args.checkTable(0);
        if (!fluidMap.containsKey("name") || !(fluidMap.get("name") instanceof String) || ((String)fluidMap.get("name")).length() == 0) {
            throw new IllegalArgumentException("no fluid name");
        }
        String fluid = (String)fluidMap.get("name");
        FluidStack needle = FluidRegistry.getFluidStack((String)fluid, (int)1000);
        if (needle == null) {
            throw new IllegalArgumentException("invalid fluid stack, does not exist");
        }
        return new Object[]{this.node.getNetwork().getFluidStorageCache().getList().get(needle)};
    }

    @Callback(doc="function():table -- Gets a list of all fluids in this network.")
    public Object[] getFluids(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, "not connected"};
        }
        return new Object[]{this.node.getNetwork().getFluidStorageCache().getList().getStacks()};
    }

    @Callback(doc="function(stack:table[, count:number[, direction:number]]):table -- Extracts an item from the network.")
    public Object[] extractItem(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, "not connected"};
        }
        ItemStack stack = args.checkItemStack(0);
        int count = Math.max(1, args.optInteger(1, 1));
        count = Math.min(count, stack.func_77976_d());
        EnumFacing facing = EnumFacing.func_82600_a((int)args.optInteger(2, 0));
        TileEntity targetEntity = this.node.getNetwork().world().func_175625_s(this.node.getPos().func_177972_a(facing));
        if (targetEntity == null || !targetEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
            throw new IllegalArgumentException("No inventory on the given side");
        }
        ItemStack extractedSim = this.node.getNetwork().extractItem(stack, count, true);
        if (extractedSim.func_190926_b() || extractedSim.func_190916_E() == 0) {
            return new Object[]{null, "could not extract the specified item"};
        }
        int transferableAmount = extractedSim.func_190916_E();
        IItemHandler handler = (IItemHandler)targetEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
        ItemStack insertedSim = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)extractedSim, (boolean)true);
        if (!insertedSim.func_190926_b() && insertedSim.func_190916_E() > 0) {
            transferableAmount -= insertedSim.func_190916_E();
        }
        if (transferableAmount <= 0) {
            return new Object[]{0};
        }
        ItemStack extracted = this.node.getNetwork().extractItem(stack, count, false);
        ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)extracted, (boolean)false);
        return new Object[]{transferableAmount};
    }

    @Callback(doc="function(stack:table[, compareMeta:boolean[, compareNBT:boolean[, compareOreDict:boolean]]]):table -- Gets an item from the network.")
    public Object[] getItem(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, "not connected"};
        }
        ItemStack stack = args.checkItemStack(0);
        boolean compareMeta = args.optBoolean(1, true);
        boolean compareNBT = args.optBoolean(2, true);
        boolean compareOreDict = args.optBoolean(3, false);
        int flags = 0;
        if (compareMeta) {
            flags |= 1;
        }
        if (compareNBT) {
            flags |= 2;
        }
        if (compareOreDict) {
            flags |= 8;
        }
        return new Object[]{this.node.getNetwork().getItemStorageCache().getList().get(stack, flags)};
    }

    @Callback(doc="function():table -- Gets a list of all items in this network.")
    public Object[] getItems(Context context, Arguments args) {
        if (this.node.getNetwork() == null) {
            return new Object[]{null, "not connected"};
        }
        return new Object[]{this.node.getNetwork().getItemStorageCache().getList().getStacks()};
    }
}

