/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerInterface
implements IItemHandler,
Runnable {
    private INetwork network;
    private IStorageCache<ItemStack> storageCache;
    private IItemHandler importItems;
    private ItemStack[] storageCacheData;

    public ItemHandlerInterface(INetwork network, IStorageCache<ItemStack> storageCache, IItemHandler importItems) {
        this.network = network;
        this.storageCache = storageCache;
        this.importItems = importItems;
        this.invalidate();
    }

    public int getSlots() {
        return this.importItems.getSlots() + this.storageCacheData.length;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot < this.importItems.getSlots()) {
            return this.importItems.getStackInSlot(slot);
        }
        if (slot < this.importItems.getSlots() + this.storageCacheData.length) {
            return this.storageCacheData[slot - this.importItems.getSlots()];
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot < this.importItems.getSlots()) {
            return this.importItems.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < this.importItems.getSlots()) {
            return ItemStack.field_190927_a;
        }
        if (slot < this.importItems.getSlots() + this.storageCacheData.length) {
            return StackUtils.nullToEmpty(this.network.extractItem(this.storageCacheData[slot - this.importItems.getSlots()], amount, 3, simulate));
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void run() {
        this.invalidate();
    }

    private void invalidate() {
        this.storageCacheData = this.storageCache.getList().getStacks().toArray(new ItemStack[0]);
    }
}

