/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item;

import com.raoulvdberge.refinedstorage.api.util.IWrenchable;
import com.raoulvdberge.refinedstorage.item.ItemBase;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemWrench
extends ItemBase {
    private static final String NBT_WRENCH_MODE = "WrenchMode";
    private static final String NBT_WRENCHED_DATA = "WrenchedData";
    private static final String NBT_WRENCHED_TILE = "WrenchedTile";

    public ItemWrench() {
        super("wrench");
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        WrenchMode mode = WrenchMode.readFromNBT(stack.func_77978_p());
        if (mode == WrenchMode.ROTATION) {
            Block block = world.func_180495_p(pos).func_177230_c();
            block.rotateBlock(world, pos, player.func_174811_aO().func_176734_d());
            return EnumActionResult.SUCCESS;
        }
        if (mode == WrenchMode.CONFIGURATION) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof IWrenchable) {
                IWrenchable wrenchable = (IWrenchable)tile;
                boolean canWrite = false;
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_WRENCHED_DATA) && stack.func_77978_p().func_74764_b(NBT_WRENCHED_TILE)) {
                    NBTTagCompound wrenchedData = stack.func_77978_p().func_74775_l(NBT_WRENCHED_DATA);
                    String wrenchedTile = stack.func_77978_p().func_74779_i(NBT_WRENCHED_TILE);
                    if (wrenchable.getClass().getName().equals(wrenchedTile)) {
                        wrenchable.readConfiguration(wrenchedData);
                        tile.func_70296_d();
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("item.refinedstorage:wrench.read", new Object[0]));
                    } else {
                        canWrite = true;
                    }
                } else {
                    canWrite = true;
                }
                if (canWrite) {
                    stack.func_77978_p().func_74778_a(NBT_WRENCHED_TILE, wrenchable.getClass().getName());
                    stack.func_77978_p().func_74782_a(NBT_WRENCHED_DATA, (NBTBase)wrenchable.writeConfiguration(new NBTTagCompound()));
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("item.refinedstorage:wrench.saved", new Object[0]));
                }
                return EnumActionResult.SUCCESS;
            }
        } else if (mode == WrenchMode.DISMANTLING) {
            TileEntity tile = world.func_175625_s(pos);
            IBlockState state = world.func_180495_p(pos);
            if (tile instanceof TileNode) {
                NBTTagCompound data = new NBTTagCompound();
                ((TileNode)tile).writeConfiguration(data);
                NonNullList drops = NonNullList.func_191196_a();
                state.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, state, 0);
                ItemStack tileStack = (ItemStack)drops.get(0);
                if (!tileStack.func_77942_o()) {
                    tileStack.func_77982_d(new NBTTagCompound());
                }
                tileStack.func_77978_p().func_74782_a("RefinedStorageData", (NBTBase)data);
                world.func_175698_g(pos);
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)tileStack);
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            ItemStack stack = player.func_184586_b(hand);
            WrenchMode mode = WrenchMode.readFromNBT(stack.func_77978_p());
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_82580_o(NBT_WRENCHED_TILE);
                stack.func_77978_p().func_82580_o(NBT_WRENCHED_DATA);
            } else {
                stack.func_77982_d(new NBTTagCompound());
            }
            WrenchMode next = mode.cycle();
            next.writeToNBT(stack.func_77978_p());
            player.func_145747_a((ITextComponent)new TextComponentTranslation("item.refinedstorage:wrench.mode", new Object[]{new TextComponentTranslation("item.refinedstorage:wrench.mode." + next.id, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
        }
        return super.func_77659_a(world, player, hand);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        WrenchMode mode = WrenchMode.readFromNBT(stack.func_77978_p());
        tooltip.add(I18n.func_135052_a((String)"item.refinedstorage:wrench.mode", (Object[])new Object[]{TextFormatting.YELLOW + I18n.func_135052_a((String)("item.refinedstorage:wrench.mode." + mode.id), (Object[])new Object[0]) + TextFormatting.RESET}));
    }

    private static enum WrenchMode {
        ROTATION(0),
        CONFIGURATION(1),
        DISMANTLING(2);

        private final int id;

        private WrenchMode(int id) {
            this.id = id;
        }

        public WrenchMode cycle() {
            return this == ROTATION ? CONFIGURATION : (this == CONFIGURATION ? DISMANTLING : ROTATION);
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74768_a(ItemWrench.NBT_WRENCH_MODE, this.id);
            return tag;
        }

        public static WrenchMode readFromNBT(NBTTagCompound tag) {
            if (tag != null && tag.func_74764_b(ItemWrench.NBT_WRENCH_MODE)) {
                int id = tag.func_74762_e(ItemWrench.NBT_WRENCH_MODE);
                for (WrenchMode mode : WrenchMode.values()) {
                    if (mode.id != id) continue;
                    return mode;
                }
            }
            return ROTATION;
        }
    }
}

