/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.gui.GuiCraftingMonitor;
import com.raoulvdberge.refinedstorage.gui.grid.filtering.GridFilterFilter;
import com.raoulvdberge.refinedstorage.tile.craftingmonitor.ICraftingMonitor;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageCraftingMonitorElements
implements IMessage,
IMessageHandler<MessageCraftingMonitorElements, IMessage> {
    private ICraftingMonitor craftingMonitor;
    private List<ICraftingMonitorElement> elements = new ArrayList<ICraftingMonitorElement>();

    public MessageCraftingMonitorElements() {
    }

    public MessageCraftingMonitorElements(ICraftingMonitor craftingMonitor) {
        this.craftingMonitor = craftingMonitor;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            Function<ByteBuf, ICraftingMonitorElement> factory = API.instance().getCraftingMonitorElementRegistry().get(ByteBufUtils.readUTF8String((ByteBuf)buf));
            if (factory == null) continue;
            this.elements.add(factory.apply(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        ArrayList<ICraftingMonitorElement> elements = new ArrayList<ICraftingMonitorElement>();
        for (ICraftingTask iCraftingTask : this.craftingMonitor.getTasks()) {
            ItemStack stack = iCraftingTask.getRequested();
            if (!this.craftingMonitor.canViewAutomated() && iCraftingTask.isAutomated() || stack != null && !GridFilterFilter.accepts(this.craftingMonitor.getFilters(), stack, ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).func_110624_b())) continue;
            elements.addAll(iCraftingTask.getCraftingMonitorElements());
        }
        buf.writeInt(elements.size());
        for (ICraftingMonitorElement iCraftingMonitorElement : elements) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)iCraftingMonitorElement.getId());
            iCraftingMonitorElement.write(buf);
        }
    }

    public IMessage onMessage(MessageCraftingMonitorElements message, MessageContext ctx) {
        GuiCraftingMonitor.ELEMENTS = message.elements;
        return null;
    }
}

