/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.render;

import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.CraftingPattern;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.item.ItemPattern;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public class BakedModelPattern
implements IBakedModel {
    private IBakedModel base;

    public BakedModelPattern(IBakedModel base) {
        this.base = base;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = (TRSRTransformation)RenderUtils.getDefaultItemTransforms().get((Object)cameraTransformType);
        return Pair.of((Object)this, (Object)(transform == null ? RenderUtils.EMPTY_MATRIX_TRANSFORM : transform.getMatrix()));
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.base.func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.base.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.base.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.base.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.base.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.base.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList((List)this.base.func_188617_f().getOverrides()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                CraftingPattern pattern = ItemPattern.getPatternFromCache(world, stack);
                if (BakedModelPattern.canDisplayPatternOutput(pattern)) {
                    return Minecraft.func_71410_x().func_175599_af().func_184393_a(pattern.getOutputs().get(0), world, entity);
                }
                return super.handleItemState(originalModel, stack, world, entity);
            }
        };
    }

    public static boolean canDisplayPatternOutput(CraftingPattern pattern) {
        return GuiBase.func_146272_n() && pattern.isValid() && pattern.getOutputs().size() == 1;
    }
}

