/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReader;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandlerFactory;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiReaderWriter;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeReader;
import com.raoulvdberge.refinedstorage.gui.GuiReaderWriter;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileReader
extends TileNode<NetworkNodeReader> {
    public static final TileDataParameter<String, TileReader> CHANNEL = TileReader.createChannelParameter();

    static <T extends TileNode> TileDataParameter<String, T> createChannelParameter() {
        return new TileDataParameter<String, TileNode>(DataSerializers.field_187194_d, "", t -> ((IGuiReaderWriter)((Object)t.getNode())).getChannel(), (t, v) -> {
            ((IGuiReaderWriter)((Object)t.getNode())).setChannel((String)v);
            ((NetworkNode)t.getNode()).markDirty();
        }, p -> {
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiReaderWriter) {
                ((GuiReaderWriter)Minecraft.func_71410_x().field_71462_r).updateSelection((String)p);
            }
        });
    }

    public TileReader() {
        this.dataManager.addWatchedParameter(CHANNEL);
    }

    private <T> T getDummyCapabilityForClient(IReader reader, Capability<T> capability) {
        for (IReaderWriterHandlerFactory factory : API.instance().getReaderWriterHandlerRegistry().all()) {
            T dummy = factory.create(null).getCapabilityReader(reader, capability);
            if (dummy == null) continue;
            return dummy;
        }
        return null;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        IReader reader = (IReader)this.getNode();
        if (facing != this.getDirection()) {
            return false;
        }
        if (reader.getNetwork() == null || !reader.canUpdate()) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return this.getDummyCapabilityForClient(reader, capability) != null;
            }
            return false;
        }
        IReaderWriterChannel channel = reader.getNetwork().getReaderWriterChannel(reader.getChannel());
        if (channel == null) {
            return false;
        }
        for (IReaderWriterHandler handler : channel.getHandlers()) {
            if (!handler.hasCapabilityReader(reader, capability)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        T foundCapability = super.getCapability(capability, facing);
        if (foundCapability == null) {
            IReader reader = (IReader)this.getNode();
            if (facing != this.getDirection()) {
                return null;
            }
            if (reader.getNetwork() == null || !reader.canUpdate()) {
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    return this.getDummyCapabilityForClient(reader, capability);
                }
                return null;
            }
            IReaderWriterChannel channel = reader.getNetwork().getReaderWriterChannel(reader.getChannel());
            if (channel == null) {
                return null;
            }
            for (IReaderWriterHandler handler : channel.getHandlers()) {
                foundCapability = handler.getCapabilityReader(reader, capability);
                if (foundCapability == null) continue;
                return foundCapability;
            }
        }
        return foundCapability;
    }

    @Override
    @Nonnull
    public NetworkNodeReader createNode(World world, BlockPos pos) {
        return new NetworkNodeReader(world, pos);
    }

    @Override
    public String getNodeId() {
        return "reader";
    }
}

