/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeStorageMonitor;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileStorageMonitor
extends TileNode<NetworkNodeStorageMonitor> {
    public static final TileDataParameter<Integer, TileStorageMonitor> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer, TileStorageMonitor> TYPE = IType.createParameter();
    private static final String NBT_TYPE = "Type";
    private static final String NBT_STACK = "Stack";
    private static final String NBT_AMOUNT = "Amount";
    private int type;
    private int amount;
    @Nullable
    private ItemStack itemStack;

    public TileStorageMonitor() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(TYPE);
    }

    @Override
    public NetworkNodeStorageMonitor createNode(World world, BlockPos pos) {
        return new NetworkNodeStorageMonitor(world, pos);
    }

    @Override
    public String getNodeId() {
        return "storage_monitor";
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        ItemStack stack;
        super.writeUpdate(tag);
        tag.func_74768_a(NBT_TYPE, ((NetworkNodeStorageMonitor)this.getNode()).getType());
        ItemStack itemStack = stack = ((NetworkNodeStorageMonitor)this.getNode()).getType() == 0 ? ((NetworkNodeStorageMonitor)this.getNode()).getItemFilter().getStackInSlot(0) : ((NetworkNodeStorageMonitor)this.getNode()).getFluidFilter().getStackInSlot(0);
        if (!stack.func_190926_b()) {
            tag.func_74782_a(NBT_STACK, (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74768_a(NBT_AMOUNT, ((NetworkNodeStorageMonitor)this.getNode()).getAmount());
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        this.type = tag.func_74762_e(NBT_TYPE);
        this.itemStack = tag.func_74764_b(NBT_STACK) ? new ItemStack(tag.func_74775_l(NBT_STACK)) : null;
        this.amount = tag.func_74762_e(NBT_AMOUNT);
    }

    @Override
    protected boolean canCauseRenderUpdate(NBTTagCompound tag) {
        EnumFacing receivedDirection = EnumFacing.func_82600_a((int)tag.func_74762_e("Direction"));
        boolean receivedActive = tag.func_74767_n("Active");
        return receivedDirection != this.getDirection() || receivedActive != ((NetworkNodeStorageMonitor)this.getNode()).isActive();
    }

    public int getType() {
        return this.type;
    }

    public int getAmount() {
        return this.amount;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

