/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;
import vazkii.quark.base.module.ModuleLoader;

public class DimensionConfig {
    private final boolean blacklist;
    private final List<Integer> dims;

    public DimensionConfig(String parent) {
        this(parent, false, "0");
    }

    public DimensionConfig(String parent, String dimStr) {
        this(parent, false, dimStr.split(","));
    }

    public DimensionConfig(String parent, boolean blacklist, String ... defaultStrs) {
        String category = parent + ".dimensions";
        this.blacklist = ModuleLoader.config.getBoolean("Is Blacklist", category, blacklist, "");
        String[] dimStrs = ModuleLoader.config.getStringList("Dimensions", category, defaultStrs, "");
        this.dims = new ArrayList<Integer>();
        for (String s : dimStrs) {
            try {
                this.dims.add(Integer.parseInt(s));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public boolean canSpawnHere(World world) {
        return this.dims.contains(world.field_73011_w.getDimension()) != this.blacklist;
    }
}

