/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.api.IFuseIgnitable;
import vazkii.quark.base.block.BlockQuarkDust;
import vazkii.quark.misc.feature.PlaceVanillaDusts;

public class BlockGunpowder
extends BlockQuarkDust {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public BlockGunpowder() {
        super("gunpowder_block");
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            ItemStack stack = playerIn.func_184586_b(hand);
            boolean allow = false;
            SoundEvent sound = null;
            if (stack.func_77973_b() == Items.field_151033_d) {
                stack.func_77972_a(1, (EntityLivingBase)playerIn);
                sound = SoundEvents.field_187649_bu;
                allow = true;
            } else if (stack.func_77973_b() == Items.field_151059_bz) {
                stack.func_190918_g(1);
                sound = SoundEvents.field_187616_bj;
                allow = true;
            }
            if (allow) {
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), sound, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f);
                this.lightUp(worldIn, pos);
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState otherBlock;
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && (otherBlock = worldIn.func_180495_p(fromPos)).func_177230_c() == Blocks.field_150480_ab) {
            this.lightUp(worldIn, pos);
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    private boolean lightUp(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == this) {
            IBlockState belowState = world.func_180495_p(pos.func_177977_b());
            IBlockState newState = state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true));
            world.func_175656_a(pos, newState);
            world.func_175684_a(pos, newState.func_177230_c(), belowState.func_177230_c().getRegistryName().func_110623_a().contains("netherrack") ? PlaceVanillaDusts.gunpowderDelayNetherrack : PlaceVanillaDusts.gunpowderDelay);
            if (world instanceof WorldServer) {
                float x = pos.func_177958_n();
                float y = (float)pos.func_177956_o() + 0.2f;
                float z = pos.func_177952_p();
                ((WorldServer)world).func_175739_a(EnumParticleTypes.FLAME, (double)x + 0.5, (double)y, (double)z + 0.5, 6, 0.2, 0.0, 0.2, 0.0, new int[0]);
                ((WorldServer)world).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, (double)x + 0.5, (double)y, (double)z + 0.5, 6, 0.2, 0.0, 0.2, 0.0, new int[0]);
            }
            return true;
        }
        if (block == Blocks.field_150335_W) {
            block.func_176206_d(world, pos, state.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
            world.func_175698_g(pos);
            return true;
        }
        if (block instanceof IFuseIgnitable) {
            ((IFuseIgnitable)block).onIngitedByFuse((IBlockAccess)world, pos, state);
            return true;
        }
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        worldIn.func_175698_g(pos);
        if (worldIn instanceof WorldServer) {
            ((WorldServer)worldIn).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 8, 0.2, 0.0, 0.2, 0.0, new int[0]);
        }
        block4: for (EnumFacing face : EnumFacing.field_176754_o) {
            BlockQuarkDust.EnumAttachPosition attach = this.getAttachPosition((IBlockAccess)worldIn, pos, face);
            BlockPos off = pos.func_177972_a(face);
            switch (attach) {
                case UP: {
                    this.lightUp(worldIn, off.func_177984_a());
                    continue block4;
                }
                case SIDE: {
                    if (this.lightUp(worldIn, off)) continue block4;
                    this.lightUp(worldIn, off.func_177977_b());
                    continue block4;
                }
            }
        }
    }

    @Override
    protected boolean canConnectTo(IBlockState blockState, EnumFacing side, IBlockAccess world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return block == this || block == Blocks.field_150335_W || block instanceof IFuseIgnitable;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(meta != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 1 : 0;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, LIT});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue()) {
            float x = (float)pos.func_177958_n() + 0.2f + rand.nextFloat() * 0.6f;
            float y = (float)pos.func_177956_o() + 0.2f;
            float z = (float)pos.func_177952_p() + 0.2f + rand.nextFloat() * 0.6f;
            worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151016_H;
    }

    @Override
    public int getColor(IBlockAccess world, IBlockState state, BlockPos pos, int tint) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 16739328 : 0x555555;
    }
}

