/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.arl.block.BlockMod;
import vazkii.arl.block.BlockModSlab;
import vazkii.arl.block.BlockModStairs;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.GlobalConfig;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.feature.VanillaWalls;
import vazkii.quark.world.block.BlockBasalt;
import vazkii.quark.world.block.slab.BlockBasaltSlab;
import vazkii.quark.world.block.stairs.BlockBasaltStairs;
import vazkii.quark.world.feature.Biotite;
import vazkii.quark.world.feature.RevampStoneGen;
import vazkii.quark.world.world.BasaltGenerator;

public class Basalt
extends Feature {
    public static BlockMod basalt;
    RevampStoneGen.StoneInfo basaltInfo;
    boolean enableStairsAndSlabs;
    boolean enableWalls;

    @Override
    public void setupConfig() {
        this.basaltInfo = RevampStoneGen.loadStoneInfo(this.configCategory, "basalt", 18, 20, 120, 20, true, "-1", BiomeDictionary.Type.NETHER);
        this.enableStairsAndSlabs = this.loadPropBool("Enable stairs and slabs", "", true) && GlobalConfig.enableVariants;
        this.enableWalls = this.loadPropBool("Enable walls", "", true) && GlobalConfig.enableVariants;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        basalt = new BlockBasalt();
        if (this.enableStairsAndSlabs) {
            BlockModSlab.initSlab((Block)basalt, (int)0, (BlockModSlab)new BlockBasaltSlab(false), (BlockModSlab)new BlockBasaltSlab(true));
            BlockModStairs.initStairs((Block)basalt, (int)0, (BlockStairs)new BlockBasaltStairs());
        }
        VanillaWalls.add("basalt", (Block)basalt, 0, this.enableWalls);
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)basalt, (int)4, (int)1), (Object[])new Object[]{"BB", "BB", Character.valueOf('B'), ProxyRegistry.newStack((Block)basalt, (int)1, (int)0)});
        GameRegistry.registerWorldGenerator((IWorldGenerator)new BasaltGenerator(() -> this.basaltInfo), (int)0);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        OreDictionary.registerOre((String)"stoneBasalt", (ItemStack)ProxyRegistry.newStack((Block)basalt, (int)1, (int)0));
        OreDictionary.registerOre((String)"stoneBasaltPolished", (ItemStack)ProxyRegistry.newStack((Block)basalt, (int)1, (int)1));
    }

    @Override
    public void postPreInit(FMLPreInitializationEvent event) {
        ItemStack blackItem = ProxyRegistry.newStack((Item)Items.field_151044_h);
        if (ModuleLoader.isFeatureEnabled(Biotite.class)) {
            blackItem = ProxyRegistry.newStack((Item)Biotite.biotite);
        }
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)basalt, (int)4, (int)0), (Object[])new Object[]{"BI", "IB", Character.valueOf('B'), ProxyRegistry.newStack((Block)Blocks.field_150347_e, (int)1, (int)0), Character.valueOf('I'), blackItem});
        RecipeHandler.addShapelessOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)Blocks.field_150348_b, (int)1, (int)5), (Object[])new Object[]{ProxyRegistry.newStack((Block)basalt), ProxyRegistry.newStack((Item)Items.field_151128_bU)});
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

