/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.api.block.IBlockInfo;
import cofh.api.block.IDismantleable;
import cofh.api.core.ISecurable;
import cofh.api.tileentity.IInventoryRetainer;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ITileInfo;
import cofh.core.block.BlockCore;
import cofh.core.block.TileCore;
import cofh.core.util.CoreUtils;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.RedstoneControlHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockCoreTile
extends BlockCore
implements ITileEntityProvider,
IBlockInfo,
IDismantleable,
IInitializer {
    public BlockCoreTile(Material material, String modName) {
        super(material, modName);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.func_149915_a(world, state.func_177230_c().func_176201_c(state));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCore) {
            return ((TileCore)tile).getExtendedState(state, world, pos);
        }
        return state;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCore) {
            ((TileCore)tile).blockBroken();
        }
        if (!(tile instanceof IInventoryRetainer && ((IInventoryRetainer)tile).retainInventory() || !(tile instanceof IInventory))) {
            IInventory inv = (IInventory)tile;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                CoreUtils.dropItemStackIntoWorldWithVelocity(inv.func_70301_a(i), world, pos);
            }
        }
        if (tile != null) {
            world.func_175713_t(pos);
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (ServerHelper.isServerWorld(world) && tile instanceof ISecurable && SecurityHelper.isSecure(stack)) {
            GameProfile stackOwner = SecurityHelper.getOwner(stack);
            if (!((ISecurable)tile).setOwner(stackOwner) && placer instanceof ICommandSender) {
                ((ISecurable)tile).setOwnerName(placer.func_70005_c_());
            }
            ((ISecurable)tile).setAccess(SecurityHelper.getAccess(stack));
        }
        if (tile instanceof IRedstoneControl && RedstoneControlHelper.hasRSControl(stack)) {
            ((IRedstoneControl)tile).setControl(RedstoneControlHelper.getControl(stack));
        }
        if (tile instanceof IReconfigurableFacing) {
            IReconfigurableFacing reconfig = (IReconfigurableFacing)tile;
            EnumFacing facing = reconfig.allowYAxisFacing() ? EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer) : placer.func_174811_aO().func_176734_d();
            reconfig.setFacing(facing.ordinal(), placer.func_70093_af());
        }
        if (tile instanceof TileCore) {
            ((TileCore)tile).blockPlaced();
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCore) {
            ((TileCore)tile).onNeighborBlockChange();
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCore) {
            ((TileCore)tile).onNeighborTileChange(neighbor);
        }
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable && !((ISecurable)tile).canPlayerAccess(player)) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileCore && tile.func_145830_o() ? ((TileCore)tile).getComparatorInputOverride() : 0;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileCore && tile.func_145830_o() ? ((TileCore)tile).getLightValue() : super.getLightValue(state, world, pos);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && tile.func_145842_c(id, param);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.addAll(this.dropDelegate(this.getItemStackTag(world, pos), world, pos, fortune));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Item item = Item.func_150898_a((Block)this);
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        int bMeta = state.func_177230_c().func_176201_c(state);
        ItemStack retStack = new ItemStack(item, 1, bMeta);
        retStack.func_77982_d(this.getItemStackTag((IBlockAccess)world, pos));
        return retStack;
    }

    public NBTTagCompound getItemStackTag(IBlockAccess world, BlockPos pos) {
        return null;
    }

    public abstract ArrayList<ItemStack> dropDelegate(NBTTagCompound var1, IBlockAccess var2, BlockPos var3, int var4);

    public abstract ArrayList<ItemStack> dismantleDelegate(NBTTagCompound var1, World var2, BlockPos var3, EntityPlayer var4, boolean var5, boolean var6);

    @Override
    public void getBlockInfo(List<ITextComponent> info, IBlockAccess world, BlockPos pos, EnumFacing side, EntityPlayer player, boolean debug) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ITileInfo) {
            ((ITileInfo)tile).getTileInfo(info, side, player, debug);
        } else if (tile instanceof IEnergyReceiver) {
            IEnergyReceiver rec = (IEnergyReceiver)tile;
            if (rec.getMaxEnergyStored(side) <= 0) {
                return;
            }
            info.add(new TextComponentTranslation("info.cofh.energy", new Object[0]).func_150258_a(": " + StringHelper.formatNumber(rec.getEnergyStored(side)) + "/" + StringHelper.formatNumber(rec.getMaxEnergyStored(side)) + " RF"));
        }
    }

    @Override
    public ArrayList<ItemStack> dismantleBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player, boolean returnDrops) {
        return this.dismantleDelegate(this.getItemStackTag((IBlockAccess)world, pos), world, pos, player, returnDrops, false);
    }

    @Override
    public boolean canDismantle(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ISecurable) {
            return ((ISecurable)tile).canPlayerAccess(player);
        }
        if (tile instanceof TileCore) {
            return ((TileCore)tile).canPlayerDismantle(player);
        }
        return true;
    }

    @Override
    public boolean initialize() {
        return false;
    }

    @Override
    public boolean register() {
        return false;
    }
}

