/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.inventory;

import cofh.core.util.helpers.ItemHelper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ComparableItemStack {
    public Item item = Items.field_190931_a;
    public int metadata = -1;
    public int stackSize = -1;
    public int oreID = -1;

    public static ComparableItemStack fromItemStack(ItemStack stack) {
        return new ComparableItemStack(stack);
    }

    protected static ItemStack getOre(String oreName) {
        if (ItemHelper.oreNameExists(oreName)) {
            return ItemHelper.oreProxy.getOre(oreName);
        }
        return ItemStack.field_190927_a;
    }

    public ComparableItemStack(String oreName) {
        this(ComparableItemStack.getOre(oreName));
    }

    public ComparableItemStack(ItemStack stack) {
        this.item = stack.func_77973_b();
        this.metadata = ItemHelper.getItemDamage(stack);
        if (!stack.func_190926_b()) {
            this.stackSize = stack.func_190916_E();
            this.oreID = ItemHelper.oreProxy.getOreID(stack);
        }
    }

    public ComparableItemStack(Item item, int metadata, int stackSize) {
        this.item = item;
        this.metadata = metadata;
        this.stackSize = stackSize;
        this.oreID = ItemHelper.oreProxy.getOreID(this.toItemStack());
    }

    public ComparableItemStack(ComparableItemStack stack) {
        this.item = stack.item;
        this.metadata = stack.metadata;
        this.stackSize = stack.stackSize;
        this.oreID = stack.oreID;
    }

    public boolean isEqual(ComparableItemStack other) {
        if (other == null) {
            return false;
        }
        if (this.metadata == other.metadata) {
            if (this.item == other.item) {
                return true;
            }
            if (this.item != null && other.item != null) {
                return this.item.delegate.get() == other.item.delegate.get();
            }
        }
        return false;
    }

    public boolean isItemEqual(ComparableItemStack other) {
        return other != null && (this.oreID != -1 && this.oreID == other.oreID || this.isEqual(other));
    }

    public boolean isStackEqual(ComparableItemStack other) {
        return this.isItemEqual(other) && this.stackSize == other.stackSize;
    }

    public int getId() {
        return Item.func_150891_b((Item)this.item);
    }

    public ItemStack toItemStack() {
        return this.item != Items.field_190931_a ? new ItemStack(this.item, this.stackSize, this.metadata) : ItemStack.field_190927_a;
    }

    public ComparableItemStack clone() {
        return new ComparableItemStack(this);
    }

    public boolean equals(Object o) {
        return o instanceof ComparableItemStack && this.isItemEqual((ComparableItemStack)o);
    }

    public int hashCode() {
        return this.oreID != -1 ? this.oreID : this.metadata & 0xFFFF | this.getId() << 16;
    }

    public String toString() {
        return this.getClass().getName() + '@' + System.identityHashCode(this) + '{' + "m:" + this.metadata + ", i:" + (this.item == null ? null : this.item.getClass().getName()) + '@' + System.identityHashCode(this.item) + ", v:" + this.getId() + '}';
    }
}

