/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.inventory;

import cofh.core.inventory.ComparableItemStackNBT;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class ComparableItemStackSafeNBT
extends ComparableItemStackNBT {
    public static final String BLOCK = "block";
    public static final String ORE = "ore";
    public static final String DUST = "dust";
    public static final String INGOT = "ingot";
    public static final String NUGGET = "nugget";
    public static final String GEM = "gem";

    public boolean safeOreType(String oreName) {
        return oreName.startsWith(BLOCK) || oreName.startsWith(ORE) || oreName.startsWith(DUST) || oreName.startsWith(INGOT) || oreName.startsWith(NUGGET) || oreName.startsWith(GEM);
    }

    public int getOreID(ItemStack stack) {
        ArrayList<Integer> ids = OreDictionaryArbiter.getAllOreIDs(stack);
        if (!ids.isEmpty()) {
            for (Integer id : ids) {
                if (id == -1 || !this.safeOreType(ItemHelper.oreProxy.getOreName(id))) continue;
                return id;
            }
        }
        return -1;
    }

    public int getOreID(String oreName) {
        if (!this.safeOreType(oreName)) {
            return -1;
        }
        return ItemHelper.oreProxy.getOreID(oreName);
    }

    public ComparableItemStackSafeNBT(ItemStack stack) {
        super(stack);
        this.oreID = this.getOreID(stack);
    }
}

