/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.render.FontRendererCore;
import cofh.core.util.helpers.SecurityHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCore
extends Item {
    protected String name;
    protected String modName;

    public ItemCore() {
        this("cofh");
    }

    public ItemCore(String modName) {
        this.modName = modName;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return SecurityHelper.isSecure(stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public Entity createEntity(World world, Entity location, ItemStack stack) {
        if (SecurityHelper.isSecure(stack)) {
            location.field_83001_bt = true;
            location.field_70178_ae = true;
            ((EntityItem)location).lifespan = Integer.MAX_VALUE;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return FontRendererCore.loadFontRendererStack(stack);
    }

    protected boolean harvestBlock(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state;
        Block block;
        if (world.func_175623_d(pos)) {
            return false;
        }
        EntityPlayerMP playerMP = null;
        if (player instanceof EntityPlayerMP) {
            playerMP = (EntityPlayerMP)player;
        }
        if (!ForgeHooks.canHarvestBlock((Block)(block = (state = world.func_180495_p(pos)).func_177230_c()), (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            return false;
        }
        int xpToDrop = 0;
        if (playerMP != null && (xpToDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos)) == -1) {
            return false;
        }
        if (player.field_71075_bZ.field_75098_d) {
            if (!world.field_72995_K) {
                if (block.removedByPlayer(state, world, pos, player, false)) {
                    block.func_176206_d(world, pos, state);
                }
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            } else {
                if (block.removedByPlayer(state, world, pos, player, false)) {
                    block.func_176206_d(world, pos, state);
                }
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
            }
        }
        if (!world.field_72995_K) {
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
                if (xpToDrop > 0) {
                    block.func_180637_b(world, pos, xpToDrop);
                }
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.START_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
        return true;
    }
}

