/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.api.item.IMultiModeItem;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemMulti;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.util.EnergyContainerItemWrapper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class ItemMultiRF
extends ItemMulti
implements IMultiModeItem,
IEnergyContainerItem,
IEnchantableItem {
    public static final int CREATIVE = 32000;

    public ItemMultiRF(String modName) {
        super(modName);
    }

    public boolean func_77662_d() {
        return true;
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return ItemHelper.getItemDamage(stack) != 32000;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemHelper.getItemDamage(stack) != 32000;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xD01010;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag(stack, 0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack);
    }

    protected abstract int getCapacity(ItemStack var1);

    protected abstract int getReceive(ItemStack var1);

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag(container, 0);
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(this.getMaxEnergyStored(container) - stored, this.getReceive(container)));
        if (!simulate && ItemHelper.getItemDamage(container) != 32000) {
            container.func_77978_p().func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag(container, 0);
        }
        if (ItemHelper.getItemDamage(container) == 32000) {
            return maxExtract;
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag(container, 0);
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getCapacity(container);
    }

    @Override
    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this);
    }
}

