/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.api.item.IInventoryContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.core.util.OreDictionaryProxy;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.StringHelper;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemHelper {
    public static final String BLOCK = "block";
    public static final String ORE = "ore";
    public static final String DUST = "dust";
    public static final String INGOT = "ingot";
    public static final String NUGGET = "nugget";
    public static final String LOG = "log";
    public static OreDictionaryProxy oreProxy = new OreDictionaryProxy();

    private ItemHelper() {
    }

    public static boolean isPlayerHoldingSomething(EntityPlayer player) {
        return !player.func_184614_ca().func_190926_b() || !player.func_184592_cb().func_190926_b();
    }

    public static ItemStack getMainhandStack(EntityPlayer player) {
        return player.func_184614_ca();
    }

    public static ItemStack getOffhandStack(EntityPlayer player) {
        return player.func_184592_cb();
    }

    public static ItemStack getHeldStack(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            stack = player.func_184592_cb();
        }
        return stack;
    }

    public static ItemStack cloneStack(Item item, int stackSize) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item, stackSize);
    }

    public static ItemStack cloneStack(Block block, int stackSize) {
        if (block == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(block, stackSize);
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.func_190920_e(stackSize);
        return retStack;
    }

    public static ItemStack cloneStack(ItemStack stack) {
        return stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
    }

    public static ItemStack copyTag(ItemStack container, ItemStack other) {
        if (!other.func_190926_b() && other.func_77942_o()) {
            container.func_77982_d(other.func_77978_p().func_74737_b());
        }
        return container;
    }

    public static NBTTagCompound setItemStackTagName(NBTTagCompound tag, String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (!tag.func_74764_b("display")) {
            tag.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        tag.func_74775_l("display").func_74778_a("Name", name);
        return tag;
    }

    public static ItemStack readItemStackFromNBT(NBTTagCompound nbt) {
        ItemStack stack = new ItemStack(Item.func_150899_d((int)nbt.func_74765_d("id")));
        stack.func_190920_e(nbt.func_74762_e("Count"));
        stack.func_77964_b(Math.max(0, nbt.func_74765_d("Damage")));
        if (nbt.func_150297_b("tag", 10)) {
            stack.func_77982_d(nbt.func_74775_l("tag"));
        }
        return stack;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack stack, NBTTagCompound nbt) {
        nbt.func_74777_a("id", (short)Item.func_150891_b((Item)stack.func_77973_b()));
        nbt.func_74768_a("Count", stack.func_190916_E());
        nbt.func_74777_a("Damage", (short)ItemHelper.getItemDamage(stack));
        if (stack.func_77942_o()) {
            nbt.func_74782_a("tag", (NBTBase)stack.func_77978_p());
        }
        return nbt;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack stack, int amount, NBTTagCompound nbt) {
        nbt.func_74777_a("id", (short)Item.func_150891_b((Item)stack.func_77973_b()));
        nbt.func_74768_a("Count", amount);
        nbt.func_74777_a("Damage", (short)ItemHelper.getItemDamage(stack));
        if (stack.func_77942_o()) {
            nbt.func_74782_a("tag", (NBTBase)stack.func_77978_p());
        }
        return nbt;
    }

    public static String getNameFromItemStack(ItemStack stack) {
        if (stack.func_190926_b() || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("display")) {
            return "";
        }
        return stack.func_77978_p().func_74775_l("display").func_74779_i("Name");
    }

    public static ItemStack consumeItem(ItemStack stack) {
        boolean largerStack;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        Item item = stack.func_77973_b();
        boolean bl = largerStack = stack.func_190916_E() > 1;
        if (largerStack) {
            stack.func_190918_g(1);
        }
        if (item.hasContainerItem(stack)) {
            ItemStack ret = item.getContainerItem(stack);
            if (ret.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (ret.func_77984_f() && ret.func_77952_i() > ret.func_77958_k()) {
                ret = ItemStack.field_190927_a;
            }
            return ret;
        }
        return largerStack ? stack : ItemStack.field_190927_a;
    }

    public static ItemStack consumeItem(ItemStack stack, EntityPlayer player) {
        boolean largerStack;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        Item item = stack.func_77973_b();
        boolean bl = largerStack = stack.func_190916_E() > 1;
        if (largerStack) {
            stack.func_190918_g(1);
        }
        if (item.hasContainerItem(stack)) {
            ItemStack ret = item.getContainerItem(stack);
            if (ret.func_190926_b() || ret.func_77984_f() && ret.func_77952_i() > ret.func_77958_k()) {
                ret = ItemStack.field_190927_a;
            }
            if (stack.func_190916_E() < 1) {
                return ret;
            }
            if (!ret.func_190926_b() && !player.field_71071_by.func_70441_a(ret)) {
                player.func_146097_a(ret, false, true);
            }
        }
        return largerStack ? stack : ItemStack.field_190927_a;
    }

    public static boolean disposePlayerItem(ItemStack stack, ItemStack dropStack, EntityPlayer entityplayer, boolean allowDrop) {
        return ItemHelper.disposePlayerItem(stack, dropStack, entityplayer, allowDrop, true);
    }

    public static boolean disposePlayerItem(ItemStack stack, ItemStack dropStack, EntityPlayer entityplayer, boolean allowDrop, boolean allowReplace) {
        if (entityplayer == null || entityplayer.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (allowReplace && stack.func_190916_E() <= 1) {
            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            entityplayer.field_71071_by.func_70441_a(dropStack);
            return true;
        }
        if (allowDrop) {
            stack.func_190918_g(1);
            if (!dropStack.func_190926_b() && !entityplayer.field_71071_by.func_70441_a(dropStack)) {
                entityplayer.func_146097_a(dropStack, false, true);
            }
            return true;
        }
        return false;
    }

    public static int getItemDamage(ItemStack stack) {
        return Items.field_151045_i.getDamage(stack);
    }

    public static IRecipe getCraftingRecipe(InventoryCrafting inv, World world) {
        return CraftingManager.func_192413_b((InventoryCrafting)inv, (World)world);
    }

    public static ItemStack getCraftingResult(InventoryCrafting inv, World world) {
        return CraftingManager.func_82787_a((InventoryCrafting)inv, (World)world);
    }

    public static ItemStack getOre(String oreName) {
        return oreProxy.getOre(oreName);
    }

    public static ItemStack getOre(String oreName, int amount) {
        return oreProxy.getOre(oreName, amount);
    }

    public static String getOreName(ItemStack stack) {
        return oreProxy.getOreName(stack);
    }

    public static boolean isOreIDEqual(ItemStack stack, int oreID) {
        return oreProxy.isOreIDEqual(stack, oreID);
    }

    public static boolean isOreNameEqual(ItemStack stack, String oreName) {
        return oreProxy.isOreNameEqual(stack, oreName);
    }

    public static boolean oreNameExists(String oreName) {
        return oreProxy.oreNameExists(oreName);
    }

    public static boolean hasOreName(ItemStack stack) {
        return !ItemHelper.getOreName(stack).equals("Unknown");
    }

    public static boolean isBlock(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(BLOCK);
    }

    public static boolean isOre(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(ORE);
    }

    public static boolean isDust(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(DUST);
    }

    public static boolean isIngot(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(INGOT);
    }

    public static boolean isNugget(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(NUGGET);
    }

    public static boolean isLog(ItemStack stack) {
        return ItemHelper.getOreName(stack).startsWith(LOG);
    }

    public static ItemStack stack(Item t) {
        return new ItemStack(t);
    }

    public static ItemStack stack(Item t, int s) {
        return new ItemStack(t, s);
    }

    public static ItemStack stack(Item t, int s, int m) {
        return new ItemStack(t, s, m);
    }

    public static ItemStack stack(Block t) {
        return new ItemStack(t);
    }

    public static ItemStack stack(Block t, int s) {
        return new ItemStack(t, s);
    }

    public static ItemStack stack(Block t, int s, int m) {
        return new ItemStack(t, s, m);
    }

    public static ItemStack stack2(Item t) {
        return new ItemStack(t, 1, Short.MAX_VALUE);
    }

    public static ItemStack stack2(Item t, int s) {
        return new ItemStack(t, s, Short.MAX_VALUE);
    }

    public static ItemStack stack2(Block t) {
        return new ItemStack(t, 1, Short.MAX_VALUE);
    }

    public static ItemStack stack2(Block t, int s) {
        return new ItemStack(t, s, Short.MAX_VALUE);
    }

    public static void registerWithHandlers(String oreName, ItemStack stack) {
        OreDictionary.registerOre((String)oreName, (ItemStack)stack);
    }

    public static boolean isPlayerHoldingMultiModeItem(EntityPlayer player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack heldItem = ItemHelper.getHeldStack(player);
        Item equipped = heldItem.func_77973_b();
        return equipped instanceof IMultiModeItem;
    }

    public static boolean incrHeldMultiModeItemState(EntityPlayer player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack heldItem = ItemHelper.getHeldStack(player);
        Item equipped = heldItem.func_77973_b();
        IMultiModeItem multiModeItem = (IMultiModeItem)equipped;
        return multiModeItem.incrMode(heldItem);
    }

    public static boolean decrHeldMultiModeItemState(EntityPlayer player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack equipped = ItemHelper.getHeldStack(player);
        IMultiModeItem multiModeItem = (IMultiModeItem)equipped.func_77973_b();
        return multiModeItem.incrMode(equipped);
    }

    public static boolean setHeldMultiModeItemState(EntityPlayer player, int mode) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack equipped = ItemHelper.getHeldStack(player);
        IMultiModeItem multiModeItem = (IMultiModeItem)equipped.func_77973_b();
        return multiModeItem.setMode(equipped, mode);
    }

    public static boolean isPlayerHoldingFluidHandler(EntityPlayer player) {
        return FluidHelper.isPlayerHoldingFluidHandler(player);
    }

    public static boolean isPlayerHoldingEnergyContainerItem(EntityPlayer player) {
        return EnergyHelper.isPlayerHoldingEnergyContainerItem(player);
    }

    public static boolean isPlayerHoldingNothing(EntityPlayer player) {
        return ItemHelper.getHeldStack(player).func_190926_b();
    }

    public static Item getItemFromStack(ItemStack theStack) {
        return theStack.func_190926_b() ? null : theStack.func_77973_b();
    }

    public static boolean isPlayerHoldingItem(Class<?> item, EntityPlayer player) {
        return item.isInstance(ItemHelper.getItemFromStack(ItemHelper.getHeldStack(player)));
    }

    public static boolean isPlayerHoldingItem(Item item, EntityPlayer player) {
        return ItemHelper.itemsEqual(item, ItemHelper.getItemFromStack(ItemHelper.getHeldStack(player)));
    }

    public static boolean isPlayerHoldingMainhand(Item item, EntityPlayer player) {
        return ItemHelper.itemsEqual(item, ItemHelper.getItemFromStack(ItemHelper.getMainhandStack(player)));
    }

    public static boolean isPlayerHoldingOffhand(Item item, EntityPlayer player) {
        return ItemHelper.itemsEqual(item, ItemHelper.getItemFromStack(ItemHelper.getOffhandStack(player)));
    }

    public static boolean isPlayerHoldingItemStack(ItemStack stack, EntityPlayer player) {
        return ItemHelper.itemsEqualWithMetadata(stack, ItemHelper.getHeldStack(player));
    }

    public static boolean itemsDamageEqual(ItemStack stackA, ItemStack stackB) {
        return !stackA.func_77981_g() && stackA.func_77958_k() == 0 || ItemHelper.getItemDamage(stackA) == ItemHelper.getItemDamage(stackB);
    }

    public static boolean itemsEqual(Item itemA, Item itemB) {
        return itemA != null && itemB != null && (itemA == itemB || itemA.equals(itemB));
    }

    public static boolean itemsEqualWithoutMetadata(ItemStack stackA, ItemStack stackB) {
        return stackA != null && stackB != null && ItemHelper.itemsEqual(stackA.func_77973_b(), stackB.func_77973_b());
    }

    public static boolean itemsEqualWithoutMetadata(ItemStack stackA, ItemStack stackB, boolean checkNBT) {
        return ItemHelper.itemsEqualWithoutMetadata(stackA, stackB) && (!checkNBT || ItemHelper.doNBTsMatch(stackA.func_77978_p(), stackB.func_77978_p()));
    }

    public static boolean itemsEqualWithMetadata(ItemStack stackA, ItemStack stackB) {
        return ItemHelper.itemsEqualWithoutMetadata(stackA, stackB) && ItemHelper.itemsDamageEqual(stackA, stackB);
    }

    public static boolean itemsEqualWithMetadata(ItemStack stackA, ItemStack stackB, boolean checkNBT) {
        return ItemHelper.itemsEqualWithMetadata(stackA, stackB) && (!checkNBT || ItemHelper.doNBTsMatch(stackA.func_77978_p(), stackB.func_77978_p()));
    }

    public static boolean itemsIdentical(ItemStack stackA, ItemStack stackB) {
        return ItemHelper.itemsEqualWithoutMetadata(stackA, stackB) && ItemHelper.getItemDamage(stackA) == ItemHelper.getItemDamage(stackB) && ItemHelper.doNBTsMatch(stackA.func_77978_p(), stackB.func_77978_p());
    }

    public static boolean doNBTsMatch(NBTTagCompound nbtA, NBTTagCompound nbtB) {
        return nbtA == null && nbtB == null || nbtA != null && nbtB != null && nbtA.equals((Object)nbtB);
    }

    public static boolean itemsEqualForCrafting(ItemStack stackA, ItemStack stackB) {
        return ItemHelper.itemsEqualWithoutMetadata(stackA, stackB) && (!stackA.func_77981_g() || ItemHelper.getItemDamage(stackA) == Short.MAX_VALUE || ItemHelper.getItemDamage(stackB) == Short.MAX_VALUE || ItemHelper.getItemDamage(stackB) == ItemHelper.getItemDamage(stackA));
    }

    public static boolean craftingEquivalent(ItemStack checked, ItemStack source, String oreDict, ItemStack output) {
        if (ItemHelper.itemsEqualForCrafting(checked, source)) {
            return true;
        }
        if (!output.func_190926_b() && ItemHelper.isBlacklist(output)) {
            return false;
        }
        if (oreDict == null || oreDict.equals("Unknown")) {
            return false;
        }
        return ItemHelper.getOreName(checked).equalsIgnoreCase(oreDict);
    }

    public static boolean doOreIDsMatch(ItemStack stackA, ItemStack stackB) {
        int id = oreProxy.getOreID(stackA);
        return id >= 0 && id == oreProxy.getOreID(stackB);
    }

    public static boolean isBlacklist(ItemStack output) {
        Item item = output.func_77973_b();
        return Item.func_150898_a((Block)Blocks.field_150487_bG) == item || Item.func_150898_a((Block)Blocks.field_150481_bH) == item || Item.func_150898_a((Block)Blocks.field_150476_ad) == item || Item.func_150898_a((Block)Blocks.field_150485_bF) == item || Item.func_150898_a((Block)Blocks.field_150344_f) == item || Item.func_150898_a((Block)Blocks.field_150376_bx) == item;
    }

    public static String getItemNBTString(ItemStack theItem, String nbtKey, String invalidReturn) {
        return theItem.func_77978_p() != null && theItem.func_77978_p().func_74764_b(nbtKey) ? theItem.func_77978_p().func_74779_i(nbtKey) : invalidReturn;
    }

    public static void addInventoryInformation(ItemStack stack, List<String> list) {
        ItemHelper.addInventoryInformation(stack, list, 0, Integer.MAX_VALUE);
    }

    public static void addInventoryInformation(ItemStack stack, List<String> list, int minSlot, int maxSlot) {
        if (stack.func_77978_p() == null) {
            list.add(StringHelper.localize("info.cofh.empty"));
            return;
        }
        if (stack.func_77973_b() instanceof IInventoryContainerItem && stack.func_77978_p().func_74764_b("Accessible")) {
            ItemHelper.addAccessibleInventoryInformation(stack, list, minSlot, maxSlot);
            return;
        }
        if (!stack.func_77978_p().func_150297_b("Inventory", 9) || stack.func_77978_p().func_150295_c("Inventory", (int)stack.func_77978_p().func_74732_a()).func_74745_c() <= 0) {
            list.add(StringHelper.localize("info.cofh.empty"));
            return;
        }
        NBTTagList nbtList = stack.func_77978_p().func_150295_c("Inventory", (int)stack.func_77978_p().func_74732_a());
        ArrayList<ItemStack> containedItems = new ArrayList<ItemStack>();
        boolean[] visited = new boolean[nbtList.func_74745_c()];
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound tag = nbtList.func_150305_b(i);
            int slot = tag.func_74762_e("Slot");
            if (visited[i] || slot < minSlot || slot > maxSlot) continue;
            visited[i] = true;
            ItemStack curStack = new ItemStack(tag);
            if (curStack.func_190926_b()) continue;
            containedItems.add(curStack);
            for (int j = 0; j < nbtList.func_74745_c(); ++j) {
                NBTTagCompound tag2 = nbtList.func_150305_b(j);
                int slot2 = tag.func_74762_e("Slot");
                if (visited[j] || slot2 < minSlot || slot2 > maxSlot) continue;
                ItemStack curStack2 = new ItemStack(tag2);
                if (curStack.func_190926_b() || !ItemHelper.itemsIdentical(curStack, curStack2)) continue;
                curStack.func_190917_f(curStack2.func_190916_E());
                visited[j] = true;
            }
        }
        if (containedItems.size() > 0) {
            list.add(StringHelper.localize("info.cofh.contents") + ":");
        }
        for (ItemStack item : containedItems) {
            int maxStackSize = item.func_77976_d();
            if (!StringHelper.displayStackCount || item.func_190916_E() < maxStackSize || maxStackSize == 1) {
                list.add("    \u00a76" + item.func_190916_E() + " " + StringHelper.getItemName(item));
                continue;
            }
            if (item.func_190916_E() % maxStackSize != 0) {
                list.add("    \u00a76" + maxStackSize + "x" + item.func_190916_E() / maxStackSize + "+" + item.func_190916_E() % maxStackSize + " " + StringHelper.getItemName(item));
                continue;
            }
            list.add("    \u00a76" + maxStackSize + "x" + item.func_190916_E() / maxStackSize + " " + StringHelper.getItemName(item));
        }
    }

    public static void addAccessibleInventoryInformation(ItemStack stack, List<String> list, int minSlot, int maxSlot) {
        int invSize = ((IInventoryContainerItem)stack.func_77973_b()).getSizeInventory(stack);
        ArrayList<ItemStack> containedItems = new ArrayList<ItemStack>();
        boolean[] visited = new boolean[invSize];
        NBTTagCompound tag = stack.func_77978_p();
        if (tag.func_74764_b("Inventory")) {
            tag = tag.func_74775_l("Inventory");
        }
        for (int i = minSlot; i < Math.min(invSize, maxSlot); ++i) {
            if (visited[i] || !tag.func_74764_b("Slot" + i)) continue;
            ItemStack curStack = new ItemStack(tag.func_74775_l("Slot" + i));
            visited[i] = true;
            if (curStack.func_190926_b()) continue;
            containedItems.add(curStack);
            for (int j = minSlot; j < Math.min(invSize, maxSlot); ++j) {
                ItemStack curStack2;
                if (visited[j] || !tag.func_74764_b("Slot" + j) || (curStack2 = new ItemStack(tag.func_74775_l("Slot" + j))).func_190926_b() || !ItemHelper.itemsIdentical(curStack, curStack2)) continue;
                curStack.func_190917_f(curStack2.func_190916_E());
                visited[j] = true;
            }
        }
        if (containedItems.size() > 0) {
            list.add(StringHelper.localize("info.cofh.contents") + ":");
        } else {
            list.add(StringHelper.localize("info.cofh.empty"));
        }
        for (ItemStack item : containedItems) {
            int maxStackSize = item.func_77976_d();
            if (!StringHelper.displayStackCount || item.func_190916_E() < maxStackSize || maxStackSize == 1) {
                list.add("    \u00a76" + item.func_190916_E() + " " + StringHelper.getItemName(item));
                continue;
            }
            if (item.func_190916_E() % maxStackSize != 0) {
                list.add("    \u00a76" + maxStackSize + "x" + item.func_190916_E() / maxStackSize + "+" + item.func_190916_E() % maxStackSize + " " + StringHelper.getItemName(item));
                continue;
            }
            list.add("    \u00a76" + maxStackSize + "x" + item.func_190916_E() / maxStackSize + " " + StringHelper.getItemName(item));
        }
    }

    public static boolean areItemStacksEqualIgnoreTags(ItemStack stackA, ItemStack stackB, String ... nbtTagsToIgnore) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (stackA.func_190926_b() && !stackB.func_190926_b()) {
            return false;
        }
        if (!stackA.func_190926_b() && stackB.func_190926_b()) {
            return false;
        }
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (stackA.func_77952_i() != stackB.func_77952_i()) {
            return false;
        }
        if (stackA.func_190916_E() != stackB.func_190916_E()) {
            return false;
        }
        if (stackA.func_77978_p() == null && stackB.func_77978_p() == null) {
            return true;
        }
        if (stackA.func_77978_p() == null && stackB.func_77978_p() != null) {
            return false;
        }
        if (stackA.func_77978_p() != null && stackB.func_77978_p() == null) {
            return false;
        }
        int numberOfKeys = stackA.func_77978_p().func_150296_c().size();
        if (numberOfKeys != stackB.func_77978_p().func_150296_c().size()) {
            return false;
        }
        NBTTagCompound tagA = stackA.func_77978_p();
        NBTTagCompound tagB = stackB.func_77978_p();
        String[] keys = new String[numberOfKeys];
        keys = tagA.func_150296_c().toArray(keys);
        block0: for (int i = 0; i < numberOfKeys; ++i) {
            for (int j = 0; j < nbtTagsToIgnore.length; ++j) {
                if (nbtTagsToIgnore[j].equals(keys[i])) continue block0;
            }
            if (tagA.func_74781_a(keys[i]).equals((Object)tagB.func_74781_a(keys[i]))) continue;
            return false;
        }
        return true;
    }
}

