/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.definitions.IDefinitions;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternOutputs;
import appeng.container.slot.SlotPatternTerm;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.sync.packets.PacketPatternSlot;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ItemViewCell;
import appeng.me.helpers.MachineSource;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class ContainerPatternTerm
extends ContainerMEMonitorable
implements IAEAppEngInventory,
IOptionalSlotHost,
IContainerCraftingPacket {
    private final PartPatternTerminal patternTerminal;
    private final AppEngInternalInventory cOut = new AppEngInternalInventory(null, 1);
    private final IItemHandler crafting;
    private final SlotFakeCraftingMatrix[] craftingSlots = new SlotFakeCraftingMatrix[9];
    private final OptionalSlotFake[] outputSlots = new OptionalSlotFake[3];
    private final SlotPatternTerm craftSlot;
    private final SlotRestrictedInput patternSlotIN;
    private final SlotRestrictedInput patternSlotOUT;
    @GuiSync(value=97)
    public boolean craftingMode = true;
    @GuiSync(value=96)
    public boolean substitute = false;

    public ContainerPatternTerm(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable, false);
        int y;
        this.patternTerminal = (PartPatternTerminal)monitorable;
        IItemHandler patternInv = this.getPatternTerminal().getInventoryByName("pattern");
        IItemHandler output = this.getPatternTerminal().getInventoryByName("output");
        this.crafting = this.getPatternTerminal().getInventoryByName("crafting");
        for (y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                SlotFakeCraftingMatrix slotFakeCraftingMatrix = new SlotFakeCraftingMatrix(this.crafting, x + y * 3, 18 + x * 18, -76 + y * 18);
                this.craftingSlots[x + y * 3] = slotFakeCraftingMatrix;
                this.func_75146_a(slotFakeCraftingMatrix);
            }
        }
        this.craftSlot = new SlotPatternTerm(ip.field_70458_d, this.getActionSource(), this.getPowerSource(), monitorable, this.crafting, patternInv, (IItemHandler)this.cOut, 110, -58, this, 2, this);
        this.func_75146_a(this.craftSlot);
        this.craftSlot.setIIcon(-1);
        for (y = 0; y < 3; ++y) {
            this.outputSlots[y] = new SlotPatternOutputs(output, this, y, 110, -76 + y * 18, 0, 0, 1);
            this.func_75146_a(this.outputSlots[y]);
            this.outputSlots[y].setRenderDisabled(false);
            this.outputSlots[y].setIIcon(-1);
        }
        this.patternSlotIN = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, patternInv, 0, 147, -81, this.getInventoryPlayer());
        this.func_75146_a(this.patternSlotIN);
        this.patternSlotOUT = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, patternInv, 1, 147, -38, this.getInventoryPlayer());
        this.func_75146_a(this.patternSlotOUT);
        this.patternSlotOUT.setStackLimit(1);
        this.bindPlayerInventory(ip, 0, 0);
        this.updateOrderOfOutputSlots();
    }

    private void updateOrderOfOutputSlots() {
        if (!this.isCraftingMode()) {
            this.craftSlot.field_75223_e = -9000;
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].field_75223_e = this.outputSlots[y].getX();
            }
        } else {
            this.craftSlot.field_75223_e = this.craftSlot.getX();
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].field_75223_e = -9000;
            }
        }
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        super.func_75141_a(slotID, stack);
        this.getAndUpdateOutput();
    }

    private ItemStack getAndUpdateOutput() {
        InventoryCrafting ic = new InventoryCrafting((Container)this, 3, 3);
        for (int x = 0; x < ic.func_70302_i_(); ++x) {
            ic.func_70299_a(x, this.crafting.getStackInSlot(x));
        }
        ItemStack is = CraftingManager.func_82787_a((InventoryCrafting)ic, (World)this.getPlayerInv().field_70458_d.field_70170_p);
        this.cOut.setStackInSlot(0, is);
        return is;
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public void encode() {
        ItemStack output = this.patternSlotOUT.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null) {
            return;
        }
        if (!output.func_190926_b() && !this.isPattern(output)) {
            return;
        }
        if (output.func_190926_b()) {
            Optional<ItemStack> maybePattern;
            output = this.patternSlotIN.func_75211_c();
            if (output.func_190926_b() || !this.isPattern(output)) {
                return;
            }
            output.func_190920_e(output.func_190916_E() - 1);
            if (output.func_190916_E() == 0) {
                this.patternSlotIN.func_75215_d(ItemStack.field_190927_a);
            }
            if ((maybePattern = AEApi.instance().definitions().items().encodedPattern().maybeStack(1)).isPresent()) {
                output = maybePattern.get();
                this.patternSlotOUT.func_75215_d(output);
            }
        }
        NBTTagCompound encodedValue = new NBTTagCompound();
        NBTTagList tagIn = new NBTTagList();
        NBTTagList tagOut = new NBTTagList();
        for (ItemStack i : in) {
            tagIn.func_74742_a(this.createItemTag(i));
        }
        for (ItemStack i : out) {
            tagOut.func_74742_a(this.createItemTag(i));
        }
        encodedValue.func_74782_a("in", (NBTBase)tagIn);
        encodedValue.func_74782_a("out", (NBTBase)tagOut);
        encodedValue.func_74757_a("crafting", this.isCraftingMode());
        encodedValue.func_74757_a("substitute", this.isSubstitute());
        output.func_77982_d(encodedValue);
    }

    private ItemStack[] getInputs() {
        ItemStack[] input = new ItemStack[9];
        boolean hasValue = false;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].func_75211_c();
            if (input[x].func_190926_b()) continue;
            hasValue = true;
        }
        if (hasValue) {
            return input;
        }
        return null;
    }

    private ItemStack[] getOutputs() {
        if (this.isCraftingMode()) {
            ItemStack out = this.getAndUpdateOutput();
            if (!out.func_190926_b() && out.func_190916_E() > 0) {
                return new ItemStack[]{out};
            }
        } else {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(3);
            boolean hasValue = false;
            for (OptionalSlotFake outputSlot : this.outputSlots) {
                ItemStack out = outputSlot.func_75211_c();
                if (out.func_190926_b() || out.func_190916_E() <= 0) continue;
                list.add(out);
                hasValue = true;
            }
            if (hasValue) {
                return list.toArray(new ItemStack[list.size()]);
            }
        }
        return null;
    }

    private boolean isPattern(ItemStack output) {
        if (output.func_190926_b()) {
            return false;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        boolean isPattern = definitions.items().encodedPattern().isSameAs(output);
        return isPattern |= definitions.materials().blankPattern().isSameAs(output);
    }

    private NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (!i.func_190926_b()) {
            i.func_77955_b(c);
        }
        return c;
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        if (idx == 1) {
            return Platform.isServer() ? !this.getPatternTerminal().isCraftingRecipe() : !this.isCraftingMode();
        }
        if (idx == 2) {
            return Platform.isServer() ? this.getPatternTerminal().isCraftingRecipe() : this.isCraftingMode();
        }
        return false;
    }

    public void craftOrGetItem(PacketPatternSlot packetPatternSlot) {
        if (packetPatternSlot.slotItem != null && this.getCellInventory() != null) {
            IAEItemStack out = packetPatternSlot.slotItem.copy();
            InventoryAdaptor inv = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(this.getPlayerInv().field_70458_d.field_71071_by));
            InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor(this.getPlayerInv().field_70458_d);
            if (packetPatternSlot.shift) {
                inv = playerInv;
            }
            if (!inv.simulateAdd(out.createItemStack()).func_190926_b()) {
                return;
            }
            IAEItemStack extracted = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), out, this.getActionSource());
            EntityPlayer p = this.getPlayerInv().field_70458_d;
            if (extracted != null) {
                inv.addItems(extracted.createItemStack());
                if (p instanceof EntityPlayerMP) {
                    this.updateHeld((EntityPlayerMP)p);
                }
                this.func_75142_b();
                return;
            }
            InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            InventoryCrafting real = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            for (int x = 0; x < 9; ++x) {
                ic.func_70299_a(x, packetPatternSlot.pattern[x] == null ? ItemStack.field_190927_a : packetPatternSlot.pattern[x].createItemStack());
            }
            IRecipe r = CraftingManager.func_192413_b((InventoryCrafting)ic, (World)p.field_70170_p);
            if (r == null) {
                return;
            }
            IMEMonitor<IAEItemStack> storage = this.getPatternTerminal().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            IItemList<IAEItemStack> all = storage.getStorageList();
            ItemStack is = r.func_77572_b(ic);
            for (int x = 0; x < ic.func_70302_i_(); ++x) {
                if (ic.func_70301_a(x).func_190926_b()) continue;
                ItemStack pulled = Platform.extractItemsByRecipe(this.getPowerSource(), this.getActionSource(), storage, p.field_70170_p, r, is, ic, ic.func_70301_a(x), x, all, Actionable.MODULATE, ItemViewCell.createFilter(this.getViewCells()));
                real.func_70299_a(x, pulled);
            }
            IRecipe rr = CraftingManager.func_192413_b((InventoryCrafting)real, (World)p.field_70170_p);
            if (rr == r && Platform.itemComparisons().isSameItem(rr.func_77572_b(real), is)) {
                InventoryCraftResult craftingResult = new InventoryCraftResult();
                craftingResult.func_193056_a(rr);
                SlotCrafting sc = new SlotCrafting(p, real, (IInventory)craftingResult, 0, 0, 0);
                sc.func_190901_a(p, is);
                for (int x = 0; x < real.func_70302_i_(); ++x) {
                    ItemStack failed = playerInv.addItems(real.func_70301_a(x));
                    if (failed.func_190926_b()) continue;
                    p.func_71019_a(failed, false);
                }
                inv.addItems(is);
                if (p instanceof EntityPlayerMP) {
                    this.updateHeld((EntityPlayerMP)p);
                }
                this.func_75142_b();
            } else {
                for (int x = 0; x < real.func_70302_i_(); ++x) {
                    ItemStack failed = real.func_70301_a(x);
                    if (failed.func_190926_b()) continue;
                    this.getCellInventory().injectItems(AEItemStack.fromItemStack(failed), Actionable.MODULATE, new MachineSource(this.getPatternTerminal()));
                }
            }
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer()) {
            if (this.isCraftingMode() != this.getPatternTerminal().isCraftingRecipe()) {
                this.setCraftingMode(this.getPatternTerminal().isCraftingRecipe());
                this.updateOrderOfOutputSlots();
            }
            this.substitute = this.patternTerminal.isSubstitution();
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (field.equals("craftingMode")) {
            this.getAndUpdateOutput();
            this.updateOrderOfOutputSlots();
        }
    }

    @Override
    public void onSlotChange(Slot s) {
        if (s == this.patternSlotOUT && Platform.isServer()) {
            for (IContainerListener listener : this.field_75149_d) {
                for (Slot slot : this.field_75151_b) {
                    if (!(slot instanceof OptionalSlotFake) && !(slot instanceof SlotFakeCraftingMatrix)) continue;
                    listener.func_71111_a((Container)this, slot.field_75222_d, slot.func_75211_c());
                }
                if (!(listener instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)listener).field_71137_h = false;
            }
            this.func_75142_b();
        }
        if (s == this.craftSlot && Platform.isClient()) {
            this.getAndUpdateOutput();
        }
    }

    public void clear() {
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingSlots) {
            slotFakeCraftingMatrix.func_75215_d(ItemStack.field_190927_a);
        }
        for (SlotFake slotFake : this.outputSlots) {
            slotFake.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
        this.getAndUpdateOutput();
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("player")) {
            return new PlayerInvWrapper(this.getInventoryPlayer());
        }
        return this.getPatternTerminal().getInventoryByName(name);
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    public void toggleSubstitute() {
        this.substitute = !this.substitute;
        this.func_75142_b();
        this.getAndUpdateOutput();
    }

    public boolean isCraftingMode() {
        return this.craftingMode;
    }

    private void setCraftingMode(boolean craftingMode) {
        this.craftingMode = craftingMode;
    }

    public PartPatternTerminal getPatternTerminal() {
        return this.patternTerminal;
    }

    private boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        this.substitute = substitute;
    }
}

