/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.gui.implementations.GuiCraftingCPU;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerCellWorkbench;
import appeng.container.implementations.ContainerCraftConfirm;
import appeng.container.implementations.ContainerCraftingCPU;
import appeng.container.implementations.ContainerCraftingStatus;
import appeng.container.implementations.ContainerLevelEmitter;
import appeng.container.implementations.ContainerNetworkTool;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.implementations.ContainerPriority;
import appeng.container.implementations.ContainerQuartzKnife;
import appeng.container.implementations.ContainerSecurityStation;
import appeng.container.implementations.ContainerStorageBus;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.IMouseWheelItem;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class PacketValueConfig
extends AppEngPacket {
    private final String Name;
    private final String Value;

    public PacketValueConfig(ByteBuf stream) throws IOException {
        DataInputStream dis = new DataInputStream(this.getPacketByteArray(stream, stream.readerIndex(), stream.readableBytes()));
        this.Name = dis.readUTF();
        this.Value = dis.readUTF();
    }

    public PacketValueConfig(String name, String value) throws IOException {
        this.Name = name;
        this.Value = value;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeUTF(name);
        dos.writeUTF(value);
        data.writeBytes(bos.toByteArray());
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        block9: {
            Container c;
            block28: {
                block24: {
                    ContainerCellWorkbench ccw;
                    block25: {
                        block27: {
                            block26: {
                                block22: {
                                    ContainerStorageBus ccw2;
                                    block23: {
                                        block18: {
                                            ContainerPatternTerm cpt;
                                            block21: {
                                                block20: {
                                                    block19: {
                                                        block17: {
                                                            block16: {
                                                                block15: {
                                                                    block14: {
                                                                        block13: {
                                                                            block12: {
                                                                                block11: {
                                                                                    block10: {
                                                                                        block8: {
                                                                                            EnumHand hand;
                                                                                            c = player.field_71070_bA;
                                                                                            if (!this.Name.equals("Item") || (player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() || !(player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IMouseWheelItem)) && (player.func_184586_b(EnumHand.OFF_HAND).func_190926_b() || !(player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof IMouseWheelItem))) break block8;
                                                                                            if (!player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IMouseWheelItem) {
                                                                                                hand = EnumHand.MAIN_HAND;
                                                                                            } else if (!player.func_184586_b(EnumHand.OFF_HAND).func_190926_b() && player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof IMouseWheelItem) {
                                                                                                hand = EnumHand.OFF_HAND;
                                                                                            } else {
                                                                                                return;
                                                                                            }
                                                                                            ItemStack is = player.func_184586_b(hand);
                                                                                            IMouseWheelItem si = (IMouseWheelItem)is.func_77973_b();
                                                                                            si.onWheel(is, this.Value.equals("WheelUp"));
                                                                                            break block9;
                                                                                        }
                                                                                        if (!this.Name.equals("Terminal.Cpu") || !(c instanceof ContainerCraftingStatus)) break block10;
                                                                                        ContainerCraftingStatus qk = (ContainerCraftingStatus)c;
                                                                                        qk.cycleCpu(this.Value.equals("Next"));
                                                                                        break block9;
                                                                                    }
                                                                                    if (!this.Name.equals("Terminal.Cpu") || !(c instanceof ContainerCraftConfirm)) break block11;
                                                                                    ContainerCraftConfirm qk = (ContainerCraftConfirm)c;
                                                                                    qk.cycleCpu(this.Value.equals("Next"));
                                                                                    break block9;
                                                                                }
                                                                                if (!this.Name.equals("Terminal.Start") || !(c instanceof ContainerCraftConfirm)) break block12;
                                                                                ContainerCraftConfirm qk = (ContainerCraftConfirm)c;
                                                                                qk.startJob();
                                                                                break block9;
                                                                            }
                                                                            if (!this.Name.equals("TileCrafting.Cancel") || !(c instanceof ContainerCraftingCPU)) break block13;
                                                                            ContainerCraftingCPU qk = (ContainerCraftingCPU)c;
                                                                            qk.cancelCrafting();
                                                                            break block9;
                                                                        }
                                                                        if (!this.Name.equals("QuartzKnife.Name") || !(c instanceof ContainerQuartzKnife)) break block14;
                                                                        ContainerQuartzKnife qk = (ContainerQuartzKnife)c;
                                                                        qk.setName(this.Value);
                                                                        break block9;
                                                                    }
                                                                    if (!this.Name.equals("TileSecurityStation.ToggleOption") || !(c instanceof ContainerSecurityStation)) break block15;
                                                                    ContainerSecurityStation sc = (ContainerSecurityStation)c;
                                                                    sc.toggleSetting(this.Value, player);
                                                                    break block9;
                                                                }
                                                                if (!this.Name.equals("PriorityHost.Priority") || !(c instanceof ContainerPriority)) break block16;
                                                                ContainerPriority pc = (ContainerPriority)c;
                                                                pc.setPriority(Integer.parseInt(this.Value), player);
                                                                break block9;
                                                            }
                                                            if (!this.Name.equals("LevelEmitter.Value") || !(c instanceof ContainerLevelEmitter)) break block17;
                                                            ContainerLevelEmitter lvc = (ContainerLevelEmitter)c;
                                                            lvc.setLevel(Long.parseLong(this.Value), player);
                                                            break block9;
                                                        }
                                                        if (!this.Name.startsWith("PatternTerminal.") || !(c instanceof ContainerPatternTerm)) break block18;
                                                        cpt = (ContainerPatternTerm)c;
                                                        if (!this.Name.equals("PatternTerminal.CraftMode")) break block19;
                                                        cpt.getPatternTerminal().setCraftingRecipe(this.Value.equals("1"));
                                                        break block9;
                                                    }
                                                    if (!this.Name.equals("PatternTerminal.Encode")) break block20;
                                                    cpt.encode();
                                                    break block9;
                                                }
                                                if (!this.Name.equals("PatternTerminal.Clear")) break block21;
                                                cpt.clear();
                                                break block9;
                                            }
                                            if (!this.Name.equals("PatternTerminal.Substitute")) break block9;
                                            cpt.getPatternTerminal().setSubstitution(this.Value.equals("1"));
                                            break block9;
                                        }
                                        if (!this.Name.startsWith("StorageBus.") || !(c instanceof ContainerStorageBus)) break block22;
                                        ccw2 = (ContainerStorageBus)c;
                                        if (!this.Name.equals("StorageBus.Action")) break block9;
                                        if (!this.Value.equals("Partition")) break block23;
                                        ccw2.partition();
                                        break block9;
                                    }
                                    if (!this.Value.equals("Clear")) break block9;
                                    ccw2.clear();
                                    break block9;
                                }
                                if (!this.Name.startsWith("CellWorkbench.") || !(c instanceof ContainerCellWorkbench)) break block24;
                                ccw = (ContainerCellWorkbench)c;
                                if (!this.Name.equals("CellWorkbench.Action")) break block25;
                                if (!this.Value.equals("CopyMode")) break block26;
                                ccw.nextWorkBenchCopyMode();
                                break block9;
                            }
                            if (!this.Value.equals("Partition")) break block27;
                            ccw.partition();
                            break block9;
                        }
                        if (!this.Value.equals("Clear")) break block9;
                        ccw.clear();
                        break block9;
                    }
                    if (!this.Name.equals("CellWorkbench.Fuzzy")) break block9;
                    ccw.setFuzzy(FuzzyMode.valueOf(this.Value));
                    break block9;
                }
                if (!(c instanceof ContainerNetworkTool)) break block28;
                if (!this.Name.equals("NetworkTool") || !this.Value.equals("Toggle")) break block9;
                ((ContainerNetworkTool)c).toggleFacadeMode();
                break block9;
            }
            if (c instanceof IConfigurableObject) {
                IConfigManager cm = ((IConfigurableObject)c).getConfigManager();
                for (Settings e : cm.getSettings()) {
                    if (!e.name().equals(this.Name)) continue;
                    Enum<?> def = cm.getSetting(e);
                    try {
                        cm.putSetting(e, (Enum<?>)Enum.valueOf(def.getClass(), this.Value));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
            }
        }
    }

    @Override
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        block5: {
            Container c;
            block7: {
                block6: {
                    block4: {
                        c = player.field_71070_bA;
                        if (!this.Name.equals("CustomName") || !(c instanceof AEBaseContainer)) break block4;
                        ((AEBaseContainer)c).setCustomName(this.Value);
                        break block5;
                    }
                    if (!this.Name.startsWith("SyncDat.")) break block6;
                    ((AEBaseContainer)c).stringSync(Integer.parseInt(this.Name.substring(8)), this.Value);
                    break block5;
                }
                if (!this.Name.equals("CraftingStatus") || !this.Value.equals("Clear")) break block7;
                GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
                if (!(gs instanceof GuiCraftingCPU)) break block5;
                ((GuiCraftingCPU)gs).clearItems();
                break block5;
            }
            if (c instanceof IConfigurableObject) {
                IConfigManager cm = ((IConfigurableObject)c).getConfigManager();
                for (Settings e : cm.getSettings()) {
                    if (!e.name().equals(this.Name)) continue;
                    Enum<?> def = cm.getSetting(e);
                    try {
                        cm.putSetting(e, (Enum<?>)Enum.valueOf(def.getClass(), this.Value));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    break;
                }
            }
        }
    }
}

