/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelChanged;
import appeng.api.networking.events.MENetworkControllerChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.features.AEFeature;
import appeng.core.stats.IAdvancementTrigger;
import appeng.me.GridConnection;
import appeng.me.GridNode;
import appeng.me.pathfinding.AdHocChannelUpdater;
import appeng.me.pathfinding.ControllerChannelUpdater;
import appeng.me.pathfinding.ControllerValidator;
import appeng.me.pathfinding.IPathItem;
import appeng.me.pathfinding.PathSegment;
import appeng.tile.networking.TileController;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PathGridCache
implements IPathingGrid {
    private final LinkedList<PathSegment> active = new LinkedList();
    private final Set<TileController> controllers = new HashSet<TileController>();
    private final Set<IGridNode> requireChannels = new HashSet<IGridNode>();
    private final Set<IGridNode> blockDense = new HashSet<IGridNode>();
    private final IGrid myGrid;
    private int channelsInUse = 0;
    private int channelsByBlocks = 0;
    private double channelPowerUsage = 0.0;
    private boolean recalculateControllerNextTick = true;
    private boolean updateNetwork = true;
    private boolean booting = false;
    private ControllerState controllerState = ControllerState.NO_CONTROLLER;
    private int ticksUntilReady = 20;
    private int lastChannels = 0;
    private HashSet<IPathItem> semiOpen = new HashSet();

    public PathGridCache(IGrid g) {
        this.myGrid = g;
    }

    @Override
    public void onUpdateTick() {
        if (this.recalculateControllerNextTick) {
            this.recalcController();
        }
        if (this.updateNetwork) {
            if (!this.booting) {
                this.myGrid.postEvent(new MENetworkBootingStatusChange());
            }
            this.booting = true;
            this.updateNetwork = false;
            this.setChannelsInUse(0);
            if (!AEConfig.instance().isFeatureEnabled(AEFeature.CHANNELS)) {
                int used = this.calculateRequiredChannels();
                int nodes = this.myGrid.getNodes().size();
                this.ticksUntilReady = 20 + Math.max(0, nodes / 100 - 20);
                this.setChannelsByBlocks(nodes * used);
                this.setChannelPowerUsage((double)this.getChannelsByBlocks() / 128.0);
                this.myGrid.getPivot().beginVisit(new AdHocChannelUpdater(used));
            } else if (this.controllerState == ControllerState.NO_CONTROLLER) {
                int requiredChannels;
                int used = requiredChannels = this.calculateRequiredChannels();
                if (requiredChannels > 8) {
                    used = 0;
                }
                int nodes = this.myGrid.getNodes().size();
                this.setChannelsInUse(used);
                this.ticksUntilReady = 20 + Math.max(0, nodes / 100 - 20);
                this.setChannelsByBlocks(nodes * used);
                this.setChannelPowerUsage((double)this.getChannelsByBlocks() / 128.0);
                this.myGrid.getPivot().beginVisit(new AdHocChannelUpdater(used));
            } else if (this.controllerState == ControllerState.CONTROLLER_CONFLICT) {
                this.ticksUntilReady = 20;
                this.myGrid.getPivot().beginVisit(new AdHocChannelUpdater(0));
            } else {
                int nodes = this.myGrid.getNodes().size();
                this.ticksUntilReady = 20 + Math.max(0, nodes / 100 - 20);
                HashSet<IPathItem> closedList = new HashSet<IPathItem>();
                this.semiOpen = new HashSet();
                for (IGridNode node : this.myGrid.getMachines(TileController.class)) {
                    closedList.add((IPathItem)((Object)node));
                    for (IGridConnection gcc : node.getConnections()) {
                        GridConnection gc = (GridConnection)gcc;
                        if (gc.getOtherSide(node).getMachine() instanceof TileController) continue;
                        LinkedList<IPathItem> open = new LinkedList<IPathItem>();
                        closedList.add(gc);
                        open.add(gc);
                        gc.setControllerRoute((GridNode)node, true);
                        this.active.add(new PathSegment(this, open, this.semiOpen, closedList));
                    }
                }
            }
        }
        if (!this.active.isEmpty() || this.ticksUntilReady > 0) {
            Iterator i = this.active.iterator();
            while (i.hasNext()) {
                PathSegment pat = (PathSegment)i.next();
                if (!pat.step()) continue;
                pat.setDead(true);
                i.remove();
            }
            --this.ticksUntilReady;
            if (this.active.isEmpty() && this.ticksUntilReady <= 0) {
                Iterator<TileController> controllerIterator;
                if (this.controllerState == ControllerState.CONTROLLER_ONLINE && (controllerIterator = this.controllers.iterator()).hasNext()) {
                    TileController controller = controllerIterator.next();
                    controller.getGridNode(AEPartLocation.INTERNAL).beginVisit(new ControllerChannelUpdater());
                }
                this.achievementPost();
                this.booting = false;
                this.setChannelPowerUsage((double)this.getChannelsByBlocks() / 128.0);
                this.myGrid.postEvent(new MENetworkBootingStatusChange());
            }
        }
    }

    @Override
    public void removeNode(IGridNode gridNode, IGridHost machine) {
        EnumSet<GridFlags> flags;
        if (machine instanceof TileController) {
            this.controllers.remove(machine);
            this.recalculateControllerNextTick = true;
        }
        if ((flags = gridNode.getGridBlock().getFlags()).contains((Object)GridFlags.REQUIRE_CHANNEL)) {
            this.requireChannels.remove(gridNode);
        }
        if (flags.contains((Object)GridFlags.CANNOT_CARRY_COMPRESSED)) {
            this.blockDense.remove(gridNode);
        }
        this.repath();
    }

    @Override
    public void addNode(IGridNode gridNode, IGridHost machine) {
        EnumSet<GridFlags> flags;
        if (machine instanceof TileController) {
            this.controllers.add((TileController)machine);
            this.recalculateControllerNextTick = true;
        }
        if ((flags = gridNode.getGridBlock().getFlags()).contains((Object)GridFlags.REQUIRE_CHANNEL)) {
            this.requireChannels.add(gridNode);
        }
        if (flags.contains((Object)GridFlags.CANNOT_CARRY_COMPRESSED)) {
            this.blockDense.add(gridNode);
        }
        this.repath();
    }

    @Override
    public void onSplit(IGridStorage storageB) {
    }

    @Override
    public void onJoin(IGridStorage storageB) {
    }

    @Override
    public void populateGridStorage(IGridStorage storage) {
    }

    private void recalcController() {
        this.recalculateControllerNextTick = false;
        ControllerState old = this.controllerState;
        if (this.controllers.isEmpty()) {
            this.controllerState = ControllerState.NO_CONTROLLER;
        } else {
            IGridNode startingNode = this.controllers.iterator().next().getGridNode(AEPartLocation.INTERNAL);
            if (startingNode == null) {
                this.controllerState = ControllerState.CONTROLLER_CONFLICT;
                return;
            }
            DimensionalCoord dc = startingNode.getGridBlock().getLocation();
            ControllerValidator cv = new ControllerValidator(dc.x, dc.y, dc.z);
            startingNode.beginVisit(cv);
            this.controllerState = cv.isValid() && cv.getFound() == this.controllers.size() ? ControllerState.CONTROLLER_ONLINE : ControllerState.CONTROLLER_CONFLICT;
        }
        if (old != this.controllerState) {
            this.myGrid.postEvent(new MENetworkControllerChange());
        }
    }

    private int calculateRequiredChannels() {
        this.semiOpen.clear();
        int depth = 0;
        for (IGridNode nodes : this.requireChannels) {
            if (this.semiOpen.contains(nodes)) continue;
            IGridBlock gb = nodes.getGridBlock();
            EnumSet<GridFlags> flags = gb.getFlags();
            if (flags.contains((Object)GridFlags.COMPRESSED_CHANNEL) && !this.blockDense.isEmpty()) {
                return 9;
            }
            ++depth;
            if (!flags.contains((Object)GridFlags.MULTIBLOCK)) continue;
            IGridMultiblock gmb = (IGridMultiblock)gb;
            Iterator<IGridNode> i = gmb.getMultiblockNodes();
            while (i.hasNext()) {
                this.semiOpen.add((IPathItem)((Object)i.next()));
            }
        }
        return depth;
    }

    private void achievementPost() {
        IAdvancementTrigger lastBracket;
        IAdvancementTrigger currentBracket;
        if (this.lastChannels != this.getChannelsInUse() && AEConfig.instance().isFeatureEnabled(AEFeature.CHANNELS) && (currentBracket = this.getAchievementBracket(this.getChannelsInUse())) != (lastBracket = this.getAchievementBracket(this.lastChannels)) && currentBracket != null) {
            for (IGridNode n : this.requireChannels) {
                EntityPlayer player = AEApi.instance().registries().players().findPlayer(n.getPlayerID());
                if (!(player instanceof EntityPlayerMP)) continue;
                currentBracket.trigger((EntityPlayerMP)player);
            }
        }
        this.lastChannels = this.getChannelsInUse();
    }

    private IAdvancementTrigger getAchievementBracket(int ch) {
        if (ch < 8) {
            return null;
        }
        if (ch < 128) {
            return AppEng.instance().getAdvancementTriggers().getNetworkApprentice();
        }
        if (ch < 2048) {
            return AppEng.instance().getAdvancementTriggers().getNetworkEngineer();
        }
        return AppEng.instance().getAdvancementTriggers().getNetworkAdmin();
    }

    @MENetworkEventSubscribe
    void updateNodReq(MENetworkChannelChanged ev) {
        IGridNode gridNode = ev.node;
        if (gridNode.getGridBlock().getFlags().contains((Object)GridFlags.REQUIRE_CHANNEL)) {
            this.requireChannels.add(gridNode);
        } else {
            this.requireChannels.remove(gridNode);
        }
        this.repath();
    }

    @Override
    public boolean isNetworkBooting() {
        return !this.active.isEmpty() && !this.booting;
    }

    @Override
    public ControllerState getControllerState() {
        return this.controllerState;
    }

    @Override
    public void repath() {
        this.active.clear();
        this.setChannelsByBlocks(0);
        this.updateNetwork = true;
    }

    double getChannelPowerUsage() {
        return this.channelPowerUsage;
    }

    private void setChannelPowerUsage(double channelPowerUsage) {
        this.channelPowerUsage = channelPowerUsage;
    }

    public int getChannelsByBlocks() {
        return this.channelsByBlocks;
    }

    public void setChannelsByBlocks(int channelsByBlocks) {
        this.channelsByBlocks = channelsByBlocks;
    }

    public int getChannelsInUse() {
        return this.channelsInUse;
    }

    public void setChannelsInUse(int channelsInUse) {
        this.channelsInUse = channelsInUse;
    }
}

