/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.items.contents.CellConfig;
import appeng.me.storage.CellInventoryHandler;
import appeng.util.item.AEItemStack;
import net.minecraft.item.ItemStack;

public class CreativeCellInventory
implements IMEInventoryHandler<IAEItemStack> {
    private final IItemList<IAEItemStack> itemListCache = AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createList();

    protected CreativeCellInventory(ItemStack o) {
        CellConfig cc = new CellConfig(o);
        for (ItemStack is : cc) {
            if (is.func_190926_b()) continue;
            AEItemStack i = AEItemStack.fromItemStack(is);
            i.setStackSize(Integer.MAX_VALUE);
            this.itemListCache.add(i);
        }
    }

    public static IMEInventoryHandler getCell(ItemStack o) {
        return new CellInventoryHandler(new CreativeCellInventory(o));
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, IActionSource src) {
        IAEItemStack local = this.itemListCache.findPrecise(input);
        if (local == null) {
            return input;
        }
        return null;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, IActionSource src) {
        IAEItemStack local = this.itemListCache.findPrecise(request);
        if (local == null) {
            return null;
        }
        return request.copy();
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList out) {
        for (IAEItemStack ais : this.itemListCache) {
            out.add(ais);
        }
        return out;
    }

    @Override
    public IStorageChannel getChannel() {
        return AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    }

    @Override
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Override
    public boolean isPrioritized(IAEItemStack input) {
        return this.itemListCache.findPrecise(input) != null;
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        return this.itemListCache.findPrecise(input) != null;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }
}

