/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.AppEng;
import appeng.core.settings.TickRates;
import appeng.core.sync.packets.PacketTransitionEffect;
import appeng.hooks.TickHandler;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartBasicState;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModels;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PartAnnihilationPlane
extends PartBasicState
implements IGridTickable,
IWorldCallable<TickRateModulation> {
    private static final PlaneModels MODELS = new PlaneModels("part/annihilation_plane_", "part/annihilation_plane_on_");
    private final IActionSource mySrc = new MachineSource(this);
    private boolean isAccepting = true;
    private boolean breaking = false;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public PartAnnihilationPlane(ItemStack is) {
        super(is);
    }

    @Override
    public TickRateModulation call(World world) throws Exception {
        this.breaking = false;
        return this.breakBlock(true);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        boolean minX = true;
        boolean minY = true;
        int maxX = 15;
        int maxY = 15;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            BlockPos pos = te.func_174877_v();
            EnumFacing e = bch.getWorldX();
            EnumFacing u = bch.getWorldY();
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e.func_176734_d())), this.getSide())) {
                minX = false;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e)), this.getSide())) {
                maxX = 16;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(u.func_176734_d())), this.getSide())) {
                minY = false;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e)), this.getSide())) {
                maxY = 16;
            }
        }
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox((double)minX, (double)minY, 15.0, maxX, maxY, bch.isBBCollision() ? 15.0 : 16.0);
    }

    public PlaneConnections getConnections() {
        EnumFacing facingUp;
        EnumFacing facingRight;
        AEPartLocation location = this.getSide();
        switch (location) {
            case UP: {
                facingRight = EnumFacing.EAST;
                facingUp = EnumFacing.NORTH;
                break;
            }
            case DOWN: {
                facingRight = EnumFacing.WEST;
                facingUp = EnumFacing.NORTH;
                break;
            }
            case NORTH: {
                facingRight = EnumFacing.WEST;
                facingUp = EnumFacing.UP;
                break;
            }
            case SOUTH: {
                facingRight = EnumFacing.EAST;
                facingUp = EnumFacing.UP;
                break;
            }
            case WEST: {
                facingRight = EnumFacing.SOUTH;
                facingUp = EnumFacing.UP;
                break;
            }
            case EAST: {
                facingRight = EnumFacing.NORTH;
                facingUp = EnumFacing.UP;
                break;
            }
            default: {
                return PlaneConnections.of(false, false, false, false);
            }
        }
        boolean left = false;
        boolean right = false;
        boolean down = false;
        boolean up = false;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            BlockPos pos = te.func_174877_v();
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingRight.func_176734_d())), this.getSide())) {
                left = true;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingRight)), this.getSide())) {
                right = true;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingUp.func_176734_d())), this.getSide())) {
                down = true;
            }
            if (this.isAnnihilationPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingUp)), this.getSide())) {
                up = true;
            }
        }
        return PlaneConnections.of(up, right, down, left);
    }

    @Override
    public void onNeighborChanged(IBlockAccess w, BlockPos pos, BlockPos neighbor) {
        if (pos.func_177972_a(this.getSide().getFacing()).equals((Object)neighbor)) {
            this.refresh();
        }
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (this.isAccepting && entity instanceof EntityItem && !entity.field_70128_L && Platform.isServer() && this.getProxy().isActive()) {
            boolean changed;
            boolean capture = false;
            BlockPos pos = this.getTile().func_174877_v();
            double posYMiddle = (entity.func_174813_aQ().field_72338_b + entity.func_174813_aQ().field_72337_e) / 2.0;
            switch (this.getSide()) {
                case UP: 
                case DOWN: {
                    if (!(entity.field_70165_t > (double)pos.func_177958_n()) || !(entity.field_70165_t < (double)(pos.func_177958_n() + 1)) || !(entity.field_70161_v > (double)pos.func_177952_p()) || !(entity.field_70161_v < (double)(pos.func_177952_p() + 1)) || !(entity.field_70163_u > (double)pos.func_177956_o() + 0.9 && this.getSide() == AEPartLocation.UP) && (!(entity.field_70163_u < (double)pos.func_177956_o() + 0.1) || this.getSide() != AEPartLocation.DOWN)) break;
                    capture = true;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if (!(entity.field_70165_t > (double)pos.func_177958_n()) || !(entity.field_70165_t < (double)(pos.func_177958_n() + 1)) || !(posYMiddle > (double)pos.func_177956_o()) || !(posYMiddle < (double)(pos.func_177956_o() + 1)) || !(entity.field_70161_v > (double)pos.func_177952_p() + 0.9 && this.getSide() == AEPartLocation.SOUTH) && (!(entity.field_70161_v < (double)pos.func_177952_p() + 0.1) || this.getSide() != AEPartLocation.NORTH)) break;
                    capture = true;
                    break;
                }
                case WEST: 
                case EAST: {
                    if (!(entity.field_70161_v > (double)pos.func_177952_p()) || !(entity.field_70161_v < (double)(pos.func_177952_p() + 1)) || !(posYMiddle > (double)pos.func_177956_o()) || !(posYMiddle < (double)(pos.func_177956_o() + 1)) || !(entity.field_70165_t > (double)pos.func_177958_n() + 0.9 && this.getSide() == AEPartLocation.EAST) && (!(entity.field_70165_t < (double)pos.func_177958_n() + 0.1) || this.getSide() != AEPartLocation.WEST)) break;
                    capture = true;
                    break;
                }
            }
            if (capture && (changed = this.storeEntityItem((EntityItem)entity))) {
                AppEng.proxy.sendToAllNearExcept(null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 64.0, this.getTile().func_145831_w(), new PacketTransitionEffect(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.getSide(), false));
            }
        }
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    private boolean storeEntityItem(EntityItem entityItem) {
        if (!entityItem.field_70128_L) {
            IAEItemStack overflow = this.storeItemStack(entityItem.func_92059_d());
            return this.handleOverflow(entityItem, overflow);
        }
        return false;
    }

    private IAEItemStack storeItemStack(ItemStack item) {
        AEItemStack itemToStore = AEItemStack.fromItemStack(item);
        try {
            IStorageGrid storage = this.getProxy().getStorage();
            IEnergyGrid energy = this.getProxy().getEnergy();
            IAEItemStack overflow = Platform.poweredInsert(energy, storage.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)), itemToStore, this.mySrc);
            this.isAccepting = overflow == null;
            return overflow;
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    private boolean handleOverflow(EntityItem entityItem, IAEItemStack overflow) {
        int newStackSize;
        if (overflow == null || overflow.getStackSize() == 0L) {
            entityItem.func_70106_y();
            return true;
        }
        int oldStackSize = entityItem.func_92059_d().func_190916_E();
        boolean changed = oldStackSize != (newStackSize = (int)overflow.getStackSize());
        entityItem.func_92059_d().func_190920_e(newStackSize);
        return changed;
    }

    private void spawnOverflow(IAEItemStack overflow) {
        if (overflow == null) {
            return;
        }
        TileEntity te = this.getTile();
        WorldServer w = (WorldServer)te.func_145831_w();
        BlockPos offset = te.func_174877_v().func_177972_a(this.getSide().getFacing());
        BlockPos add = offset.func_177963_a(0.5, 0.5, 0.5);
        double x = add.func_177958_n();
        double y = add.func_177956_o();
        double z = add.func_177952_p();
        EntityItem overflowEntity = new EntityItem((World)w, x, y, z, overflow.createItemStack());
        overflowEntity.field_70159_w = 0.0;
        overflowEntity.field_70181_x = 0.0;
        overflowEntity.field_70179_y = 0.0;
        w.func_72838_d((Entity)overflowEntity);
    }

    protected boolean isAnnihilationPlane(TileEntity blockTileEntity, AEPartLocation side) {
        if (blockTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)blockTileEntity).getPart(side);
            return p != null && p.getClass() == this.getClass();
        }
        return false;
    }

    @Override
    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.refresh();
        this.getHost().markForUpdate();
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.refresh();
        this.getHost().markForUpdate();
    }

    private TickRateModulation breakBlock(boolean modulate) {
        if (this.isAccepting && this.getProxy().isActive()) {
            try {
                TileEntity te = this.getTile();
                WorldServer w = (WorldServer)te.func_145831_w();
                BlockPos pos = te.func_174877_v().func_177972_a(this.getSide().getFacing());
                IEnergyGrid energy = this.getProxy().getEnergy();
                if (this.canHandleBlock(w, pos)) {
                    List<ItemStack> items = this.obtainBlockDrops(w, pos);
                    float requiredPower = this.calculateEnergyUsage(w, pos, items);
                    boolean hasPower = energy.extractAEPower(requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG) > (double)requiredPower - 0.1;
                    boolean canStore = this.canStoreItemStacks(items);
                    if (hasPower && canStore) {
                        if (modulate) {
                            energy.extractAEPower(requiredPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
                            this.breakBlockAndStoreItems(w, pos, items);
                            AppEng.proxy.sendToAllNearExcept(null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 64.0, (World)w, new PacketTransitionEffect(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.getSide(), true));
                        } else {
                            this.breaking = true;
                            TickHandler.INSTANCE.addCallable(this.getTile().func_145831_w(), this);
                        }
                        return TickRateModulation.URGENT;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.IDLE;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.AnnihilationPlane.getMin(), TickRates.AnnihilationPlane.getMax(), false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.breaking) {
            return TickRateModulation.URGENT;
        }
        this.isAccepting = true;
        return this.breakBlock(false);
    }

    private boolean canHandleBlock(WorldServer w, BlockPos pos) {
        IBlockState state = w.func_180495_p(pos);
        Material material = state.func_185904_a();
        float hardness = state.func_185887_b((World)w, pos);
        boolean ignoreMaterials = material == Material.field_151579_a || material == Material.field_151587_i || material == Material.field_151586_h || material.func_76224_d();
        boolean ignoreBlocks = state.func_177230_c() == Blocks.field_150357_h || state.func_177230_c() == Blocks.field_150384_bq || state.func_177230_c() == Blocks.field_150378_br || state.func_177230_c() == Blocks.field_150483_bI;
        return !ignoreMaterials && !ignoreBlocks && hardness >= 0.0f && !w.func_175623_d(pos) && w.func_175667_e(pos) && w.canMineBlockBody(Platform.getPlayer(w), pos);
    }

    protected List<ItemStack> obtainBlockDrops(WorldServer w, BlockPos pos) {
        Object[] out = Platform.getBlockDrops((World)w, pos);
        return Lists.newArrayList((Object[])out);
    }

    protected float calculateEnergyUsage(WorldServer w, BlockPos pos, List<ItemStack> items) {
        IBlockState state = w.func_180495_p(pos);
        float hardness = state.func_185887_b((World)w, pos);
        float requiredEnergy = 1.0f + hardness;
        for (ItemStack is : items) {
            requiredEnergy += (float)is.func_190916_E();
        }
        return requiredEnergy;
    }

    private boolean canStoreItemStacks(List<ItemStack> itemStacks) {
        boolean canStore = itemStacks.isEmpty();
        try {
            IStorageGrid storage = this.getProxy().getStorage();
            for (ItemStack itemStack : itemStacks) {
                AEItemStack itemToTest = AEItemStack.fromItemStack(itemStack);
                IAEItemStack overflow = storage.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).injectItems(itemToTest, Actionable.SIMULATE, this.mySrc);
                if (overflow != null && itemToTest.getStackSize() <= overflow.getStackSize()) continue;
                canStore = true;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.isAccepting = canStore;
        return canStore;
    }

    private void breakBlockAndStoreItems(WorldServer w, BlockPos pos, List<ItemStack> items) {
        w.func_175698_g(pos);
        AxisAlignedBB box = new AxisAlignedBB((double)pos.func_177958_n() - 0.2, (double)pos.func_177956_o() - 0.2, (double)pos.func_177952_p() - 0.2, (double)pos.func_177958_n() + 1.2, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 1.2);
        for (Object ei : w.func_72872_a(EntityItem.class, box)) {
            if (!(ei instanceof EntityItem)) continue;
            EntityItem entityItem = (EntityItem)ei;
            this.storeEntityItem(entityItem);
        }
        for (ItemStack snaggedItem : items) {
            IAEItemStack overflow = this.storeItemStack(snaggedItem);
            this.spawnOverflow(overflow);
        }
    }

    private void refresh() {
        this.isAccepting = true;
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.getConnections(), this.isPowered(), this.isActive());
    }
}

