/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.factories.recipes;

import appeng.api.AEApi;
import appeng.api.recipes.ResolverResult;
import appeng.core.AELog;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class PartRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        String type = JsonUtils.func_151200_h((JsonObject)json, (String)"type");
        if (type.contains("shaped")) {
            return PartRecipeFactory.shapedFactory(context, json);
        }
        if (type.contains("shapeless")) {
            return PartRecipeFactory.shapelessFactory(context, json);
        }
        throw new JsonSyntaxException("Applied Energistics 2 was given a custom recipe that it does not know how to handle!\nType should either be 'appliedenergistics2:shapeless' or 'appliedenergistics2:shaped', got '" + type + "'!");
    }

    public static ItemStack getResult(JsonObject json, JsonContext context) {
        JsonObject resultObject = JsonUtils.func_152754_s((JsonObject)json, (String)"result");
        if (resultObject.has("part")) {
            return PartRecipeFactory.getPart(resultObject);
        }
        if (resultObject.has("item")) {
            return CraftingHelper.getItemStack((JsonObject)resultObject, (JsonContext)context);
        }
        throw new JsonSyntaxException("Result has no 'part' or 'item' property.");
    }

    private static ItemStack getPart(JsonObject resultObject) {
        String ingredient = JsonUtils.func_151200_h((JsonObject)resultObject, (String)"part");
        Object result = AEApi.instance().registries().recipes().resolveItem("appliedenergistics2", ingredient);
        if (result instanceof ResolverResult) {
            ResolverResult resolverResult = (ResolverResult)result;
            Item item = Item.func_111206_d((String)("appliedenergistics2:" + resolverResult.itemName));
            if (item == null) {
                AELog.warn("item was null for " + resolverResult.itemName + " ( " + ingredient + " )!", new Object[0]);
                throw new JsonSyntaxException("Got a null item for " + resolverResult.itemName + " ( " + ingredient + " ). This should never happen!");
            }
            return new ItemStack(item, JsonUtils.func_151208_a((JsonObject)resultObject, (String)"count", (int)1), resolverResult.damageValue, resolverResult.compound);
        }
        throw new JsonSyntaxException("Couldn't find the resulting item in AE. This means AE was provided a recipe that it shouldn't be handling.\nWas looking for : '" + ingredient + "'.");
    }

    private static ShapedOreRecipe shapedFactory(JsonContext context, JsonObject json) {
        String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        HashMap ingMap = Maps.newHashMap();
        for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
        }
        ingMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
        JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
            }
            pattern[x] = line;
        }
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = pattern[0].length();
        primer.height = pattern.length;
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
        HashSet keys = Sets.newHashSet(ingMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                primer.input.set(x++, (Object)ing);
                keys.remove(Character.valueOf(chr));
            }
        }
        if (!keys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
        }
        return new ShapedOreRecipe(group.isEmpty() ? null : new ResourceLocation(group), PartRecipeFactory.getResult(json, context), primer);
    }

    private static ShapelessOreRecipe shapelessFactory(JsonContext context, JsonObject json) {
        String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        NonNullList ings = NonNullList.func_191196_a();
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ings.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
        }
        if (ings.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        return new ShapelessOreRecipe(group.isEmpty() ? null : new ResourceLocation(group), ings, PartRecipeFactory.getResult(json, context));
    }
}

