/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.util.AEColor;
import appeng.helpers.Splotch;
import appeng.items.misc.ItemPaintBall;
import appeng.tile.AEBaseTile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;

public class TilePaint
extends AEBaseTile {
    private static final int LIGHT_PER_DOT = 12;
    private int isLit = 0;
    private List<Splotch> dots = null;

    @Override
    public boolean canBeRotated() {
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        ByteBuf myDat = Unpooled.buffer();
        this.writeBuffer(myDat);
        if (myDat.hasArray()) {
            data.func_74773_a("dots", myDat.array());
        }
        return data;
    }

    private void writeBuffer(ByteBuf out) {
        if (this.dots == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(this.dots.size());
        for (Splotch s : this.dots) {
            s.writeToStream(out);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("dots")) {
            this.readBuffer(Unpooled.copiedBuffer((byte[])data.func_74770_j("dots")));
        }
    }

    private void readBuffer(ByteBuf in) {
        int howMany = in.readByte();
        if (howMany == 0) {
            this.isLit = 0;
            this.dots = null;
            return;
        }
        this.dots = new ArrayList<Splotch>(howMany);
        for (int x = 0; x < howMany; ++x) {
            this.dots.add(new Splotch(in));
        }
        this.isLit = 0;
        for (Splotch s : this.dots) {
            if (!s.isLumen()) continue;
            this.isLit += 12;
        }
        this.maxLit();
    }

    private void maxLit() {
        if (this.isLit > 14) {
            this.isLit = 14;
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175642_b(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
    }

    @Override
    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        this.writeBuffer(data);
    }

    @Override
    protected boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        this.readBuffer(data);
        return true;
    }

    public void neighborChanged() {
        if (this.dots == null) {
            return;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.isSideValid(side)) continue;
            this.removeSide(side);
        }
        this.updateData();
    }

    public boolean isSideValid(EnumFacing side) {
        BlockPos p = this.field_174879_c.func_177972_a(side);
        IBlockState blk = this.field_145850_b.func_180495_p(p);
        return blk.func_177230_c().isSideSolid(this.field_145850_b.func_180495_p(p), (IBlockAccess)this.field_145850_b, p, side.func_176734_d());
    }

    private void removeSide(EnumFacing side) {
        Iterator<Splotch> i = this.dots.iterator();
        while (i.hasNext()) {
            Splotch s = i.next();
            if (s.getSide() != side) continue;
            i.remove();
        }
        this.markForUpdate();
        this.func_70296_d();
    }

    private void updateData() {
        this.isLit = 0;
        for (Splotch s : this.dots) {
            if (!s.isLumen()) continue;
            this.isLit += 12;
        }
        this.maxLit();
        if (this.dots.isEmpty()) {
            this.dots = null;
        }
        if (this.dots == null) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    public void cleanSide(EnumFacing side) {
        if (this.dots == null) {
            return;
        }
        this.removeSide(side);
        this.updateData();
    }

    public int getLightLevel() {
        return this.isLit;
    }

    public void addBlot(ItemStack type, EnumFacing side, Vec3d hitVec) {
        BlockPos p = this.field_174879_c.func_177972_a(side);
        IBlockState blk = this.field_145850_b.func_180495_p(p);
        if (blk.func_177230_c().isSideSolid(this.field_145850_b.func_180495_p(p), (IBlockAccess)this.field_145850_b, p, side.func_176734_d())) {
            ItemPaintBall ipb = (ItemPaintBall)type.func_77973_b();
            AEColor col = ipb.getColor(type);
            boolean lit = ItemPaintBall.isLumen(type);
            if (this.dots == null) {
                this.dots = new ArrayList<Splotch>();
            }
            if (this.dots.size() > 20) {
                this.dots.remove(0);
            }
            this.dots.add(new Splotch(col, lit, side, hitVec));
            if (lit) {
                this.isLit += 12;
            }
            this.maxLit();
            this.markForUpdate();
            this.func_70296_d();
        }
    }

    public Collection<Splotch> getDots() {
        if (this.dots == null) {
            return Collections.emptyList();
        }
        return this.dots;
    }
}

