/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.networking.IGridNode;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IPart;
import appeng.api.parts.LayerFlags;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.block.networking.BlockCableBus;
import appeng.helpers.AEMultiTile;
import appeng.helpers.ICustomCollision;
import appeng.hooks.TickHandler;
import appeng.parts.CableBusContainer;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileCableBus
extends AEBaseTile
implements AEMultiTile,
ICustomCollision {
    private CableBusContainer cb = new CableBusContainer(this);
    private int oldLV = -1;

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.getCableBus().readFromNBT(data);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.getCableBus().writeToNBT(data);
        return data;
    }

    @Override
    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        boolean ret = this.getCableBus().readFromStream(data);
        int newLV = this.getCableBus().getLightValue();
        if (newLV != this.oldLV) {
            this.oldLV = newLV;
            this.field_145850_b.func_175664_x(this.field_174879_c);
        }
        this.updateTileSetting();
        return ret || c;
    }

    @Override
    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        this.getCableBus().writeToStream(data);
    }

    protected void updateTileSetting() {
        if (this.getCableBus().isRequiresDynamicRender()) {
            try {
                TileCableBus tcb = (TileCableBus)BlockCableBus.getTesrTile().newInstance();
                tcb.copyFrom(this);
                this.func_145831_w().func_175690_a(this.field_174879_c, (TileEntity)tcb);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void copyFrom(TileCableBus oldTile) {
        CableBusContainer tmpCB = this.getCableBus();
        this.setCableBus(oldTile.getCableBus());
        this.oldLV = oldTile.oldLV;
        oldTile.setCableBus(tmpCB);
    }

    public double func_145833_n() {
        return 900.0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.getCableBus().removeFromWorld();
    }

    public void func_145829_t() {
        super.func_145829_t();
        TickHandler.INSTANCE.addInit(this);
    }

    @Override
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getCableBus().getGridNode(dir);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation side) {
        return this.getCableBus().getCableConnectionType(side);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return this.getCableBus().getCableConnectionLength(cable);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.getCableBus().removeFromWorld();
    }

    @Override
    public void markForUpdate() {
        if (this.field_145850_b == null) {
            return;
        }
        int newLV = this.getCableBus().getLightValue();
        if (newLV != this.oldLV) {
            this.oldLV = newLV;
            this.field_145850_b.func_175664_x(this.field_174879_c);
        }
        super.markForUpdate();
    }

    @Override
    public boolean canBeRotated() {
        return false;
    }

    public void getDrops(World w, BlockPos pos, List drops) {
        this.getCableBus().getDrops(drops);
    }

    @Override
    public void getNoDrops(World w, BlockPos pos, List<ItemStack> drops) {
        this.getCableBus().getNoDrops(drops);
    }

    @Override
    public void onReady() {
        super.onReady();
        if (this.getCableBus().isEmpty()) {
            if (this.field_145850_b.func_175625_s(this.field_174879_c) == this) {
                this.field_145850_b.func_175655_b(this.field_174879_c, true);
            }
        } else {
            this.getCableBus().addToWorld();
        }
    }

    @Override
    public boolean requiresTESR() {
        return this.getCableBus().isRequiresDynamicRender();
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        return this.getCableBus().getFacadeContainer();
    }

    @Override
    public boolean canAddPart(ItemStack is, AEPartLocation side) {
        return this.getCableBus().canAddPart(is, side);
    }

    @Override
    public AEPartLocation addPart(ItemStack is, AEPartLocation side, EntityPlayer player, EnumHand hand) {
        return this.getCableBus().addPart(is, side, player, hand);
    }

    @Override
    public IPart getPart(AEPartLocation side) {
        return this.cb.getPart(side);
    }

    @Override
    public IPart getPart(EnumFacing side) {
        return this.getCableBus().getPart(side);
    }

    @Override
    public void removePart(AEPartLocation side, boolean suppressUpdate) {
        this.getCableBus().removePart(side, suppressUpdate);
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public AEColor getColor() {
        return this.getCableBus().getColor();
    }

    @Override
    public void clearContainer() {
        this.setCableBus(new CableBusContainer(this));
    }

    @Override
    public boolean isBlocked(EnumFacing side) {
        return false;
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, BlockPos pos, Entity e, boolean visual) {
        return this.getCableBus().getSelectedBoundingBoxesFromPool(false, true, e, visual);
    }

    @Override
    public SelectedPart selectPart(Vec3d pos) {
        return this.getCableBus().selectPart(pos);
    }

    @Override
    public void markForSave() {
        super.func_70296_d();
    }

    @Override
    public void partChanged() {
        this.notifyNeighbors();
    }

    @Override
    public boolean hasRedstone(AEPartLocation side) {
        return this.getCableBus().hasRedstone(side);
    }

    @Override
    public boolean isEmpty() {
        return this.getCableBus().isEmpty();
    }

    @Override
    public Set<LayerFlags> getLayerFlags() {
        return this.getCableBus().getLayerFlags();
    }

    @Override
    public void cleanup() {
        this.func_145831_w().func_175698_g(this.field_174879_c);
    }

    @Override
    public void addCollidingBlockToList(World w, BlockPos pos, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        for (AxisAlignedBB bx : this.getSelectedBoundingBoxesFromPool(w, pos, e, false)) {
            out.add(new AxisAlignedBB(bx.field_72340_a, bx.field_72338_b, bx.field_72339_c, bx.field_72336_d, bx.field_72337_e, bx.field_72334_f));
        }
    }

    @Override
    public void notifyNeighbors() {
        if (this.field_145850_b != null && this.field_145850_b.func_175667_e(this.field_174879_c) && !CableBusContainer.isLoading()) {
            Platform.notifyBlocksOfNeighbors(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public boolean isInWorld() {
        return this.getCableBus().isInWorld();
    }

    @Override
    public boolean recolourBlock(EnumFacing side, AEColor colour, EntityPlayer who) {
        return this.getCableBus().recolourBlock(side, colour, who);
    }

    public CableBusContainer getCableBus() {
        return this.cb;
    }

    private void setCableBus(CableBusContainer cb) {
        this.cb = cb;
    }

    public boolean hasCapability(Capability<?> capabilityClass, @Nullable EnumFacing fromSide) {
        AEPartLocation partLocation = AEPartLocation.fromFacing(fromSide);
        IPart part = this.getPart(partLocation);
        boolean result = part != null && part.hasCapability(capabilityClass);
        return result || super.hasCapability(capabilityClass, fromSide);
    }

    public <T> T getCapability(Capability<T> capabilityClass, @Nullable EnumFacing fromSide) {
        T result;
        AEPartLocation partLocation = AEPartLocation.fromFacing(fromSide);
        IPart part = this.getPart(partLocation);
        T t = result = part == null ? null : (T)part.getCapability(capabilityClass);
        if (result != null) {
            return result;
        }
        return (T)super.getCapability(capabilityClass, fromSide);
    }
}

