/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.helpers;

import appeng.api.config.FuzzyMode;
import appeng.util.item.OreHelper;
import appeng.util.item.OreReference;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;

public class ItemComparisonHelper {
    public boolean isEqualItemType(@Nonnull ItemStack that, @Nonnull ItemStack other) {
        if (!that.func_190926_b() && !other.func_190926_b() && that.func_77973_b() == other.func_77973_b()) {
            if (that.func_77984_f()) {
                return true;
            }
            return that.func_77952_i() == other.func_77952_i();
        }
        return false;
    }

    public boolean isSameItem(@Nonnull ItemStack is, @Nonnull ItemStack filter) {
        return ItemStack.func_179545_c((ItemStack)is, (ItemStack)filter) && this.isNbtTagEqual((NBTBase)is.func_77978_p(), (NBTBase)filter.func_77978_p());
    }

    public boolean isFuzzyEqualItem(ItemStack a, ItemStack b, FuzzyMode mode) {
        OreReference bOR;
        if (a.func_190926_b() && b.func_190926_b()) {
            return true;
        }
        if (a.func_190926_b() || b.func_190926_b()) {
            return false;
        }
        if (a.func_77973_b() != Items.field_190931_a && b.func_77973_b() != Items.field_190931_a && a.func_77973_b().func_77645_m() && a.func_77973_b() == b.func_77973_b()) {
            try {
                if (mode == FuzzyMode.IGNORE_ALL) {
                    return true;
                }
                if (mode == FuzzyMode.PERCENT_99) {
                    Item ai = a.func_77973_b();
                    Item bi = b.func_77973_b();
                    return ai.getDurabilityForDisplay(a) > 1.0 == bi.getDurabilityForDisplay(b) > 1.0;
                }
                Item ai = a.func_77973_b();
                Item bi = b.func_77973_b();
                float percentDamagedOfA = 1.0f - (float)ai.getDurabilityForDisplay(a);
                float percentDamagedOfB = 1.0f - (float)bi.getDurabilityForDisplay(b);
                return percentDamagedOfA > mode.breakPoint == percentDamagedOfB > mode.breakPoint;
            }
            catch (Throwable e) {
                if (mode == FuzzyMode.IGNORE_ALL) {
                    return true;
                }
                if (mode == FuzzyMode.PERCENT_99) {
                    return a.func_77952_i() > 1 == b.func_77952_i() > 1;
                }
                float percentDamagedOfA = (float)a.func_77952_i() / (float)a.func_77958_k();
                float percentDamagedOfB = (float)b.func_77952_i() / (float)b.func_77958_k();
                return percentDamagedOfA > mode.breakPoint == percentDamagedOfB > mode.breakPoint;
            }
        }
        OreReference aOR = OreHelper.INSTANCE.getOre(a).orElse(null);
        if (OreHelper.INSTANCE.sameOre(aOR, bOR = (OreReference)OreHelper.INSTANCE.getOre(b).orElse(null))) {
            return true;
        }
        return a.func_77969_a(b);
    }

    public boolean isNbtTagEqual(NBTBase left, NBTBase right) {
        if (left == right) {
            return true;
        }
        if (left != null) {
            return left.equals((Object)right);
        }
        return false;
    }
}

