"""
@Author: Jose Stovall | github.com/oitsjustjose
Generates clean JSON files for upgrading equipment w/ enchantments saved in the smithing table
"""

import json

# Vanilla Mappings
vanilla = [
    # Leather -> Iron
    ("minecraft:leather_helmet", "#forge:ingots/iron", "minecraft:iron_helmet"),
    ("minecraft:leather_chestplate", "#forge:ingots/iron", "minecraft:iron_chestplate"),
    ("minecraft:leather_leggings", "#forge:ingots/iron", "minecraft:iron_leggings"),
    ("minecraft:leather_boots", "#forge:ingots/iron", "minecraft:iron_boots"),
    # Leather -> Chainmail
    ("minecraft:leather_helmet", "minecraft:chain", "minecraft:chainmail_helmet"),
    (
        "minecraft:leather_chestplate",
        "minecraft:chain",
        "minecraft:chainmail_chestplate",
    ),
    ("minecraft:leather_leggings", "minecraft:chain", "minecraft:chainmail_leggings"),
    ("minecraft:leather_boots", "minecraft:chain", "minecraft:chainmail_boots"),
    # Wood -> Stone
    (
        "minecraft:wooden_sword",
        "#minecraft:stone_crafting_materials",
        "minecraft:stone_sword",
    ),
    (
        "minecraft:wooden_pickaxe",
        "#minecraft:stone_crafting_materials",
        "minecraft:stone_pickaxe",
    ),
    (
        "minecraft:wooden_shovel",
        "#minecraft:stone_crafting_materials",
        "minecraft:stone_shovel",
    ),
    (
        "minecraft:wooden_axe",
        "#minecraft:stone_crafting_materials",
        "minecraft:stone_axe",
    ),
    (
        "minecraft:wooden_hoe",
        "#minecraft:stone_crafting_materials",
        "minecraft:stone_hoe",
    ),
    # Stone -> Iron
    ("minecraft:stone_sword", "#forge:ingots/iron", "minecraft:iron_sword"),
    ("minecraft:stone_pickaxe", "#forge:ingots/iron", "minecraft:iron_pickaxe"),
    ("minecraft:stone_shovel", "#forge:ingots/iron", "minecraft:iron_shovel"),
    ("minecraft:stone_axe", "#forge:ingots/iron", "minecraft:iron_axe"),
    ("minecraft:stone_hoe", "#forge:ingots/iron", "minecraft:iron_hoe"),
    # Iron -> Gold
    ("minecraft:iron_sword", "#forge:ingots/gold", "minecraft:golden_sword"),
    ("minecraft:iron_pickaxe", "#forge:ingots/gold", "minecraft:golden_pickaxe"),
    ("minecraft:iron_shovel", "#forge:ingots/gold", "minecraft:golden_shovel"),
    ("minecraft:iron_axe", "#forge:ingots/gold", "minecraft:golden_axe"),
    ("minecraft:iron_hoe", "#forge:ingots/gold", "minecraft:golden_hoe"),
    ("minecraft:iron_helmet", "#forge:ingots/gold", "minecraft:golden_helmet"),
    ("minecraft:iron_chestplate", "#forge:ingots/gold", "minecraft:golden_chestplate"),
    ("minecraft:iron_leggings", "#forge:ingots/gold", "minecraft:golden_leggings"),
    ("minecraft:iron_boots", "#forge:ingots/gold", "minecraft:golden_boots"),
    # Iron -> Diamond
    ("minecraft:iron_sword", "minecraft:diamond", "minecraft:diamond_sword"),
    ("minecraft:iron_pickaxe", "minecraft:diamond", "minecraft:diamond_pickaxe"),
    ("minecraft:iron_shovel", "minecraft:diamond", "minecraft:diamond_shovel"),
    ("minecraft:iron_axe", "minecraft:diamond", "minecraft:diamond_axe"),
    ("minecraft:iron_hoe", "minecraft:diamond", "minecraft:diamond_hoe"),
    ("minecraft:iron_helmet", "minecraft:diamond", "minecraft:diamond_helmet"),
    ("minecraft:iron_chestplate", "minecraft:diamond", "minecraft:diamond_chestplate"),
    ("minecraft:iron_leggings", "minecraft:diamond", "minecraft:diamond_leggings"),
    ("minecraft:iron_boots", "minecraft:diamond", "minecraft:diamond_boots"),
]

immersive = [
    # Iron -> Steel
    ("minecraft:iron_sword", "#forge:ingots/steel", "immersiveengineering:sword_steel"),
    (
        "minecraft:iron_pickaxe",
        "#forge:ingots/steel",
        "immersiveengineering:pickaxe_steel",
    ),
    (
        "minecraft:iron_shovel",
        "#forge:ingots/steel",
        "immersiveengineering:shovel_steel",
    ),
    ("minecraft:iron_axe", "#forge:ingots/steel", "immersiveengineering:axe_steel"),
    ("minecraft:iron_hoe", "#forge:ingots/steel", "immersiveengineering:hoe_steel"),
    (
        "minecraft:iron_helmet",
        "#forge:ingots/steel",
        "immersiveengineering:armor_steel_head",
    ),
    (
        "minecraft:iron_chestplate",
        "#forge:ingots/steel",
        "immersiveengineering:armor_steel_chest",
    ),
    (
        "minecraft:iron_leggings",
        "#forge:ingots/steel",
        "immersiveengineering:armor_steel_legs",
    ),
    (
        "minecraft:iron_boots",
        "#forge:ingots/steel",
        "immersiveengineering:armor_steel_feet",
    ),
    # Steel -> Diamond
    (
        "immersiveengineering:sword_steel",
        "minecraft:diamond",
        "minecraft:diamond_sword",
    ),
    (
        "immersiveengineering:pickaxe_steel",
        "minecraft:diamond",
        "minecraft:diamond_pickaxe",
    ),
    (
        "immersiveengineering:shovel_steel",
        "minecraft:diamond",
        "minecraft:diamond_shovel",
    ),
    ("immersiveengineering:axe_steel", "minecraft:diamond", "minecraft:diamond_axe"),
    ("immersiveengineering:hoe_steel", "minecraft:diamond", "minecraft:diamond_hoe"),
    (
        "immersiveengineering:armor_steel_head",
        "minecraft:diamond",
        "minecraft:diamond_helmet",
    ),
    (
        "immersiveengineering:armor_steel_chest",
        "minecraft:diamond",
        "minecraft:diamond_chestplate",
    ),
    (
        "immersiveengineering:armor_steel_legs",
        "minecraft:diamond",
        "minecraft:diamond_leggings",
    ),
    (
        "immersiveengineering:armor_steel_feet",
        "minecraft:diamond",
        "minecraft:diamond_boots",
    ),
]

na = [
    (
        "naturesaura:infused_iron_shoes",
        "naturesaura:sky_ingot",
        "naturesaura:sky_shoes",
    ),
    (
        "naturesaura:infused_iron_pants",
        "naturesaura:sky_ingot",
        "naturesaura:sky_pants",
    ),
    (
        "naturesaura:infused_iron_chest",
        "naturesaura:sky_ingot",
        "naturesaura:sky_chest",
    ),
    (
        "naturesaura:infused_iron_helmet",
        "naturesaura:sky_ingot",
        "naturesaura:sky_helmet",
    ),
    (
        "naturesaura:infused_iron_sword",
        "naturesaura:sky_ingot",
        "naturesaura:sky_sword",
    ),
    (
        "naturesaura:infused_iron_hoe",
        "naturesaura:sky_ingot",
        "naturesaura:sky_hoe",
    ),
    (
        "naturesaura:infused_iron_shovel",
        "naturesaura:sky_ingot",
        "naturesaura:sky_shovel",
    ),
    (
        "naturesaura:infused_iron_axe",
        "naturesaura:sky_ingot",
        "naturesaura:sky_axe",
    ),
    (
        "naturesaura:infused_iron_pickaxe",
        "naturesaura:sky_ingot",
        "naturesaura:sky_pickaxe",
    ),
]

mek = [
    ("minecraft:iron_sword", "#forge:ingots/osmium", "mekanismtools:osmium_sword"),
    ("minecraft:iron_pickaxe", "#forge:ingots/osmium", "mekanismtools:osmium_pickaxe"),
    ("minecraft:iron_shovel", "#forge:ingots/osmium", "mekanismtools:osmium_shovel"),
    ("minecraft:iron_axe", "#forge:ingots/osmium", "mekanismtools:osmium_axe"),
    ("minecraft:iron_hoe", "#forge:ingots/osmium", "mekanismtools:osmium_hoe"),
    ("minecraft:iron_helmet", "#forge:ingots/osmium", "mekanismtools:osmium_helmet"),
    (
        "minecraft:iron_chestplate",
        "#forge:ingots/osmium",
        "mekanismtools:osmium_chestplate",
    ),
    (
        "minecraft:iron_leggings",
        "#forge:ingots/osmium",
        "mekanismtools:osmium_leggings",
    ),
    ("minecraft:iron_boots", "#forge:ingots/osmium", "mekanismtools:osmium_boots"),
    (
        "minecraft:diamond_sword",
        "#forge:ingots/refined_glowstone",
        "mekanismtools:refined_glowstone_sword",
    ),
    (
        "minecraft:diamond_pickaxe",
        "#forge:ingots/refined_glowstone",
        "mekanismtools:refined_glowstone_pickaxe",
    ),
    (
        "minecraft:diamond_shovel",
        "#forge:ingots/refined_glowstone",
        "mekanismtools:refined_glowstone_shovel",
    ),
    (
        "minecraft:diamond_axe",
        "#forge:ingots/refined_glowstone",
        "mekanismtools:refined_glowstone_axe",
    ),
    (
        "minecraft:diamond_hoe",
        "#forge:ingots/refined_glowstone",
        "mekanismtools:refined_glowstone_hoe",
    ),
    (
        "minecraft:diamond_helmet",
        "#forge:ingots/refined_glowstone",
        "mekanismtools:refined_glowstone_helmet",
    ),
    (
        "minecraft:diamond_chestplate",
        "#forge:ingots/refined_glowstone",
        "mekanismtools:refined_glowstone_chestplate",
    ),
    (
        "minecraft:diamond_leggings",
        "#forge:ingots/refined_glowstone",
        "mekanismtools:refined_glowstone_leggings",
    ),
    (
        "minecraft:diamond_boots",
        "#forge:ingots/refined_glowstone",
        "mekanismtools:refined_glowstone_boots",
    ),
    (
        "minecraft:diamond_sword",
        "#forge:ingots/refined_obsidian",
        "mekanismtools:refined_obsidian_sword",
    ),
    (
        "minecraft:diamond_pickaxe",
        "#forge:ingots/refined_obsidian",
        "mekanismtools:refined_obsidian_pickaxe",
    ),
    (
        "minecraft:diamond_shovel",
        "#forge:ingots/refined_obsidian",
        "mekanismtools:refined_obsidian_shovel",
    ),
    (
        "minecraft:diamond_axe",
        "#forge:ingots/refined_obsidian",
        "mekanismtools:refined_obsidian_axe",
    ),
    (
        "minecraft:diamond_hoe",
        "#forge:ingots/refined_obsidian",
        "mekanismtools:refined_obsidian_hoe",
    ),
    (
        "minecraft:diamond_helmet",
        "#forge:ingots/refined_obsidian",
        "mekanismtools:refined_obsidian_helmet",
    ),
    (
        "minecraft:diamond_chestplate",
        "#forge:ingots/refined_obsidian",
        "mekanismtools:refined_obsidian_chestplate",
    ),
    (
        "minecraft:diamond_leggings",
        "#forge:ingots/refined_obsidian",
        "mekanismtools:refined_obsidian_leggings",
    ),
    (
        "minecraft:diamond_boots",
        "#forge:ingots/refined_obsidian",
        "mekanismtools:refined_obsidian_boots",
    ),
    (
        "minecraft:shield",
        "#forge:ingots/refined_glowstone",
        "mekanismtools:refined_glowstone_shield",
    ),
    ("minecraft:shield", "#forge:ingots/osmium", "mekanismtools:osmium_shield"),
    (
        "minecraft:shield",
        "#forge:ingots/refined_obsidian",
        "mekanismtools:refined_obsidian_shield",
    ),
    ("minecraft:shield", "#forge:ingots/steel", "mekanismtools:steel_shield"),
    ("minecraft:shield", "#forge:ingots/bronze", "mekanismtools:bronze_shield"),
    (
        "mekanismtools:stone_paxel",
        "#forge:storage_blocks/iron",
        "mekanismtools:iron_paxel",
    ),
    (
        "mekanismtools:iron_paxel",
        "#forge:storage_blocks/bronze",
        "mekanismtools:bronze_paxel",
    ),
    (
        "mekanismtools:iron_paxel",
        "#forge:storage_blocks/diamond",
        "mekanismtools:diamond_paxel",
    ),
    (
        "mekanismtools:steel_paxel",
        "#forge:storage_blocks/diamond",
        "mekanismtools:diamond_paxel",
    ),
    (
        "mekanismtools:iron_paxel",
        "#forge:storage_blocks/gold",
        "mekanismtools:gold_paxel",
    ),
    (
        "mekanismtools:iron_paxel",
        "#forge:storage_blocks/steel",
        "mekanismtools:steel_paxel",
    ),
]


tools_complement = []

# Dynamic Recipes for Stone + <ingot> => Tier and <Tier> + Diamond => Diamond
tc_basic_tiers = ["copper", "tin", "silver", "lead", "nickel"]
tc_adv_tiers = ["bronze", "constantan", "electrum", "invar"]

for t in tc_basic_tiers:
    # Stone -> {MAT}
    tools_complement.append(
        ("minecraft:stone_sword", f"#forge:ingots/{t}", f"tools_complement:{t}_sword")
    )
    tools_complement.append(
        (
            "minecraft:stone_pickaxe",
            f"#forge:ingots/{t}",
            f"tools_complement:{t}_pickaxe",
        )
    )
    tools_complement.append(
        ("minecraft:stone_shovel", f"#forge:ingots/{t}", f"tools_complement:{t}_shovel")
    )
    tools_complement.append(
        ("minecraft:stone_axe", f"#forge:ingots/{t}", f"tools_complement:{t}_axe")
    )
    tools_complement.append(
        ("minecraft:stone_hoe", f"#forge:ingots/{t}", f"tools_complement:{t}_hoe")
    )
    tools_complement.append(
        (
            "minecraft:leather_helmet",
            f"#forge:ingots/{t}",
            f"tools_complement:{t}_helmet",
        )
    )
    tools_complement.append(
        (
            "minecraft:leather_chestplate",
            f"#forge:ingots/{t}",
            f"tools_complement:{t}_chestplate",
        )
    )
    tools_complement.append(
        (
            "minecraft:leather_leggings",
            f"#forge:ingots/{t}",
            f"tools_complement:{t}_leggings",
        )
    )
    tools_complement.append(
        ("minecraft:leather_boots", f"#forge:ingots/{t}", f"tools_complement:{t}_boots")
    )
    # {MAT} -> Iron
    tools_complement.append(
        (f"tools_complement:{t}_sword", "#forge:ingots/iron", "minecraft:iron_sword")
    )
    tools_complement.append(
        (
            f"tools_complement:{t}_pickaxe",
            "#forge:ingots/iron",
            "minecraft:iron_pickaxe",
        )
    )
    tools_complement.append(
        (f"tools_complement:{t}_shovel", "#forge:ingots/iron", "minecraft:iron_shovel")
    )
    tools_complement.append(
        (f"tools_complement:{t}_axe", "#forge:ingots/iron", "minecraft:iron_axe")
    )
    tools_complement.append(
        (f"tools_complement:{t}_hoe", "#forge:ingots/iron", "minecraft:iron_hoe")
    )
    tools_complement.append(
        (f"tools_complement:{t}_helmet", "#forge:ingots/iron", "minecraft:iron_helmet")
    )
    tools_complement.append(
        (
            f"tools_complement:{t}_chestplate",
            "#forge:ingots/iron",
            "minecraft:iron_chestplate",
        )
    )
    tools_complement.append(
        (
            f"tools_complement:{t}_leggings",
            "#forge:ingots/iron",
            "minecraft:iron_leggings",
        )
    )
    tools_complement.append(
        (f"tools_complement:{t}_boots", "#forge:ingots/iron", "minecraft:iron_boots")
    )

for t in tc_adv_tiers:
    # Iron -> {MAT}
    tools_complement.append(
        ("minecraft:iron_sword", f"#forge:ingots/{t}", f"tools_complement:{t}_sword")
    )
    tools_complement.append(
        (
            "minecraft:iron_pickaxe",
            f"#forge:ingots/{t}",
            f"tools_complement:{t}_pickaxe",
        )
    )
    tools_complement.append(
        ("minecraft:iron_shovel", f"#forge:ingots/{t}", f"tools_complement:{t}_shovel")
    )
    tools_complement.append(
        ("minecraft:iron_axe", f"#forge:ingots/{t}", f"tools_complement:{t}_axe")
    )
    tools_complement.append(
        ("minecraft:iron_hoe", f"#forge:ingots/{t}", f"tools_complement:{t}_hoe")
    )
    tools_complement.append(
        ("minecraft:iron_helmet", f"#forge:ingots/{t}", f"tools_complement:{t}_helmet")
    )
    tools_complement.append(
        (
            "minecraft:iron_chestplate",
            f"#forge:ingots/{t}",
            f"tools_complement:{t}_chestplate",
        )
    )
    tools_complement.append(
        (
            "minecraft:iron_leggings",
            f"#forge:ingots/{t}",
            f"tools_complement:{t}_leggings",
        )
    )
    tools_complement.append(
        ("minecraft:iron_boots", f"#forge:ingots/{t}", f"tools_complement:{t}_boots")
    )
    tools_complement.append(
        (
            "tools_complement:iron_sickle",
            f"#forge:ingots/{t}",
            f"tools_complement:{t}_sickle",
        )
    )
    tools_complement.append(
        (
            "tools_complement:iron_knife",
            f"#forge:ingots/{t}",
            f"tools_complement:{t}_knife",
        )
    )
    tools_complement.append(
        (
            "tools_complement:iron_hammer",
            f"#forge:storage_blocks/{t}",
            f"tools_complement:{t}_hammer",
        )
    )
    tools_complement.append(
        (
            "tools_complement:iron_excavator",
            f"#forge:storage_blocks/{t}",
            f"tools_complement:{t}_excavator",
        )
    )
    # {MAT} -> Diamond
    tools_complement.append(
        (f"tools_complement:{t}_sword", "minecraft:diamond", "minecraft:diamond_sword")
    )
    tools_complement.append(
        (
            f"tools_complement:{t}_pickaxe",
            "minecraft:diamond",
            "minecraft:diamond_pickaxe",
        )
    )
    tools_complement.append(
        (
            f"tools_complement:{t}_shovel",
            "minecraft:diamond",
            "minecraft:diamond_shovel",
        )
    )
    tools_complement.append(
        (f"tools_complement:{t}_axe", "minecraft:diamond", "minecraft:diamond_axe")
    )
    tools_complement.append(
        (f"tools_complement:{t}_hoe", "minecraft:diamond", "minecraft:diamond_hoe")
    )
    tools_complement.append(
        (
            f"tools_complement:{t}_helmet",
            "minecraft:diamond",
            "minecraft:diamond_helmet",
        )
    )
    tools_complement.append(
        (
            f"tools_complement:{t}_chestplate",
            "minecraft:diamond",
            "minecraft:diamond_chestplate",
        )
    )
    tools_complement.append(
        (
            f"tools_complement:{t}_leggings",
            "minecraft:diamond",
            "minecraft:diamond_leggings",
        )
    )
    tools_complement.append(
        (f"tools_complement:{t}_boots", "minecraft:diamond", "minecraft:diamond_boots")
    )
    tools_complement.append(
        (
            f"tools_complement:{t}_sickle",
            "minecraft:diamond",
            "tools_complement:diamond_sickle",
        )
    )
    tools_complement.append(
        (
            f"tools_complement:{t}_knife",
            "minecraft:diamond",
            "tools_complement:diamond_knife",
        )
    )
    tools_complement.append(
        (
            f"tools_complement:{t}_hammer",
            "minecraft:diamond_block",
            "tools_complement:diamond_hammer",
        )
    )
    tools_complement.append(
        (
            f"tools_complement:{t}_excavator",
            "minecraft:diamond_block",
            "tools_complement:diamond_excavator",
        )
    )
    tools_complement.append(
        (
            "tools_complement:iron_sickle",
            "minecraft:diamond",
            "tools_complement:diamond_sickle",
        )
    )
    tools_complement.append(
        (
            "tools_complement:iron_knife",
            "minecraft:diamond",
            "tools_complement:diamond_knife",
        )
    )
    tools_complement.append(
        (
            "tools_complement:iron_hammer",
            "minecraft:diamond_block",
            "tools_complement:diamond_hammer",
        )
    )
    tools_complement.append(
        (
            "tools_complement:iron_excavator",
            "minecraft:diamond_block",
            "tools_complement:diamond_excavator",
        )
    )

recipe = {"type": "minecraft:smithing", "base": None, "addition": None, "result": None}


for left, upgrade, right in vanilla + immersive + tools_complement + mek + na:
    r = recipe.copy()
    r["base"] = {"item": left}
    if "#" in upgrade:
        r["addition"] = {"tag": upgrade.replace("#", "")}
    else:
        r["addition"] = {"item": upgrade}
    r["result"] = {"item": right}

    input_name = left.split(":")[1]
    output_name = right.split(":")[1]
    file_name = f"{output_name}_from_smithing_{input_name}.json"
    with open(f"./smithing/{file_name}", "w", encoding="utf-8") as fh:
        fh.write(json.dumps(r))
