ServerEvents.recipes((event) => {
  const Gears = () => {
    const AllGears = [
      { plate: "minecraft:diamond", gear: "thermal:diamond_gear", material: "forge:gems/diamond" },
      { plate: "minecraft:emerald", gear: "thermal:emerald_gear", material: "forge:gems/emerald" },
      { plate: "minecraft:lapis_lazuli", gear: "thermal:lapis_gear", material: "forge:gems/lapis" },
      { plate: "minecraft:quartz", gear: "thermal:quartz_gear", material: "forge:gems/quartz" },
      { plate: "thermal:bronze_plate", gear: "thermal:bronze_gear", material: "forge:ingots/bronze" },
      { plate: "thermal:constantan_plate", gear: "thermal:constantan_gear", material: "forge:ingots/constantan" },
      { plate: "thermal:copper_plate", gear: "thermal:copper_gear", material: "forge:ingots/copper" },
      { plate: "thermal:electrum_plate", gear: "thermal:electrum_gear", material: "forge:ingots/electrum" },
      { plate: "thermal:enderium_plate", gear: "thermal:enderium_gear", material: "forge:ingots/enderium" },
      { plate: "thermal:gold_plate", gear: "thermal:gold_gear", material: "forge:ingots/gold" },
      { plate: "thermal:invar_plate", gear: "thermal:invar_gear", material: "forge:ingots/invar" },
      { plate: "thermal:iron_plate", gear: "thermal:iron_gear", material: "forge:ingots/iron" },
      { plate: "thermal:lead_plate", gear: "thermal:lead_gear", material: "forge:ingots/lead" },
      { plate: "thermal:lumium_plate", gear: "thermal:lumium_gear", material: "forge:ingots/lumium" },
      { plate: "thermal:netherite_plate", gear: "thermal:netherite_gear", material: "forge:ingots/netherite" },
      { plate: "thermal:nickel_plate", gear: "thermal:nickel_gear", material: "forge:ingots/nickel" },
      { plate: "thermal:rose_gold_plate", gear: "thermal:rose_gold_gear", material: "forge:ingots/rose_gold" },
      { plate: "thermal:signalum_plate", gear: "thermal:signalum_gear", material: "forge:ingots/signalum" },
      { plate: "thermal:silver_plate", gear: "thermal:silver_gear", material: "forge:ingots/silver" },
      { plate: "thermal:steel_plate", gear: "thermal:steel_gear", material: "forge:ingots/steel" },
      { plate: "thermal:tin_plate", gear: "thermal:tin_gear", material: "forge:ingots/tin" },
    ];

    AllGears.forEach((x) => {
      event.remove({ output: x.gear });

      /* Crafting */
      event.shaped(x.gear, [" P ", "PCP", " P "], {
        P: x.plate,
        C: "create:cogwheel",
      });

      /* Thermal */
      event.custom({
        type: "thermal:press",
        ingredients: [{ tag: x.material, count: 4 }, { item: "thermal:press_gear_die" }],
        result: [{ item: x.gear }],
      });

      /* Immersive */
      event.custom({
        type: "immersiveengineering:metal_press",
        mold: "immersiveengineering:mold_gear",
        input: { base_ingredient: { tag: x.material }, count: 4 },
        result: { item: x.gear },
        energy: 2400,
      });
    });
  };

  const Plates = () => {
    // Remove the Ad Astra hammer & its uses
    event.remove({ input: "ad_astra:hammer" });
    event.remove({ output: "ad_astra:hammer" });

    // Remove all recipes using the IE hammer in order to get all of the plate
    event.remove({ input: "immersiveengineering:hammer" });

    // These two would have been removed, so re-add them
    event.shaped(Item.of("immersiveengineering:gunpart_barrel"), ["  H", " R ", "S  "], { H: "immersiveengineering:hammer", R: "#forge:rods/steel", S: "#forge:ingots/steel" });
    event.shapeless(Item.of("immersiveengineering:survey_tools"), [
      Item.of("minecraft:writable_book"),
      Item.of("minecraft:glass_bottle"),
      Item.of("immersiveengineering:hammer"),
      Item.of("immersiveengineering:hemp_fabric"),
      Item.of("immersiveengineering:hemp_fabric"),
      Item.of("immersiveengineering:hemp_fabric"),
    ]);

    // Completely redo all recipes just for consistency honestly.
    const PlateIngotMapping = [
      { plate: "thermal:constantan_plate", ingot: "forge:ingots/constantan" },
      { plate: "thermal:invar_plate", ingot: "forge:ingots/invar" },
      { plate: "thermal:electrum_plate", ingot: "forge:ingots/electrum" },
      { plate: "thermal:bronze_plate", ingot: "forge:ingots/bronze" },
      { plate: "thermal:nickel_plate", ingot: "forge:ingots/nickel" },
      { plate: "thermal:silver_plate", ingot: "forge:ingots/silver" },
      { plate: "thermal:lead_plate", ingot: "forge:ingots/lead" },
      { plate: "thermal:tin_plate", ingot: "forge:ingots/tin" },
      { plate: "thermal:enderium_plate", ingot: "forge:ingots/enderium" },
      { plate: "thermal:lumium_plate", ingot: "forge:ingots/lumium" },
      { plate: "thermal:signalum_plate", ingot: "forge:ingots/signalum" },
      { plate: "thermal:netherite_plate", ingot: "forge:ingots/netherite" },
      { plate: "thermal:copper_plate", ingot: "forge:ingots/copper" },
      { plate: "thermal:gold_plate", ingot: "forge:ingots/gold" },
      { plate: "thermal:iron_plate", ingot: "forge:ingots/iron" },
      { plate: "thermal:rose_gold_plate", ingot: "forge:ingots/rose_gold" },
      { plate: "thermal:steel_plate", ingot: "forge:ingots/steel" },
      { plate: "immersiveengineering:plate_uranium", ingot: "forge:ingots/uranium" },
      { plate: "immersiveengineering:plate_aluminum", ingot: "forge:ingots/aluminum" },
      { plate: "create:brass_sheet", ingot: "forge:ingots/brass" },
      { plate: "ad_astra:calorite_plate", ingot: "forge:ingots/calorite" },
      { plate: "ad_astra:ostrum_plate", ingot: "forge:ingots/ostrum" },
      { plate: "ad_astra:desh_plate", ingot: "forge:ingots/desh" },
    ];

    PlateIngotMapping.forEach((map) => {
      event.remove({ output: map.plate });
      /* Thermal */
      event.custom({
        type: "thermal:press",
        ingredient: { tag: map.ingot },
        result: [{ item: map.plate }],
      });
      /* Create */
      event.custom({
        type: "create:pressing",
        ingredients: [{ tag: map.ingot }],
        results: [{ item: map.plate }],
      });
      /* Immersive Engineering */
      event.custom({
        type: "immersiveengineering:metal_press",
        mold: "immersiveengineering:mold_plate",
        input: { tag: map.ingot },
        result: { item: map.plate },
        energy: 2400,
      });
      /* Ad Astra */
      event.custom({
        type: "ad_astra:compressing",
        input: { tag: map.ingot },
        output: { id: map.plate, count: 1 },
        cookTime: 200,
      });
    });
  };

  const FixConflictingRecipes = () => {
    /* Fix weird recipe for Logs -> Wood */
    event.remove({ output: "colorfulazaleas:titanium_azalea_wood" });
    event.remove({ output: "colorfulazaleas:walnut_azalea_wood" });
    event.remove({ output: "colorfulazaleas:bright_azalea_wood" });
    event.remove({ output: "colorfulazaleas:azule_azalea_wood" });
    event.remove({ output: "colorfulazaleas:roze_azalea_wood" });
    event.remove({ output: "colorfulazaleas:fiss_azalea_wood" });
    event.remove({ output: "colorfulazaleas:tecal_azalea_wood" });
    event.shaped(Item.of("colorfulazaleas:titanium_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:titanium_azalea_log" });
    event.shaped(Item.of("colorfulazaleas:walnut_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:walnut_azalea_log" });
    event.shaped(Item.of("colorfulazaleas:bright_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:bright_azalea_log" });
    event.shaped(Item.of("colorfulazaleas:azule_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:azule_azalea_log" });
    event.shaped(Item.of("colorfulazaleas:roze_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:roze_azalea_log" });
    event.shaped(Item.of("colorfulazaleas:fiss_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:fiss_azalea_log" });
    event.shaped(Item.of("colorfulazaleas:tecal_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:tecal_azalea_log" });

    /* Same but for stripped */
    event.remove({ output: "colorfulazaleas:stripped_titanium_azalea_wood" });
    event.remove({ output: "colorfulazaleas:stripped_walnut_azalea_wood" });
    event.remove({ output: "colorfulazaleas:stripped_bright_azalea_wood" });
    event.remove({ output: "colorfulazaleas:stripped_azule_azalea_wood" });
    event.remove({ output: "colorfulazaleas:stripped_roze_azalea_wood" });
    event.remove({ output: "colorfulazaleas:stripped_fiss_azalea_wood" });
    event.remove({ output: "colorfulazaleas:stripped_tecal_azalea_wood" });
    event.shaped(Item.of("colorfulazaleas:stripped_titanium_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:stripped_titanium_azalea_log" });
    event.shaped(Item.of("colorfulazaleas:stripped_walnut_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:stripped_walnut_azalea_log" });
    event.shaped(Item.of("colorfulazaleas:stripped_bright_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:stripped_bright_azalea_log" });
    event.shaped(Item.of("colorfulazaleas:stripped_azule_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:stripped_azule_azalea_log" });
    event.shaped(Item.of("colorfulazaleas:stripped_roze_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:stripped_roze_azalea_log" });
    event.shaped(Item.of("colorfulazaleas:stripped_fiss_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:stripped_fiss_azalea_log" });
    event.shaped(Item.of("colorfulazaleas:stripped_tecal_azalea_wood", 3), ["LL", "LL"], { L: "colorfulazaleas:stripped_tecal_azalea_log" });

    /* For some reason stripped can be turned back into logs? Jesus this mod didn't think */
    event.remove({ output: "colorfulazaleas:titanium_azalea_log" });
    event.remove({ output: "colorfulazaleas:walnut_azalea_log" });
    event.remove({ output: "colorfulazaleas:bright_azalea_log" });
    event.remove({ output: "colorfulazaleas:azule_azalea_log" });
    event.remove({ output: "colorfulazaleas:roze_azalea_log" });
    event.remove({ output: "colorfulazaleas:fiss_azalea_log" });
    event.remove({ output: "colorfulazaleas:tecal_azalea_log" });
    event.remove({ output: "colorfulazaleas:stripped_titanium_azalea_log" });
    event.remove({ output: "colorfulazaleas:stripped_walnut_azalea_log" });
    event.remove({ output: "colorfulazaleas:stripped_bright_azalea_log" });
    event.remove({ output: "colorfulazaleas:stripped_azule_azalea_log" });
    event.remove({ output: "colorfulazaleas:stripped_roze_azalea_log" });
    event.remove({ output: "colorfulazaleas:stripped_fiss_azalea_log" });
    event.remove({ output: "colorfulazaleas:stripped_tecal_azalea_log" });

    /* Tools Comp. Knives */
    event.remove({ id: "tools_complement:constantan_knife" });
    event.remove({ id: "tools_complement:invar_knife" });
    event.remove({ id: "tools_complement:electrum_knife" });
    event.remove({ id: "tools_complement:bronze_knife" });
    event.remove({ id: "tools_complement:nickel_knife" });
    event.remove({ id: "tools_complement:silver_knife" });
    event.remove({ id: "tools_complement:lead_knife" });
    event.remove({ id: "tools_complement:tin_knife" });
    event.remove({ id: "tools_complement:copper_knife" });
    event.remove({ id: "tools_complement:netherite_knife" });
    event.remove({ id: "tools_complement:diamond_knife" });
    event.remove({ id: "tools_complement:gold_knife" });
    event.remove({ id: "tools_complement:iron_knife" });

    event.shaped("tools_complement:constantan_knife", [" P", "S "], { S: "minecraft:stick", P: "#forge:plates/constantan" });
    event.shaped("tools_complement:invar_knife", [" P", "S "], { S: "minecraft:stick", P: "#forge:plates/invar" });
    event.shaped("tools_complement:electrum_knife", [" P", "S "], { S: "minecraft:stick", P: "#forge:plates/electrum" });
    event.shaped("tools_complement:bronze_knife", [" P", "S "], { S: "minecraft:stick", P: "#forge:plates/bronze" });
    event.shaped("tools_complement:nickel_knife", [" P", "S "], { S: "minecraft:stick", P: "#forge:plates/nickel" });
    event.shaped("tools_complement:silver_knife", [" P", "S "], { S: "minecraft:stick", P: "#forge:plates/silver" });
    event.shaped("tools_complement:lead_knife", [" P", "S "], { S: "minecraft:stick", P: "#forge:plates/lead" });
    event.shaped("tools_complement:tin_knife", [" P", "S "], { S: "minecraft:stick", P: "#forge:plates/tin" });
    event.shaped("tools_complement:copper_knife", [" P", "S "], { S: "minecraft:stick", P: "#forge:plates/copper" });
    event.shaped("tools_complement:gold_knife", [" P", "S "], { S: "minecraft:stick", P: "#forge:plates/gold" });
    event.shaped("tools_complement:iron_knife", [" P", "S "], { S: "minecraft:stick", P: "#forge:plates/iron" });

    /* Slag Glass */
    event.remove({ output: "immersiveengineering:slag_glass" });
    event.blasting("immersiveengineering:slag_glass", "immersiveengineering:slag_gravel");

    /* Ad Astra */
    event.remove({ id: "ad_astra:recipes/cracked_venus_sandstone_bricks_from_smelting_venus_stone_bricks" });
    event.smelting("ad_astra:cracked_venus_sandstone_bricks", "ad_astra:venus_sandstone");

    event.remove({ id: "ad_astra:recipes/moon_stone_brick_slab" });
    event.shaped("6x ad_astra:moon_stone_brick_slab", ["MMM"], { M: "ad_astra:moon_stone_bricks" });

    event.remove({ id: "ad_astra:recipes/mercury_stone_bricks" });
    event.remove({ id: "ad_astra:recipes/mars_stone_bricks" });
    event.remove({ id: "ad_astra:recipes/glacio_stone_bricks" });
    event.remove({ id: "ad_astra:recipes/moon_stone_bricks" });
    event.remove({ id: "ad_astra:recipes/venus_stone_bricks" });
    event.remove({ id: "ad_astra:recipes/permafrost_bricks" });

    event.shaped(Item.of("ad_astra:mercury_stone_bricks", 4), ["PP", "PP"], { P: "ad_astra:polished_mercury_stone" });
    event.shaped(Item.of("ad_astra:mars_stone_bricks", 4), ["PP", "PP"], { P: "ad_astra:polished_mars_stone" });
    event.shaped(Item.of("ad_astra:glacio_stone_bricks", 4), ["PP", "PP"], { P: "ad_astra:polished_glacio_stone" });
    event.shaped(Item.of("ad_astra:moon_stone_bricks", 4), ["PP", "PP"], { P: "ad_astra:polished_moon_stone" });
    event.shaped(Item.of("ad_astra:venus_stone_bricks", 4), ["PP", "PP"], { P: "ad_astra:polished_venus_stone" });
    event.shaped(Item.of("ad_astra:permafrost_bricks", 4), ["PP", "PP"], { P: "ad_astra:polished_permafrost" });
  };

  const DeduplicateResources = () => {
    /* Prioritize FD Crates */
    event.remove({ id: "thermal:storage/beetroot_block" });
    event.remove({ id: "thermal:storage/carrot_block" });
    event.remove({ id: "thermal:storage/potato_block" });

    /* IE Coal Coke */
    event.remove({ input: "immersiveengineering:coal_coke" });
    event.remove({ output: "immersiveengineering:coal_coke" });
    event.remove({ id: "immersiveengineering:crafting/coke_to_coal_coke" });
    event.remove({ id: "immersiveengineering:crafting/sawdust" });

    /* IE Sawdust */
    event.shaped("2x immersiveengineering:sawdust", ["SS"], { S: "#forge:dusts/wood" });

    /* Mek Tools */
    event.remove({ output: "mekanismtools:bronze_axe" });
    event.remove({ output: "mekanismtools:bronze_boots" });
    event.remove({ output: "mekanismtools:bronze_chestplate" });
    event.remove({ output: "mekanismtools:bronze_helmet" });
    event.remove({ output: "mekanismtools:bronze_hoe" });
    event.remove({ output: "mekanismtools:bronze_leggings" });
    event.remove({ output: "mekanismtools:bronze_pickaxe" });
    event.remove({ output: "mekanismtools:bronze_shovel" });
    event.remove({ output: "mekanismtools:bronze_sword" });
    event.remove({ output: "mekanismtools:lapis_lazuli_axe" });
    event.remove({ output: "mekanismtools:lapis_lazuli_boots" });
    event.remove({ output: "mekanismtools:lapis_lazuli_chestplate" });
    event.remove({ output: "mekanismtools:lapis_lazuli_helmet" });
    event.remove({ output: "mekanismtools:lapis_lazuli_hoe" });
    event.remove({ output: "mekanismtools:lapis_lazuli_leggings" });
    event.remove({ output: "mekanismtools:lapis_lazuli_paxel" });
    event.remove({ output: "mekanismtools:lapis_lazuli_pickaxe" });
    event.remove({ output: "mekanismtools:lapis_lazuli_shield" });
    event.remove({ output: "mekanismtools:lapis_lazuli_shovel" });
    event.remove({ output: "mekanismtools:lapis_lazuli_sword" });
    event.remove({ output: "mekanismtools:steel_axe" });
    event.remove({ output: "mekanismtools:steel_boots" });
    event.remove({ output: "mekanismtools:steel_chestplate" });
    event.remove({ output: "mekanismtools:steel_helmet" });
    event.remove({ output: "mekanismtools:steel_hoe" });
    event.remove({ output: "mekanismtools:steel_leggings" });
    event.remove({ output: "mekanismtools:steel_pickaxe" });
    event.remove({ output: "mekanismtools:steel_shovel" });
    event.remove({ output: "mekanismtools:steel_sword" });
  };

  Gears();
  Plates();

  FixConflictingRecipes();
  DeduplicateResources();

  event.remove({ output: "ad_astra:coal_generator" });
  event.remove({ output: "ad_astra:compressor" });
  event.shaped("ad_astra:compressor", ["IBI", "IMI", "IBI"], {
    I: "#forge:ingots/osmium",
    B: "#forge:storage_blocks/iron",
    M: "create:mechanical_press",
  });

  event.custom({
    type: "thermal:insolator",
    ingredient: { item: "moreminecarts:glass_cactus" },
    result: [
      { item: "moreminecarts:glass_cactus", chance: 1.0 },
      { item: "moreminecarts:glass_spines", chance: 0.05 },
    ],
  });

  // Magiks
  event.remove({ output: "botania:fertilizer" });
  event.shapeless(Item.of("botania:fertilizer", 16), ["minecraft:bone_meal", "thermal:apatite", "#forge:dyes"]);
});
