ServerEvents.recipes((event) => {
  const Thermal = (raw, ingot, nugget, dust) => {
    /* Pulverizer */
    event.custom({
      type: "thermal:pulverizer",
      ingredient: { tag: raw },
      result: [
        { item: dust, chance: 1.25 },
        { item: dust, chance: 0.05 },
      ],
      experience: 0.1,
    });

    /* Ind. Smelter */
    event.custom({
      type: "thermal:smelter",
      ingredient: { tag: raw },
      result: [
        { item: ingot, chance: 1.5, locked: true },
        { item: nugget, chance: 1.0 },
      ],
      experience: 0.1,
    });
  };

  const Mekanism = (ore, raw, rawBlock, dust, dirtyDust, shard, clump, ingot) => {
    /* To Shard */
    event.custom({
      type: "mekanism:injecting",
      chemicalInput: { amount: 1, gas: "mekanism:hydrogen_chloride" },
      itemInput: { ingredient: { tag: ore } },
      output: { count: 4, item: shard },
    });

    event.custom({
      type: "mekanism:injecting",
      chemicalInput: { amount: 1, gas: "mekanism:hydrogen_chloride" },
      itemInput: { amount: 3, ingredient: { tag: raw } },
      output: { count: 8, item: shard },
    });

    event.custom({
      type: "mekanism:injecting",
      chemicalInput: { amount: 2, gas: "mekanism:hydrogen_chloride" },
      itemInput: { ingredient: { tag: rawBlock } },
      output: { count: 24, item: shard },
    });

    /* To Dirty Dust */
    event.custom({
      type: "mekanism:crushing",
      input: { ingredient: { item: clump } },
      output: { item: dirtyDust },
    });

    /* To Clump */
    event.custom({
      type: "mekanism:purifying",
      chemicalInput: { amount: 1, gas: "mekanism:oxygen" },
      itemInput: { ingredient: { item: shard } },
      output: { item: clump },
    });

    event.custom({
      type: "mekanism:purifying",
      chemicalInput: { amount: 1, gas: "mekanism:oxygen" },
      itemInput: { ingredient: { tag: ore } },
      output: { count: 3, item: clump },
    });

    event.custom({
      type: "mekanism:purifying",
      chemicalInput: { amount: 1, gas: "mekanism:oxygen" },
      itemInput: { ingredient: { tag: raw } },
      output: { count: 2, item: clump },
    });

    event.custom({
      type: "mekanism:purifying",
      chemicalInput: { amount: 2, gas: "mekanism:oxygen" },
      itemInput: { ingredient: { tag: rawBlock } },
      output: { count: 18, item: clump },
    });

    /* To Dust */
    event.custom({
      type: "mekanism:crushing",
      input: { ingredient: { tag: ingot } },
      output: { item: dust },
    });

    event.custom({
      type: "mekanism:enriching",
      input: { amount: 3, ingredient: { tag: raw } },
      output: { count: 4, item: dust },
    });

    event.custom({
      type: "mekanism:enriching",
      input: { ingredient: { tag: ore } },
      output: { count: 2, item: dust },
    });

    event.custom({
      type: "mekanism:enriching",
      input: { ingredient: { item: dirtyDust } },
      output: { item: dust },
    });

    event.custom({
      type: "mekanism:enriching",
      input: { ingredient: { tag: rawBlock } },
      output: { count: 12, item: dust },
    });
  };

  Thermal("forge:raw_materials/zinc", "create:zinc_ingot", "create:zinc_nugget", "kubejs:zinc_dust");
  Thermal("forge:raw_materials/aluminum", "immersiveengineering:ingot_aluminum", "immersiveengineering:nugget_aluminum", "immersiveengineering:dust_aluminum");
  Thermal("forge:raw_materials/osmium", "mekanism:ingot_osmium", "mekanism:nugget_osmium", "mekanism:dust_osmium");
  Thermal("forge:raw_materials/uranium", "mekanism:ingot_uranium", "mekanism:nugget_uranium", "mekanism:dust_uranium");

  Mekanism("forge:ores/zinc", "forge:raw_materials/zinc", "forge:storage_blocks/raw_zinc", "kubejs:zinc_dust", "kubejs:dirty_zinc_dust", "kubejs:zinc_shard", "kubejs:zinc_clump", "forge:ingots/zinc");

  Mekanism(
    "forge:ores/nickel",
    "forge:raw_materials/nickel",
    "forge:storage_blocks/raw_nickel",
    "thermal:nickel_dust",
    "kubejs:dirty_nickel_dust",
    "kubejs:nickel_shard",
    "kubejs:nickel_clump",
    "forge:ingots/nickel"
  );

  Mekanism(
    "forge:ores/silver",
    "forge:raw_materials/silver",
    "forge:storage_blocks/raw_silver",
    "thermal:silver_dust",
    "kubejs:dirty_silver_dust",
    "kubejs:silver_shard",
    "kubejs:silver_clump",
    "forge:ingots/silver"
  );

  Mekanism(
    "forge:ores/aluminum",
    "forge:raw_materials/aluminum",
    "forge:storage_blocks/raw_aluminum",
    "immersiveengineering:dust_aluminum",
    "kubejs:dirty_aluminum_dust",
    "kubejs:aluminum_shard",
    "kubejs:aluminum_clump",
    "forge:ingots/aluminum"
  );

  event.smelting("create:zinc_ingot", "kubejs:zinc_dust");
  event.blasting("create:zinc_ingot", "kubejs:zinc_dust");
});
