ServerEvents.recipes((event) => {
  const ChestFrom = (output, plank) => event.shaped(output, ["PPP", "P P", "PPP"], { P: plank });

  const Chests = () => {
    /* Chests from non-chestable planks */
    ChestFrom(Item.of("minecraft:chest"), "#minecraft:planks/chestless");
    event.shapeless("minecraft:chest", ["#forge:chests/wooden"]);

    /* Make Twilight Forest chests not suck to craft */
    event.remove({ output: "twilightforest:transformation_chest" });
    event.remove({ output: "twilightforest:mining_chest" });
    event.remove({ output: "twilightforest:sorting_chest" });
    event.remove({ output: "twilightforest:time_chest" });
    event.remove({ output: "twilightforest:darkwood_chest" });
    event.remove({ output: "twilightforest:mangrove_chest" });
    event.remove({ output: "twilightforest:canopy_chest" });
    event.remove({ output: "twilightforest:twilight_oak_chest" });

    ChestFrom(Item.of("twilightforest:transformation_chest"), Item.of("twilightforest:twilight_oak_planks"));
    ChestFrom(Item.of("twilightforest:mining_chest"), Item.of("twilightforest:canopy_planks"));
    ChestFrom(Item.of("twilightforest:sorting_chest"), Item.of("twilightforest:mangrove_planks"));
    ChestFrom(Item.of("twilightforest:time_chest"), Item.of("twilightforest:dark_planks"));
    ChestFrom(Item.of("twilightforest:darkwood_chest"), Item.of("twilightforest:time_planks"));
    ChestFrom(Item.of("twilightforest:mangrove_chest"), Item.of("twilightforest:sorting_planks"));
    ChestFrom(Item.of("twilightforest:canopy_chest"), Item.of("twilightforest:mining_planks"));
    ChestFrom(Item.of("twilightforest:twilight_oak_chest"), Item.of("twilightforest:transformation_planks"));

    /* Fix copper chests requiring a minecraft:chest */
    event.remove({ output: "ironchests:copper_chest" });
    event.shaped("ironchests:copper_chest", ["UUU", "UCU", "UUU"], { U: "#forge:ingots/copper", C: "#forge:chests/wooden" });
  };

  const Backpacked = () => {
    event.remove({ output: "backpacked:backpack" });
    event.shaped("backpacked:backpack", ["lll", "scs", "lll"], {
      l: "minecraft:leather",
      c: "#forge:chests/wooden",
      s: "minecraft:string",
    });
  };

  const DimensionalStorage = () => {
    event.remove({ mod: "dimstorage" });
    event.shaped(Item.of("dimstorage:dimensional_chest"), ["SSS", "ECE", "SSS"], {
      C: "#forge:chests/wooden",
      E: "#forge:ingots/enderium",
      S: "#immersiveengineering:scaffoldings/steel",
    });

    event.shaped(Item.of("dimstorage:dimensional_tank"), ["SSS", "ECE", "SSS"], {
      C: "mekanism:basic_fluid_tank",
      E: "#forge:ingots/enderium",
      S: "#immersiveengineering:scaffoldings/steel",
    });

    event.shaped(Item.of("dimstorage:dimensional_tablet"), ["SSS", "ECE", "SSS"], {
      C: "backpacked:backpack",
      E: "#forge:ingots/enderium",
      S: "#forge:plates/steel",
    });
  };

  Chests();
  Backpacked();
  DimensionalStorage();
});
