/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect;

import hellfirepvp.astralsorcery.client.effect.IComplexEffect;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.util.EntityUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.function.Function;
import net.minecraft.entity.Entity;

public abstract class EntityComplexFX
implements IComplexEffect {
    private static long counter = 0L;
    public final long id = counter++;
    protected int age = 0;
    protected int maxAge = 40;
    protected boolean removeRequested = false;
    private boolean flagRemoved = true;

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public int getAge() {
        return this.age;
    }

    @Override
    public boolean canRemove() {
        return this.age >= this.maxAge || this.removeRequested;
    }

    @Override
    public IComplexEffect.RenderTarget getRenderTarget() {
        return IComplexEffect.RenderTarget.RENDERLOOP;
    }

    @Override
    public void tick() {
        ++this.age;
    }

    public void requestRemoval() {
        this.removeRequested = true;
    }

    @Override
    public boolean isRemoved() {
        return this.flagRemoved;
    }

    @Override
    public void flagAsRemoved() {
        this.flagRemoved = true;
        this.removeRequested = false;
    }

    @Override
    public void clearRemoveFlag() {
        this.flagRemoved = false;
    }

    public static interface RefreshFunction {
        public boolean shouldRefresh();
    }

    public static interface ScaleFunction<T extends IComplexEffect> {
        public float getScale(T var1, float var2, float var3);

        public static class Shrink<T extends EntityComplexFX>
        implements ScaleFunction<T> {
            @Override
            public float getScale(T fx, float pTicks, float scaleIn) {
                float prevAge = Math.max(0.0f, (float)((EntityComplexFX)fx).getAge() - 1.0f) / (float)((EntityComplexFX)fx).getMaxAge();
                float currAge = Math.max(0.0f, (float)((EntityComplexFX)fx).getAge()) / (float)((EntityComplexFX)fx).getMaxAge();
                return (float)((double)scaleIn * (1.0 - RenderingUtils.interpolate(prevAge, currAge, pTicks)));
            }
        }
    }

    public static interface MotionController<T extends IComplexEffect> {
        public Vector3 updateMotion(T var1, Vector3 var2);

        public static class EntityTarget<T extends IComplexEffect>
        implements MotionController<T> {
            private final Entity target;
            private final Function<T, Vector3> positionFunction;

            public EntityTarget(Entity target, Function<T, Vector3> positionFunction) {
                this.target = target;
                this.positionFunction = positionFunction;
            }

            @Override
            public Vector3 updateMotion(T fx, Vector3 motion) {
                if (this.target.field_70128_L) {
                    return motion;
                }
                EntityUtils.applyVortexMotion(v -> this.positionFunction.apply((IComplexEffect)fx), motion::add, Vector3.atEntityCorner(this.target), 256.0, 1.0);
                return motion.multiply(0.9);
            }
        }
    }

    public static interface PositionController<T extends IComplexEffect> {
        public Vector3 updatePosition(T var1, Vector3 var2, Vector3 var3);
    }

    public static interface RenderOffsetController {
        public Vector3 changeRenderPosition(EntityComplexFX var1, Vector3 var2, Vector3 var3, float var4);
    }

    public static enum AlphaFunction {
        CONSTANT,
        FADE_OUT,
        PYRAMID;


        public float getAlpha(int age, int maxAge) {
            switch (this) {
                case CONSTANT: {
                    return 1.0f;
                }
                case FADE_OUT: {
                    return 1.0f - (float)age / (float)maxAge;
                }
                case PYRAMID: {
                    float halfAge = (float)maxAge / 2.0f;
                    return 1.0f - Math.abs(halfAge - (float)age) / halfAge;
                }
            }
            return 1.0f;
        }
    }
}

