/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.block;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.util.AirBlockRenderWorld;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class EffectTranslucentFallingBlock
extends EntityComplexFX {
    private final IBlockState blockState;
    private EntityComplexFX.MotionController<EffectTranslucentFallingBlock> motionController = (fx, v) -> v;
    private EntityComplexFX.PositionController<EffectTranslucentFallingBlock> positionController = (fx, v, m) -> v.add(m);
    private Vector3 rotationDegreeAxis = new Vector3();
    private Vector3 prevRotationDegreeAxis = new Vector3();
    private Vector3 rotationChange = new Vector3();
    private Vector3 motion = new Vector3();
    private Vector3 position = new Vector3();
    private Vector3 prevPosition = new Vector3();
    private EntityComplexFX.AlphaFunction alphaFunction = EntityComplexFX.AlphaFunction.CONSTANT;
    private float alphaMultiplier = 1.0f;
    private EntityComplexFX.ScaleFunction<EffectTranslucentFallingBlock> scaleFunction = (fx, pTicks, scaleIn) -> 1.0f;
    private float scale = 1.0f;
    private boolean disableDepth = false;

    public EffectTranslucentFallingBlock(IBlockState blockState) {
        this.blockState = blockState;
    }

    public EffectTranslucentFallingBlock setDisableDepth(boolean disableDepth) {
        this.disableDepth = disableDepth;
        return this;
    }

    public EffectTranslucentFallingBlock setPosition(Vector3 position) {
        this.position = position;
        this.prevPosition = this.position.clone();
        return this;
    }

    public EffectTranslucentFallingBlock setPosition(double x, double y, double z) {
        this.position = new Vector3(x, y, z);
        this.prevPosition = this.position.clone();
        return this;
    }

    public EffectTranslucentFallingBlock setMotion(Vector3 motion) {
        this.motion = motion;
        return this;
    }

    public EffectTranslucentFallingBlock setMotion(double x, double y, double z) {
        this.motion = new Vector3(x, y, z);
        return this;
    }

    public EffectTranslucentFallingBlock setMotionController(EntityComplexFX.MotionController<EffectTranslucentFallingBlock> motionController) {
        this.motionController = motionController;
        return this;
    }

    public EffectTranslucentFallingBlock setPositionController(EntityComplexFX.PositionController<EffectTranslucentFallingBlock> positionController) {
        this.positionController = positionController;
        return this;
    }

    public EffectTranslucentFallingBlock setAlphaFunction(EntityComplexFX.AlphaFunction alphaFunction) {
        this.alphaFunction = alphaFunction;
        return this;
    }

    public EffectTranslucentFallingBlock setAlphaMultiplier(float alphaMultiplier) {
        this.alphaMultiplier = alphaMultiplier;
        return this;
    }

    public EffectTranslucentFallingBlock setScaleFunction(EntityComplexFX.ScaleFunction<EffectTranslucentFallingBlock> scaleFunction) {
        this.scaleFunction = scaleFunction;
        return this;
    }

    public EffectTranslucentFallingBlock setScale(float scale) {
        this.scale = scale;
        return this;
    }

    public EffectTranslucentFallingBlock tumble() {
        this.rotationDegreeAxis = Vector3.positiveYRandom().multiply(360);
        this.rotationChange = Vector3.random().multiply(12);
        return this;
    }

    public Vector3 getMotion() {
        return this.motion;
    }

    public Vector3 getPosition() {
        return this.position;
    }

    public Vector3 getRotation() {
        return this.rotationDegreeAxis;
    }

    public Vector3 getInterpolatedPosition(float percent) {
        return new Vector3(RenderingUtils.interpolate(this.prevPosition.getX(), this.position.getX(), percent), RenderingUtils.interpolate(this.prevPosition.getY(), this.position.getY(), percent), RenderingUtils.interpolate(this.prevPosition.getZ(), this.position.getZ(), percent));
    }

    public Vector3 getInterpolatedRotation(float percent) {
        return new Vector3(RenderingUtils.interpolate(this.prevRotationDegreeAxis.getX(), this.rotationDegreeAxis.getX(), percent), RenderingUtils.interpolate(this.prevRotationDegreeAxis.getY(), this.rotationDegreeAxis.getY(), percent), RenderingUtils.interpolate(this.prevRotationDegreeAxis.getZ(), this.rotationDegreeAxis.getZ(), percent));
    }

    @Override
    public int getLayer() {
        return 1;
    }

    @Override
    public void tick() {
        super.tick();
        Vector3 motion = this.motion.clone();
        if (this.motionController != null) {
            motion = this.motionController.updateMotion(this, motion);
        }
        this.motion = motion.clone();
        if (this.positionController != null) {
            Vector3 newPos = this.positionController.updatePosition(this, this.position.clone(), this.motion);
            this.prevPosition = this.position.clone();
            this.position = newPos;
        } else {
            this.prevPosition = this.position.clone();
            this.position.add(this.motion);
        }
        if (this.rotationChange.lengthSquared() > 0.0) {
            this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone();
            this.rotationDegreeAxis.add(this.rotationChange);
        }
    }

    @Override
    public void render(float pTicks) {
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        Blending.ADDITIVEDARK.apply();
        if (this.disableDepth) {
            GL11.glDisable((int)2929);
        }
        GL11.glDisable((int)2884);
        RenderingUtils.removeStandartTranslationFromTESRMatrix(pTicks);
        Vector3 translateTo = this.getInterpolatedPosition(pTicks);
        GL11.glTranslated((double)translateTo.getX(), (double)translateTo.getY(), (double)translateTo.getZ());
        float alpha = this.alphaFunction.getAlpha(this.age, this.maxAge);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(alpha *= this.alphaMultiplier));
        float scaleF = this.scale;
        scaleF = this.scaleFunction.getScale(this, pTicks, scaleF);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        GL11.glScaled((double)scaleF, (double)scaleF, (double)scaleF);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        Vector3 rotation = this.getInterpolatedRotation(pTicks);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        GL11.glRotated((double)rotation.getX(), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rotation.getY(), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotation.getZ(), (double)0.0, (double)0.0, (double)1.0);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        AirBlockRenderWorld world = new AirBlockRenderWorld(Biomes.field_76772_c, Minecraft.func_71410_x().field_71441_e.func_175624_G());
        Minecraft.func_71410_x().func_175602_ab().func_175018_a(this.blockState, BlockPos.field_177992_a, (IBlockAccess)world, vb);
        tes.func_78381_a();
        GL11.glEnable((int)2884);
        if (this.disableDepth) {
            GL11.glEnable((int)2929);
        }
        Blending.DEFAULT.apply();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        TextureHelper.refreshTextureBindState();
    }
}

