/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.controller;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class OrbitalEffectController
extends EntityComplexFX {
    private final OrbitPointEffect effect;
    private final OrbitPersistence persistence;
    private final OrbitTickModifier tickModifier;
    private double orbitRadius = 1.0;
    private int tickOffset = 0;
    private Vector3 orbitAxis = Vector3.RotAxis.Y_AXIS;
    private Vector3 offset = new Vector3();

    public OrbitalEffectController(OrbitPointEffect effect, @Nullable OrbitPersistence persistence, @Nullable OrbitTickModifier tickModifier) {
        this.effect = effect;
        this.persistence = persistence;
        this.tickModifier = tickModifier;
        this.maxAge = 60;
    }

    public OrbitalEffectController setTicksPerRotation(int ticks) {
        this.maxAge = ticks;
        return this;
    }

    public OrbitalEffectController setOrbitRadius(double orbitRadius) {
        this.orbitRadius = orbitRadius;
        return this;
    }

    public OrbitalEffectController setOrbitAxis(Vector3 orbitAxis) {
        this.orbitAxis = orbitAxis;
        return this;
    }

    public OrbitalEffectController setTickOffset(int tickOffset) {
        this.tickOffset = tickOffset;
        return this;
    }

    public OrbitalEffectController setOffset(Vector3 offset) {
        this.offset = offset;
        return this;
    }

    public Vector3 getOffset() {
        return this.offset;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.canRemove() && this.persistence != null && this.persistence.canPersist(this)) {
            this.age = 0;
        }
        if (this.tickModifier != null) {
            this.tickModifier.onTick(this);
        }
        this.scheduleEffects();
    }

    private void scheduleEffects() {
        Vector3 point = this.orbitAxis.clone().perpendicular().normalize().multiply(this.orbitRadius).rotate(Math.toRadians(this.getRotationDegree()), this.orbitAxis).add(this.offset);
        this.effect.doPointTickEffect(this, point);
    }

    public double getRotationDegree() {
        double perc = (double)((this.age + this.tickOffset) % this.maxAge) / (double)this.maxAge;
        return 360.0 * perc;
    }

    @Override
    public void render(float pTicks) {
    }

    public static interface OrbitPointEffect {
        public void doPointTickEffect(OrbitalEffectController var1, Vector3 var2);
    }

    public static interface OrbitTickModifier {
        public void onTick(OrbitalEffectController var1);
    }

    public static interface OrbitPersistence {
        public boolean canPersist(OrbitalEffectController var1);
    }
}

