/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.GuiJournalConstellationCluster;
import hellfirepvp.astralsorcery.client.gui.GuiJournalPerkMap;
import hellfirepvp.astralsorcery.client.gui.GuiJournalProgression;
import hellfirepvp.astralsorcery.client.gui.journal.GuiScreenJournal;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.MoonPhaseRenderHelper;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellationSpecialShowup;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.MoonPhase;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;

public class GuiJournalConstellationDetails
extends GuiScreenJournal {
    private static final BindableResource texBlack = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MISC, "black");
    private static final BindableResource texBg = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guiresbgcst");
    private static final BindableResource texArrow = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guijarrow");
    private IConstellation constellation;
    private GuiJournalConstellationCluster origin;
    private boolean detailed;
    private Rectangle rectBack;
    private List<MoonPhase> phases = new LinkedList<MoonPhase>();
    private List<MoonPhase> activePhases = new LinkedList<MoonPhase>();
    private List<String> locText = new LinkedList<String>();

    public GuiJournalConstellationDetails(GuiJournalConstellationCluster origin, IConstellation c) {
        super(-1);
        this.origin = origin;
        this.constellation = c;
        boolean has = false;
        for (String strConstellation : ResearchManager.clientProgress.getKnownConstellations()) {
            IConstellation ce = ConstellationRegistry.getConstellationByName(strConstellation);
            if (ce == null || !ce.equals(c)) continue;
            has = true;
            break;
        }
        this.detailed = has;
        this.testPhases();
        this.testActivePhases();
        this.buildLines();
    }

    private void buildLines() {
        String text;
        String unloc = this.constellation.getUnlocalizedName() + ".effect";
        if (unloc.equals(text = I18n.func_135052_a((String)unloc, (Object[])new Object[0]))) {
            return;
        }
        LinkedList<String> lines = new LinkedList<String>();
        for (String segment : text.split("<NL>")) {
            lines.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(segment, 175));
            lines.add("");
        }
        this.locText.addAll(lines);
    }

    private void testPhases() {
        if (this.constellation instanceof IWeakConstellation) {
            Collections.addAll(this.phases, MoonPhase.values());
        } else if (this.constellation instanceof IMinorConstellation) {
            for (MoonPhase ph : MoonPhase.values()) {
                if (!((IMinorConstellation)this.constellation).getShowupMoonPhases().contains((Object)ph)) continue;
                this.phases.add(ph);
            }
        }
    }

    private void testActivePhases() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        WorldSkyHandler handler = ConstellationSkyHandler.getInstance().getWorldHandler((World)Minecraft.func_71410_x().field_71441_e);
        if (handler == null) {
            return;
        }
        for (MoonPhase phase : this.phases) {
            List<IConstellation> active = handler.getConstellationsForMoonPhase(phase);
            if (active == null || active.isEmpty() || !active.contains(this.constellation)) continue;
            this.activePhases.add(phase);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        this.drawCstBackground();
        this.drawDefault(textureResShellCst);
        this.field_73735_i += 150.0f;
        this.drawArrows(partialTicks);
        this.drawConstellation(partialTicks);
        this.drawPhaseInformation();
        this.drawExtendedInformation();
        this.field_73735_i -= 150.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private void drawCstBackground() {
        texBlack.bind();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder bb = tes.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bb.func_181662_b((double)(this.guiLeft + 15), (double)(this.guiTop + 240), (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        bb.func_181662_b((double)(this.guiLeft + 200), (double)(this.guiTop + 240), (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        bb.func_181662_b((double)(this.guiLeft + 200), (double)(this.guiTop + 10), (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        bb.func_181662_b((double)(this.guiLeft + 15), (double)(this.guiTop + 10), (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179131_c((float)0.8f, (float)0.8f, (float)1.0f, (float)0.7f);
        texBg.bind();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bb.func_181662_b((double)(this.guiLeft + 35), (double)(this.guiTop + this.guiHeight - 10), (double)this.field_73735_i).func_187315_a(0.3, 0.9).func_181675_d();
        bb.func_181662_b((double)(this.guiLeft + 35 + 170), (double)(this.guiTop + this.guiHeight - 10), (double)this.field_73735_i).func_187315_a(0.7, 0.9).func_181675_d();
        bb.func_181662_b((double)(this.guiLeft + 35 + 170), (double)(this.guiTop + 10), (double)this.field_73735_i).func_187315_a(0.7, 0.1).func_181675_d();
        bb.func_181662_b((double)(this.guiLeft + 35), (double)(this.guiTop + 10), (double)this.field_73735_i).func_187315_a(0.3, 0.1).func_181675_d();
        tes.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawExtendedInformation() {
        float br = 0.8666f;
        GlStateManager.func_179131_c((float)br, (float)br, (float)br, (float)0.8f);
        String info = I18n.func_135052_a((String)this.constellation.getUnlocalizedInfo(), (Object[])new Object[0]).toUpperCase();
        info = this.detailed ? info : "???";
        TextureHelper.refreshTextureBindState();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        double width = fr.func_78256_a(info);
        double chX = 305.0 - width / 2.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179137_b((double)((double)this.guiLeft + chX), (double)(this.guiTop + 44), (double)0.0);
        fr.func_175065_a(info, 0.0f, 0.0f, -857874979, true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)br, (float)br, (float)br, (float)0.8f);
        TextureHelper.refreshTextureBindState();
        if (this.detailed && !this.locText.isEmpty()) {
            int offsetX = 220;
            int offsetY = 77;
            for (String s : this.locText) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179097_i();
                GlStateManager.func_179109_b((float)(this.guiLeft + offsetX), (float)(this.guiTop + offsetY), (float)0.0f);
                fr.func_175065_a(s, 0.0f, 0.0f, -857874979, true);
                GlStateManager.func_179126_j();
                GlStateManager.func_179121_F();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179131_c((float)br, (float)br, (float)br, (float)0.8f);
                TextureHelper.refreshTextureBindState();
                offsetY += 13;
            }
        }
    }

    private void drawPhaseInformation() {
        if (this.constellation instanceof IConstellationSpecialShowup) {
            GlStateManager.func_179097_i();
            double scale = 1.8;
            TextureHelper.refreshTextureBindState();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            double length = (double)fr.func_78256_a("? ? ?") * scale;
            double offsetLeft = (double)(this.guiLeft + 296) - length / 2.0;
            int offsetTop = this.guiTop + 199;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(offsetLeft + 10.0), (double)offsetTop, (double)0.0);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            fr.func_175063_a("? ? ?", 0.0f, 0.0f, -857874979);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            TextureHelper.refreshTextureBindState();
            GlStateManager.func_179126_j();
        } else if (ResearchManager.clientProgress.hasConstellationDiscovered(this.constellation.getUnlocalizedName())) {
            MoonPhase ph;
            int i;
            GlStateManager.func_179147_l();
            Blending.DEFAULT.applyStateManager();
            GlStateManager.func_179131_c((float)0.7f, (float)0.7f, (float)0.7f, (float)0.6f);
            int size = 19;
            int offsetX = 95 + this.field_146294_l / 2 - this.phases.size() * (size + 2) / 2;
            int offsetY = 199 + this.guiTop;
            for (i = 0; i < this.phases.size(); ++i) {
                ph = this.phases.get(i);
                if (this.activePhases.contains((Object)ph)) continue;
                MoonPhaseRenderHelper.getMoonPhaseTexture(ph).bind();
                this.drawRect(offsetX + i * (size + 2), offsetY, size, size);
            }
            Blending.PREALPHA.applyStateManager();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (i = 0; i < this.phases.size(); ++i) {
                ph = this.phases.get(i);
                if (!this.activePhases.contains((Object)ph)) continue;
                MoonPhaseRenderHelper.getMoonPhaseTexture(ph).bind();
                this.drawRect(offsetX + i * (size + 2), offsetY, size, size);
            }
            Blending.DEFAULT.applyStateManager();
            TextureHelper.refreshTextureBindState();
        } else {
            GlStateManager.func_179147_l();
            Blending.DEFAULT.applyStateManager();
            GlStateManager.func_179131_c((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
            int size = 19;
            int offsetX = 95 + this.field_146294_l / 2 - this.phases.size() * (size + 2) / 2;
            int offsetY = 199 + this.guiTop;
            for (int i = 0; i < this.phases.size(); ++i) {
                MoonPhase ph = this.phases.get(i);
                MoonPhaseRenderHelper.getMoonPhaseTexture(ph).bind();
                this.drawRect(offsetX + i * (size + 2), offsetY, size, size);
            }
            TextureHelper.refreshTextureBindState();
        }
    }

    private void drawConstellation(final float partial) {
        float br = 0.866f;
        GlStateManager.func_179131_c((float)br, (float)br, (float)br, (float)0.8f);
        String name = I18n.func_135052_a((String)this.constellation.getUnlocalizedName(), (Object[])new Object[0]).toUpperCase();
        TextureHelper.refreshTextureBindState();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        double width = fr.func_78256_a(name);
        double offsetX = 305.0 - width * 1.8 / 2.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179137_b((double)((double)this.guiLeft + offsetX), (double)(this.guiTop + 26), (double)0.0);
        GlStateManager.func_179139_a((double)1.8, (double)1.8, (double)1.8);
        fr.func_175065_a(name, 0.0f, 0.0f, -287449635, true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)br, (float)br, (float)br, (float)0.8f);
        TextureHelper.refreshTextureBindState();
        String dstInfo = "astralsorcery.journal.constellation.dst.";
        dstInfo = this.constellation instanceof IMajorConstellation ? dstInfo + "major" : (this.constellation instanceof IWeakConstellation ? dstInfo + "weak" : dstInfo + "minor");
        if (!this.detailed) {
            dstInfo = "???";
        }
        dstInfo = I18n.func_135052_a((String)dstInfo, (Object[])new Object[0]);
        width = fr.func_78256_a(dstInfo);
        offsetX = 305.0 - width / 2.0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179137_b((double)((double)this.guiLeft + offsetX), (double)(this.guiTop + 219), (double)0.0);
        fr.func_175065_a(dstInfo, 0.0f, 0.0f, -1713512995, true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        TextureHelper.refreshTextureBindState();
        final Random rand = new Random(4726142277924544921L);
        GlStateManager.func_179147_l();
        Blending.DEFAULT.apply();
        boolean known = ResearchManager.clientProgress.hasConstellationDiscovered(this.constellation.getUnlocalizedName());
        RenderConstellation.renderConstellationIntoGUI(known ? this.constellation.getConstellationColor() : this.constellation.getTierRenderColor(), this.constellation, this.guiLeft + 40, this.guiTop + 60, this.field_73735_i, 150, 150, 2.0, new RenderConstellation.BrightnessFunction(){

            @Override
            public float getBrightness() {
                return 0.3f + 0.7f * RenderConstellation.conCFlicker(ClientScheduler.getClientTick(), partial, 12 + rand.nextInt(10));
            }
        }, true, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawArrows(float partialTicks) {
        Point mouse = this.getCurrentMousePoint();
        int width = 30;
        int height = 15;
        this.rectBack = new Rectangle(this.guiLeft + 197, this.guiTop + 230, width, height);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(this.rectBack.getX() + (double)(width / 2)), (double)(this.rectBack.getY() + (double)(height / 2)), (double)0.0);
        float uFrom = 0.0f;
        float vFrom = 0.5f;
        if (this.rectBack.contains(mouse)) {
            uFrom = 0.5f;
            GlStateManager.func_179139_a((double)1.1, (double)1.1, (double)1.1);
        } else {
            double t = (float)ClientScheduler.getClientTick() + partialTicks;
            float sin = (float)Math.sin(t / 4.0) / 32.0f + 1.0f;
            GlStateManager.func_179152_a((float)sin, (float)sin, (float)sin);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GlStateManager.func_179109_b((float)(-(width / 2)), (float)(-(height / 2)), (float)0.0f);
        texArrow.bind();
        this.drawTexturedRectAtCurrentPos(width, height, uFrom, vFrom, 0.5f, 0.5f);
        GlStateManager.func_179121_F();
    }

    @Override
    protected boolean handleRightClickClose(int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.origin);
        return true;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        Point p = new Point(mouseX, mouseY);
        if (this.rectResearchBookmark != null && this.rectResearchBookmark.contains(p)) {
            GuiJournalProgression.resetJournal();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiJournalProgression.getJournalInstance());
            return;
        }
        if (this.rectConstellationBookmark != null && this.rectConstellationBookmark.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiJournalConstellationCluster.getConstellationScreen());
            return;
        }
        if (this.rectPerkMapBookmark != null && this.rectPerkMapBookmark.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalPerkMap());
            return;
        }
        if (this.rectBack != null && this.rectBack.contains(p)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)this.origin);
        }
    }
}

