/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.gui.base.GuiTileBase;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.constellation.DrawnConstellation;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.starmap.ActiveStarMap;
import hellfirepvp.astralsorcery.common.data.DataActiveCelestials;
import hellfirepvp.astralsorcery.common.data.SyncDataHolder;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.ItemInfusedGlass;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktBurnParchment;
import hellfirepvp.astralsorcery.common.network.packet.client.PktEngraveGlass;
import hellfirepvp.astralsorcery.common.tile.TileMapDrawingTable;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiMapDrawing
extends GuiTileBase<TileMapDrawingTable> {
    public static final BindableResource texMapDrawing = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guidrawing");
    public static final BindableResource texMapDrawingEmpty = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "guidrawing_empty");
    private static final Rectangle rctDrawingGrid = new Rectangle(98, 75, 60, 60);
    private Map<Rectangle, IConstellation> mapRenderedConstellations = new HashMap<Rectangle, IConstellation>();
    private List<DrawnConstellation> drawnConstellations = new LinkedList<DrawnConstellation>();
    private IConstellation dragging = null;
    private int dragRequested = 0;

    public GuiMapDrawing(TileMapDrawingTable table) {
        super(table, 188, 256);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        TileMapDrawingTable tile = (TileMapDrawingTable)((Object)this.getOwningTileEntity());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!tile.hasParchment()) {
            this.drawWHRect(texMapDrawingEmpty);
        } else {
            this.drawWHRect(texMapDrawing);
        }
        this.mapRenderedConstellations.clear();
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        List tooltip = null;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        boolean hasLens = false;
        if (this.field_146296_j != null) {
            FontRenderer custom;
            Rectangle rc;
            float prev = this.field_73735_i;
            float itemPrev = this.field_146296_j.field_77023_b;
            this.field_73735_i += 100.0f;
            this.field_146296_j.field_77023_b += 100.0f;
            ItemStack in = tile.getSlotIn();
            if (!in.func_190926_b()) {
                rc = new Rectangle(this.guiLeft + 111, this.guiTop + 8, 16, 16);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)rc.x, (float)rc.y, (float)0.0f);
                GlStateManager.func_179126_j();
                this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, in, 0, 0);
                this.field_146296_j.func_180453_a(this.field_146289_q, in, 0, 0, null);
                GlStateManager.func_179121_F();
                if (rc.contains(mouseX, mouseY)) {
                    custom = in.func_77973_b().getFontRenderer(in);
                    if (custom != null) {
                        fr = custom;
                    }
                    tooltip = in.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
                }
            }
            if (!(in = tile.getSlotGlassLens()).func_190926_b()) {
                if (in.func_77973_b() instanceof ItemInfusedGlass) {
                    hasLens = true;
                }
                rc = new Rectangle(this.guiLeft + 129, this.guiTop + 8, 16, 16);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)rc.x, (float)rc.y, (float)0.0f);
                GlStateManager.func_179126_j();
                this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, in, 0, 0);
                this.field_146296_j.func_180453_a(this.field_146289_q, in, 0, 0, null);
                GlStateManager.func_179121_F();
                if (rc.contains(mouseX, mouseY)) {
                    custom = in.func_77973_b().getFontRenderer(in);
                    if (custom != null) {
                        fr = custom;
                    }
                    tooltip = in.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
                }
            }
            this.field_73735_i = prev;
            this.field_146296_j.field_77023_b = itemPrev;
        }
        final RenderConstellation.BrightnessFunction f = new RenderConstellation.BrightnessFunction(){

            @Override
            public float getBrightness() {
                return ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution((World)Minecraft.func_71410_x().field_71441_e);
            }
        };
        if (hasLens) {
            ActiveStarMap map;
            DataActiveCelestials dac;
            Collection<IConstellation> cst;
            WorldSkyHandler wsh = ConstellationSkyHandler.getInstance().getWorldHandler(tile.func_145831_w());
            if (wsh != null && tile.doesSeeSky() && (double)f.getBrightness() > 1.0E-4 && (cst = (dac = (DataActiveCelestials)SyncDataHolder.getDataClient("AstralConstellations")).getActiveConstellations(Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension())) != null) {
                List filtered = cst.stream().filter(c -> ResearchManager.clientProgress.hasConstellationDiscovered(c.getUnlocalizedName())).collect(Collectors.toList());
                for (int i = 0; i < filtered.size(); ++i) {
                    IConstellation c2 = (IConstellation)filtered.get(i);
                    int offsetX = i % 2 == 0 ? 8 : 232;
                    int offsetY = 40 + i / 2 * 23;
                    this.mapRenderedConstellations.put(new Rectangle(offsetX, offsetY, 16, 16), c2);
                    this.drawConstellation(c2, new Point(offsetX, offsetY), f);
                }
            }
            if ((map = ItemInfusedGlass.getMapEngravingInformations(tile.getSlotGlassLens())) != null && tile.doesSeeSky()) {
                RenderConstellation.BrightnessFunction dim = new RenderConstellation.BrightnessFunction(){

                    @Override
                    public float getBrightness() {
                        return f.getBrightness() * 0.8f;
                    }
                };
                Map<IConstellation, List<Point>> constellationMap = map.getMapOffsets();
                for (IConstellation c2 : constellationMap.keySet()) {
                    for (Point p : constellationMap.get(c2)) {
                        int whDrawn = 30;
                        Point offset = new Point(p.x, p.y);
                        offset.translate(this.guiLeft, this.guiTop);
                        offset.translate(GuiMapDrawing.rctDrawingGrid.x, GuiMapDrawing.rctDrawingGrid.y);
                        offset.translate(-whDrawn, -whDrawn);
                        RenderConstellation.renderConstellationIntoGUI(c2, offset.x, offset.y, this.field_73735_i, whDrawn * 2, whDrawn * 2, 1.6f, dim, true, false);
                    }
                }
            }
        }
        if ((double)tile.getPercRunning() > 1.0E-4) {
            SpriteSheetResource halo = SpriteLibrary.spriteHalo2;
            halo.getResource().bind();
            Tuple<Double, Double> uvFrame = halo.getUVOffset(ClientScheduler.getClientTick());
            GlStateManager.func_179094_E();
            float rot = (float)(ClientScheduler.getClientTick() % 2000L) / 2000.0f * 360.0f;
            float scale = 160.0f;
            GlStateManager.func_179109_b((float)(this.guiLeft + this.guiWidth / 2), (float)(this.guiTop + this.guiHeight / 2 + 10), (float)0.0f);
            GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(-scale / 2.0f), (float)(-scale / 2.0f), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)tile.getPercRunning());
            GlStateManager.func_179147_l();
            Blending.DEFAULT.applyStateManager();
            GlStateManager.func_179118_c();
            this.drawTexturedRectAtCurrentPos(scale, scale, (float)((Double)uvFrame.key).doubleValue(), (float)((Double)uvFrame.value).doubleValue(), (float)halo.getULength(), (float)halo.getVLength());
            GlStateManager.func_179141_d();
            GlStateManager.func_179121_F();
            TextureHelper.refreshTextureBindState();
        }
        if (!tile.getSlotIn().func_190926_b() && !tile.hasParchment() && this.field_146296_j != null) {
            TextureHelper.refreshTextureBindState();
            TextureHelper.setActiveTextureToAtlasSprite();
            float prev = this.field_73735_i;
            float itemPrev = this.field_146296_j.field_77023_b;
            this.field_73735_i += 100.0f;
            this.field_146296_j.field_77023_b += 100.0f;
            ItemStack in = tile.getSlotIn();
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(this.guiLeft + 63), (float)(this.guiTop + 42), (float)0.0f);
            GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            Blending.DEFAULT.applyStateManager();
            GlStateManager.func_179126_j();
            this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, in, 0, 0);
            this.field_146296_j.func_180453_a(this.field_146289_q, in, 0, 0, null);
            GlStateManager.func_179121_F();
            this.field_73735_i = prev;
            this.field_146296_j.field_77023_b = itemPrev;
        }
        if ((double)f.getBrightness() <= 1.0E-4 || !tile.hasParchment()) {
            this.drawnConstellations.clear();
            this.dragging = null;
            this.dragRequested = 0;
        }
        for (DrawnConstellation cst : this.drawnConstellations) {
            int whDrawn = 30;
            Point offset = new Point(cst.point.x, cst.point.y);
            offset.translate(this.guiLeft, this.guiTop);
            offset.translate(-whDrawn, -whDrawn);
            RenderConstellation.renderConstellationIntoGUI(cst.constellation, offset.x, offset.y, this.field_73735_i, whDrawn * 2, whDrawn * 2, 1.6f, f, true, false);
        }
        if (this.dragging != null) {
            int whDragging = 30;
            Point offset = new Point(mouseX, mouseY);
            offset.translate(-whDragging, -whDragging);
            RenderConstellation.renderConstellationIntoGUI(this.dragging, offset.x, offset.y, this.field_73735_i, whDragging * 2, whDragging * 2, 1.6f, f, true, false);
            if ((double)ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution((World)Minecraft.func_71410_x().field_71441_e) <= 1.0E-4) {
                this.dragging = null;
            }
        }
        for (Rectangle r : this.mapRenderedConstellations.keySet()) {
            if (!r.contains(mouseX - this.guiLeft, mouseY - this.guiTop)) continue;
            tooltip = Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)this.mapRenderedConstellations.get(r).getUnlocalizedName(), (Object[])new Object[0])});
        }
        if (tooltip != null) {
            RenderingUtils.renderBlueTooltip(mouseX, mouseY, tooltip, fr);
        }
        TextureHelper.refreshTextureBindState();
    }

    private void drawConstellation(IConstellation c, Point p, RenderConstellation.BrightnessFunction fct) {
        RenderConstellation.renderConstellationIntoGUI(Color.WHITE, c, this.guiLeft + p.x, this.guiTop + p.y, this.field_73735_i, 16, 16, 0.5, fct, true, false);
    }

    @Nullable
    private Point translatePointToGrid(Point mouse) {
        mouse = new Point(mouse.x, mouse.y);
        mouse.translate(-this.guiLeft, -this.guiTop);
        if (rctDrawingGrid.contains(mouse)) {
            return mouse;
        }
        return null;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.dragRequested > 0 && !Mouse.isButtonDown((int)0)) {
            --this.dragRequested;
            if (this.dragRequested <= 0) {
                this.dragging = null;
                this.dragRequested = 0;
            }
        }
        if (this.drawnConstellations.size() >= 3) {
            LinkedList<DrawnConstellation> filtered = new LinkedList<DrawnConstellation>();
            for (int i = 0; i < 3; ++i) {
                DrawnConstellation c = this.drawnConstellations.get(i);
                Point at = new Point(c.point.x, c.point.y);
                at.translate(-GuiMapDrawing.rctDrawingGrid.x, -GuiMapDrawing.rctDrawingGrid.y);
                filtered.add(new DrawnConstellation(at, c.constellation));
            }
            PktEngraveGlass pkt = new PktEngraveGlass(((TileMapDrawingTable)((Object)this.getOwningTileEntity())).func_145831_w().field_73011_w.getDimension(), ((TileMapDrawingTable)((Object)this.getOwningTileEntity())).func_174877_v(), filtered);
            PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
            this.drawnConstellations.clear();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && ((TileMapDrawingTable)((Object)this.getOwningTileEntity())).hasParchment() && this.drawnConstellations.size() < 3 && ((TileMapDrawingTable)((Object)this.getOwningTileEntity())).hasUnengravedGlass()) {
            this.tryPickUp(new Point(mouseX, mouseY));
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        if (clickedMouseButton == 0 && this.dragging != null && ((TileMapDrawingTable)((Object)this.getOwningTileEntity())).hasParchment() && this.drawnConstellations.size() < 3 && ((TileMapDrawingTable)((Object)this.getOwningTileEntity())).hasUnengravedGlass()) {
            this.dragRequested = 10;
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (((TileMapDrawingTable)((Object)this.getOwningTileEntity())).hasParchment() && this.drawnConstellations.size() < 3 && ((TileMapDrawingTable)((Object)this.getOwningTileEntity())).hasUnengravedGlass()) {
            this.tryDrop(new Point(mouseX, mouseY));
        }
    }

    private void tryDrop(Point mouse) {
        if (this.dragging != null && this.dragRequested > 0) {
            Point gridPoint = this.translatePointToGrid(mouse);
            if (gridPoint != null && !this.tryBurnParchment()) {
                this.drawnConstellations.add(new DrawnConstellation(gridPoint, this.dragging));
            }
            this.dragging = null;
            this.dragRequested = 0;
        }
    }

    private boolean tryBurnParchment() {
        for (int i = 0; i < this.drawnConstellations.size() + 1; ++i) {
            if (EffectHandler.STATIC_EFFECT_RAND.nextInt(Math.max(1, MathHelper.func_76123_f((float)(7.0f * ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution((World)Minecraft.func_71410_x().field_71441_e))))) != 0) continue;
            PktBurnParchment pkt = new PktBurnParchment(Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension(), ((TileMapDrawingTable)((Object)this.getOwningTileEntity())).func_174877_v());
            PacketChannel.CHANNEL.sendToServer((IMessage)pkt);
            return true;
        }
        return false;
    }

    private void tryPickUp(Point mouse) {
        mouse.translate(-this.guiLeft, -this.guiTop);
        for (Rectangle r : this.mapRenderedConstellations.keySet()) {
            if (!r.contains(mouse)) continue;
            this.dragging = this.mapRenderedConstellations.get(r);
            this.dragRequested = 10;
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

