/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.render.tile;

import hellfirepvp.astralsorcery.client.models.base.ASlens;
import hellfirepvp.astralsorcery.client.models.base.ASlens_color;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalLens;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;

public class TESRLens
extends TileEntitySpecialRenderer<TileCrystalLens> {
    private static final ASlens modelLensPart = new ASlens();
    private static final BindableResource texLensPart = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MODELS, "base/lens");
    private static final ASlens_color modelLensColoredFrame = new ASlens_color();
    private static final BindableResource texLensColorFrame = AssetLibrary.loadTexture(AssetLoader.TextureLocation.MODELS, "lens/lens_color");

    public void render(TileCrystalLens te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        List<BlockPos> linked = te.getLinkedPositions();
        float yaw = 0.0f;
        float pitch = 0.0f;
        if (!linked.isEmpty() && linked.size() == 1) {
            BlockPos to = linked.get(0);
            BlockPos from = te.getTrPos();
            Vector3 dir = new Vector3(to).subtract(new Vector3(from));
            pitch = (float)Math.atan2(dir.getY(), Math.sqrt(dir.getX() * dir.getX() + dir.getZ() * dir.getZ()));
            yaw = (float)Math.atan2(dir.getX(), dir.getZ());
            yaw = 180.0f + (float)Math.toDegrees(-yaw);
            pitch = (float)Math.toDegrees(pitch);
        }
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        Blending.DEFAULT.apply();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 1.335), (double)(z + 0.5));
        GL11.glScaled((double)0.055, (double)0.055, (double)0.055);
        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)(yaw % 360.0f), (double)0.0, (double)1.0, (double)0.0);
        this.renderHandle(yaw, pitch);
        if (te.getLensColor() != null) {
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
            Color c = te.getLensColor().wrappedColor;
            GL11.glColor4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
            this.renderColoredLens(yaw, -pitch);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        TextureHelper.refreshTextureBindState();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void renderColoredLens(float yaw, float pitch) {
        texLensColorFrame.bind();
        modelLensColoredFrame.func_78088_a(null, yaw, pitch, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    private void renderHandle(float yaw, float pitch) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)-30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)165.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
        texLensPart.bind();
        modelLensPart.func_78088_a(null, yaw, pitch, 0.0f, 0.0f, 0.0f, 1.0f);
        RenderHelper.func_74518_a();
    }
}

