/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util.resource;

import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.common.util.data.Tuple;

public class SpriteSheetResource {
    private final double uPart;
    private final double vPart;
    private final int frameCount;
    private final int rows;
    private final int columns;
    private final BindableResource resource;

    public SpriteSheetResource(BindableResource resource, int rows, int columns) {
        if (rows <= 0 || columns <= 0) {
            throw new IllegalArgumentException("Can't instantiate a sprite sheet without any rows or columns!");
        }
        this.frameCount = rows * columns;
        this.rows = rows;
        this.columns = columns;
        this.resource = resource;
        this.uPart = 1.0 / (double)columns;
        this.vPart = 1.0 / (double)rows;
    }

    public BindableResource getResource() {
        return this.resource;
    }

    public double getULength() {
        return this.uPart;
    }

    public double getVLength() {
        return this.vPart;
    }

    public Tuple<Double, Double> getUVOffset(long frameTimer) {
        int frame = (int)(frameTimer % (long)this.frameCount);
        return new Tuple<Double, Double>((double)(frame % this.columns) * this.uPart, (double)(frame / this.columns) * this.vPart);
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }
}

