/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.GatewayCache;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktUpdateGateways;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class CelestialGatewaySystem {
    private boolean startup = false;
    public static CelestialGatewaySystem instance = new CelestialGatewaySystem();
    private Map<Integer, List<BlockPos>> serverCache = new HashMap<Integer, List<BlockPos>>();
    private Map<Integer, List<BlockPos>> clientCache = new HashMap<Integer, List<BlockPos>>();

    private CelestialGatewaySystem() {
    }

    public void onServerStart() {
        this.startup = true;
        Integer[] worlds = DimensionManager.getStaticDimensionIDs();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (Integer id : worlds) {
            if (id == null) continue;
            WorldServer world = server.func_71218_a(id.intValue());
            this.loadWorldCache((World)world);
        }
        this.startup = false;
        this.syncToAll();
    }

    @SubscribeEvent
    public void onWorldInit(WorldEvent.Load event) {
        if (this.startup) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        this.loadWorldCache(world);
        this.syncToAll();
    }

    public void syncTo(EntityPlayer pl) {
        PktUpdateGateways pkt = new PktUpdateGateways(this.serverCache);
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)pl);
    }

    public void syncToAll() {
        PktUpdateGateways pkt = new PktUpdateGateways(this.serverCache);
        PacketChannel.CHANNEL.sendToAll((IMessage)pkt);
    }

    public List<BlockPos> getGatewaysForWorld(World world, Side side) {
        return (side == Side.SERVER ? this.serverCache : this.clientCache).get(world.field_73011_w.getDimension());
    }

    public Map<Integer, List<BlockPos>> getGatewayCache(Side side) {
        return Collections.unmodifiableMap(side == Side.SERVER ? this.serverCache : this.clientCache);
    }

    public void addPosition(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        int dim = world.field_73011_w.getDimension();
        if (!this.serverCache.containsKey(dim)) {
            this.forceLoad(dim);
        }
        if (!this.serverCache.containsKey(dim)) {
            AstralSorcery.log.info("Couldn't add position for world " + dim + "! - Force loading the world resulted in... nothing.");
            return;
        }
        List<BlockPos> cache = this.serverCache.get(dim);
        if (!cache.contains(pos)) {
            cache.add(pos);
            this.syncToAll();
        }
    }

    public void removePosition(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        int dim = world.field_73011_w.getDimension();
        if (!this.serverCache.containsKey(dim)) {
            return;
        }
        if (this.serverCache.get(dim).remove(pos)) {
            this.syncToAll();
        }
    }

    private void forceLoad(int dim) {
        WorldServer serv = DimensionManager.getWorld((int)dim);
        if (serv == null) {
            DimensionManager.initDimension((int)dim);
        }
    }

    public void updateClientCache(Map<Integer, List<BlockPos>> positions) {
        this.clientCache = positions;
    }

    private void loadWorldCache(World world) {
        GatewayCache cache = (GatewayCache)WorldCacheManager.getOrLoadData(world, WorldCacheManager.SaveKey.GATEWAY_DATA);
        this.serverCache.put(world.field_73011_w.getDimension(), cache.getGatewayPositions());
    }
}

