/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.BlockCustomOre;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class LightOreTransmutations {
    public static List<Transmutation> mtTransmutations = new LinkedList<Transmutation>();
    private static List<Transmutation> registeredTransmutations = new LinkedList<Transmutation>();
    private static List<Transmutation> localFallback = new LinkedList<Transmutation>();

    public static void init() {
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_189877_df.func_176223_P(), Blocks.field_150343_Z.func_176223_P(), 400.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_150354_m.func_176223_P(), Blocks.field_150435_aG.func_176223_P(), 400.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_150482_ag.func_176223_P(), Blocks.field_150412_bA.func_176223_P(), 1000.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_189878_dg.func_176223_P(), Blocks.field_150425_aM.func_176223_P(), 200.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_180398_cJ.func_176223_P(), Blocks.field_150368_y.func_176223_P(), 200.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_150322_A.func_176223_P(), Blocks.field_150377_bs.func_176223_P(), 200.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_150424_aL.func_176223_P(), Blocks.field_150385_bj.func_176223_P(), 200.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_150366_p.func_176223_P(), BlocksAS.customOre.func_176223_P().func_177226_a(BlockCustomOre.ORE_TYPE, (Comparable)((Object)BlockCustomOre.OreType.STARMETAL)), 100.0));
        LightOreTransmutations.registerTransmutation(new Transmutation(Blocks.field_150423_aK.func_176223_P(), Blocks.field_150414_aQ.func_176223_P(), new ItemStack(Blocks.field_150423_aK), new ItemStack(Items.field_151105_aU), 600.0));
        LightOreTransmutations.cacheLocalFallback();
    }

    private static void cacheLocalFallback() {
        if (localFallback.isEmpty()) {
            localFallback.addAll(registeredTransmutations);
        }
    }

    public static void loadFromFallback() {
        registeredTransmutations.clear();
        registeredTransmutations.addAll(localFallback);
    }

    public static Transmutation tryRemoveTransmutation(ItemStack outRemove, boolean matchMeta) {
        Block b = Block.func_149634_a((Item)outRemove.func_77973_b());
        if (b != Blocks.field_150350_a) {
            for (Transmutation tr : registeredTransmutations) {
                if (!tr.output.func_177230_c().equals(b) || matchMeta && tr.output.func_177230_c().func_176201_c(tr.output) != outRemove.func_77960_j()) continue;
                registeredTransmutations.remove(tr);
                return tr;
            }
        }
        for (Transmutation tr : registeredTransmutations) {
            if (tr.outStack.func_190926_b() || !ItemUtils.matchStackLoosely(tr.outStack, outRemove)) continue;
            registeredTransmutations.remove(tr);
            return tr;
        }
        return null;
    }

    @Nullable
    public static Transmutation registerTransmutation(Transmutation tr) {
        for (Transmutation t : registeredTransmutations) {
            if (!t.input.equals(tr.input)) continue;
            AstralSorcery.log.warn("Tried to register Transmutation that has the same input as an already existing one.");
            return null;
        }
        if (tr.input == null) {
            AstralSorcery.log.warn("Tried to register Transmutation with null input - Skipping!");
            return null;
        }
        if (tr.input.func_177230_c().equals(Blocks.field_150462_ai)) {
            AstralSorcery.log.warn("Cannot register Transmutation of iron workbench -> something. By default occupied by general crafting which is handled differently.");
            return null;
        }
        if (tr.output == null) {
            AstralSorcery.log.warn("Tried to register Transmutation with null output - Skipping!");
            return null;
        }
        registeredTransmutations.add(tr);
        return tr;
    }

    public static List<Transmutation> getRegisteredTransmutations() {
        return Collections.unmodifiableList(registeredTransmutations);
    }

    @Nullable
    public static Transmutation searchForTransmutation(IBlockState tryStateIn) {
        for (Transmutation tr : registeredTransmutations) {
            if (!tr.input.equals(tryStateIn)) continue;
            return tr;
        }
        for (Transmutation tr : mtTransmutations) {
            if (!tr.input.equals(tryStateIn)) continue;
            return tr;
        }
        return null;
    }

    public static class Transmutation {
        public final IBlockState input;
        public final IBlockState output;
        public final double cost;
        @Nonnull
        public final ItemStack outStack;
        @Nonnull
        public final ItemStack inStack;

        public Transmutation(IBlockState input, IBlockState output, double cost) {
            this(input, output, ItemStack.field_190927_a, ItemStack.field_190927_a, cost);
        }

        public Transmutation(IBlockState input, IBlockState output, @Nonnull ItemStack inputDisplay, @Nonnull ItemStack outputDisplay, double cost) {
            this.input = input;
            this.output = output;
            this.cost = cost;
            this.outStack = outputDisplay;
            this.inStack = inputDisplay;
        }

        @Nonnull
        public ItemStack getInputDisplayStack() {
            if (!this.inStack.func_190926_b()) {
                return this.inStack.func_77946_l();
            }
            return ItemUtils.createBlockStack(this.input);
        }

        @Nonnull
        public ItemStack getOutputDisplayStack() {
            if (!this.outStack.func_190926_b()) {
                return this.outStack.func_77946_l();
            }
            return ItemUtils.createBlockStack(this.output);
        }
    }
}

