/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import hellfirepvp.astralsorcery.common.data.config.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreTypes {
    private static Map<String, Double> oreDictWeights = new HashMap<String, Double>();
    private static double totalWeight = 0.0;
    private static Map<String, Double> localFallback = new HashMap<String, Double>();
    private static double fallbackWeight = 0.0;

    public static void init() {
        OreTypes.registerOreEntry("oreCoal", 5200.0);
        OreTypes.registerOreEntry("oreIron", 2500.0);
        OreTypes.registerOreEntry("oreGold", 550.0);
        OreTypes.registerOreEntry("oreLapis", 140.0);
        OreTypes.registerOreEntry("oreRedstone", 700.0);
        OreTypes.registerOreEntry("oreDiamond", 180.0);
        OreTypes.registerOreEntry("oreEmerald", 100.0);
        OreTypes.registerOreEntry("oreAluminum", 600.0);
        OreTypes.registerOreEntry("oreCopper", 1100.0);
        OreTypes.registerOreEntry("oreTin", 1500.0);
        OreTypes.registerOreEntry("oreLead", 1000.0);
        OreTypes.registerOreEntry("oreCertusQuartz", 500.0);
        OreTypes.registerOreEntry("oreNickel", 270.0);
        OreTypes.registerOreEntry("orePlatinum", 90.0);
        OreTypes.registerOreEntry("oreSilver", 180.0);
        OreTypes.registerOreEntry("oreMithril", 1.0);
        OreTypes.registerOreEntry("oreRuby", 400.0);
        OreTypes.registerOreEntry("oreSapphire", 400.0);
        OreTypes.registerOreEntry("oreUranium", 550.0);
        OreTypes.registerOreEntry("oreYellorite", 560.0);
        OreTypes.registerOreEntry("oreZinc", 300.0);
        OreTypes.registerOreEntry("oreSulfur", 600.0);
        OreTypes.registerOreEntry("oreOsmium", 950.0);
        OreTypes.cacheLocalFallback();
    }

    private static void cacheLocalFallback() {
        if (localFallback.isEmpty()) {
            localFallback.putAll(oreDictWeights);
            fallbackWeight = totalWeight;
        }
    }

    public static void loadFromFallback() {
        oreDictWeights.clear();
        totalWeight = fallbackWeight;
        oreDictWeights.putAll(localFallback);
    }

    public static void removeOreEntry(String oreDictName) {
        if (oreDictWeights.containsKey(oreDictName)) {
            double weight = oreDictWeights.get(oreDictName);
            oreDictWeights.remove(oreDictName);
            totalWeight -= weight;
        }
    }

    public static void registerOreEntry(String oreDictName, Double weight) {
        oreDictWeights.put(oreDictName, weight);
        totalWeight += weight.doubleValue();
    }

    @Nonnull
    public static ItemStack getRandomOre(Random random) {
        ItemStack result = ItemStack.field_190927_a;
        int runs = 0;
        while (result.func_190926_b() && runs < 150) {
            String key = null;
            double randWeight = (double)random.nextFloat() * totalWeight;
            for (Map.Entry<String, Double> entry : oreDictWeights.entrySet()) {
                if (!((randWeight -= entry.getValue().doubleValue()) <= 0.0)) continue;
                key = entry.getKey();
                break;
            }
            if (key == null) {
                ++runs;
                continue;
            }
            NonNullList ores = OreDictionary.getOres(key);
            for (ItemStack stack : ores) {
                String className;
                Item i;
                String regModid;
                if (stack.func_190926_b() || Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a || Config.modidOreGenBlacklist.contains(regModid = (i = stack.func_77973_b()).getRegistryName().func_110624_b()) || (className = i.getClass().getName()).toLowerCase().contains("greg")) continue;
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    stack.func_77964_b(0);
                }
                result = stack;
            }
            ++runs;
        }
        return result;
    }
}

