/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.base;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.item.ItemCraftingComponent;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class WellLiquefaction {
    public static Map<ItemStack, LiquefactionEntry> mtLiquefactions = new HashMap<ItemStack, LiquefactionEntry>();
    private static Map<ItemStack, LiquefactionEntry> registeredLiquefactions = new HashMap<ItemStack, LiquefactionEntry>();
    private static Map<ItemStack, LiquefactionEntry> localFallback = new HashMap<ItemStack, LiquefactionEntry>();

    public static void init() {
        WellLiquefaction.registerLiquefaction(ItemCraftingComponent.MetaType.AQUAMARINE.asStack(), BlocksAS.fluidLiquidStarlight, 0.3f, 6.0f, new Color(0, 136, 221));
        WellLiquefaction.registerLiquefaction(ItemCraftingComponent.MetaType.RESO_GEM.asStack(), BlocksAS.fluidLiquidStarlight, 0.8f, 12.0f, new Color(0, 136, 221));
        WellLiquefaction.registerLiquefaction(new ItemStack((Item)ItemsAS.tunedCelestialCrystal), BlocksAS.fluidLiquidStarlight, 1.4f, 280.0f, BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL.displayColor);
        WellLiquefaction.registerLiquefaction(new ItemStack((Item)ItemsAS.celestialCrystal), BlocksAS.fluidLiquidStarlight, 1.2f, 90.0f, BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL.displayColor);
        WellLiquefaction.registerLiquefaction(new ItemStack((Item)ItemsAS.tunedRockCrystal), BlocksAS.fluidLiquidStarlight, 1.1f, 200.0f, BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL.displayColor);
        WellLiquefaction.registerLiquefaction(new ItemStack((Item)ItemsAS.rockCrystal), BlocksAS.fluidLiquidStarlight, 1.0f, 70.0f, BlockCollectorCrystalBase.CollectorCrystalType.ROCK_CRYSTAL.displayColor);
        WellLiquefaction.cacheLocalFallback();
    }

    private static void cacheLocalFallback() {
        if (localFallback.isEmpty()) {
            localFallback.putAll(registeredLiquefactions);
        }
    }

    public static void loadFromFallback() {
        registeredLiquefactions.clear();
        registeredLiquefactions.putAll(localFallback);
    }

    public static void registerLiquefaction(ItemStack catalystIn, Fluid producedIn, float productionMultiplier, float shatterMultiplier, Color color) {
        for (ItemStack i : registeredLiquefactions.keySet()) {
            if (!i.func_77969_a(catalystIn)) continue;
            AstralSorcery.log.warn("Tried to register Lightwell Liquefaction that has the same input as an already existing one.");
            return;
        }
        registeredLiquefactions.put(catalystIn, new LiquefactionEntry(catalystIn, producedIn, productionMultiplier, shatterMultiplier, color));
    }

    @Nullable
    public static LiquefactionEntry getLiquefactionEntry(ItemStack suggestedCatalyst) {
        for (ItemStack i : registeredLiquefactions.keySet()) {
            if (!i.func_77969_a(suggestedCatalyst)) continue;
            return registeredLiquefactions.get(i);
        }
        for (ItemStack i : mtLiquefactions.keySet()) {
            if (!i.func_77969_a(suggestedCatalyst)) continue;
            return mtLiquefactions.get(i);
        }
        return null;
    }

    @Nullable
    public static LiquefactionEntry tryRemoveLiquefaction(ItemStack stack, @Nullable Fluid fluid) {
        for (ItemStack i : registeredLiquefactions.keySet()) {
            if (!i.func_77969_a(stack)) continue;
            LiquefactionEntry le = registeredLiquefactions.get(i);
            if (fluid != null && !le.producing.equals(fluid)) continue;
            registeredLiquefactions.remove(i);
            return le;
        }
        return null;
    }

    public static List<LiquefactionEntry> getRegisteredLiquefactions() {
        return new ArrayList<LiquefactionEntry>(registeredLiquefactions.values());
    }

    public static class LiquefactionEntry {
        public final ItemStack catalyst;
        public final Fluid producing;
        public final float productionMultiplier;
        public final float shatterMultiplier;
        @Nullable
        public final Color catalystColor;

        public LiquefactionEntry(ItemStack catalyst, Fluid producing, float productionMultiplier, float shatterMultiplier, @Nullable Color catalystColor) {
            this.catalyst = catalyst;
            this.producing = producing;
            this.productionMultiplier = productionMultiplier;
            this.shatterMultiplier = Math.max(0.0f, shatterMultiplier);
            this.catalystColor = catalystColor;
        }
    }
}

