/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.block.BlockCustomName;
import hellfirepvp.astralsorcery.common.block.BlockStructural;
import hellfirepvp.astralsorcery.common.block.BlockVariants;
import hellfirepvp.astralsorcery.common.item.base.IGrindable;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.IVariantTileProvider;
import hellfirepvp.astralsorcery.common.tile.TileGrindstone;
import hellfirepvp.astralsorcery.common.tile.TileTelescope;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SwordSharpenHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMachine
extends BlockContainer
implements BlockCustomName,
BlockVariants {
    private static final Random rand = new Random();
    public static PropertyEnum<MachineType> MACHINE_TYPE = PropertyEnum.func_177709_a((String)"machine", MachineType.class);

    public BlockMachine() {
        super(Material.field_175972_I, MapColor.field_151660_b);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149752_b(25.0f);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState state = world.func_180495_p(pos);
        switch ((MachineType)((Object)state.func_177229_b(MACHINE_TYPE))) {
            case TELESCOPE: {
                RenderingUtils.playBlockBreakParticles(pos.func_177984_a(), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE));
            }
            case GRINDSTONE: {
                RenderingUtils.playBlockBreakParticles(pos, Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.SPRUCE));
            }
        }
        return false;
    }

    public String getHarvestTool(IBlockState state) {
        MachineType t = (MachineType)((Object)state.func_177229_b(MACHINE_TYPE));
        switch (t) {
            case TELESCOPE: {
                return "axe";
            }
            case GRINDSTONE: {
                return "pickaxe";
            }
        }
        return super.getHarvestTool(state);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        MachineType t = (MachineType)((Object)state.func_177229_b(MACHINE_TYPE));
        switch (t) {
            case TELESCOPE: {
                return SoundType.field_185848_a;
            }
            case GRINDSTONE: {
                return SoundType.field_185851_d;
            }
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        MachineType t = (MachineType)((Object)state.func_177229_b(MACHINE_TYPE));
        switch (t) {
            case TELESCOPE: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 1.0);
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (MachineType type : MachineType.values()) {
            list.add((Object)type.asStack());
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        MachineType type = (MachineType)((Object)state.func_177229_b(MACHINE_TYPE));
        return type.provideTileEntity(world, state);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        MachineType type = (MachineType)((Object)state.func_177229_b(MACHINE_TYPE));
        if (type != MachineType.GRINDSTONE) {
            return;
        }
        TileGrindstone tgr = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileGrindstone.class, true);
        if (tgr == null || tgr.getGrindingItem().func_190926_b()) {
            return;
        }
        ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, tgr.getGrindingItem());
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        MachineType type = (MachineType)((Object)state.func_177229_b(MACHINE_TYPE));
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        switch (type) {
            case TELESCOPE: {
                if (!player.field_70170_p.field_72995_K) break;
                AstralSorcery.proxy.openGui(CommonProxy.EnumGuiId.TELESCOPE, player, player.field_70170_p, posX, posY, posZ);
                break;
            }
            case GRINDSTONE: {
                TileGrindstone tgr = MiscUtils.getTileAt((IBlockAccess)world, pos, TileGrindstone.class, true);
                if (tgr == null) break;
                if (!world.field_72995_K) {
                    ItemStack grind = tgr.getGrindingItem();
                    if (!grind.func_190926_b()) {
                        if (player.func_70093_af()) {
                            ItemUtils.dropItem(world, (float)posX + 0.5f, (float)posY + 1.0f, (float)posZ + 0.5f, grind);
                            tgr.setGrindingItem(ItemStack.field_190927_a);
                            break;
                        }
                        Item i = grind.func_77973_b();
                        if (i instanceof IGrindable) {
                            IGrindable.GrindResult result = ((IGrindable)i).grind(tgr, grind, rand);
                            switch (result.getType()) {
                                case SUCCESS: {
                                    tgr.setGrindingItem(grind);
                                    break;
                                }
                                case ITEMCHANGE: {
                                    tgr.setGrindingItem(result.getStack());
                                    break;
                                }
                                case FAIL_BREAK_ITEM: {
                                    tgr.setGrindingItem(ItemStack.field_190927_a);
                                    world.func_184148_a(null, (double)posX, (double)posY, (double)posZ, SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.2f + 0.8f);
                                }
                            }
                            tgr.playWheelEffect();
                            break;
                        }
                        if (!SwordSharpenHelper.canBeSharpened(grind)) break;
                        if (rand.nextInt(40) == 0) {
                            SwordSharpenHelper.setSwordSharpened(grind);
                        }
                        tgr.playWheelEffect();
                        break;
                    }
                    ItemStack stack = player.func_184586_b(hand);
                    if (stack.func_190926_b()) break;
                    Item trySet = stack.func_77973_b();
                    if (trySet instanceof IGrindable && ((IGrindable)trySet).canGrind(tgr, stack)) {
                        ItemStack toSet = stack.func_77946_l();
                        toSet.func_190920_e(1);
                        tgr.setGrindingItem(toSet);
                        world.func_184148_a(null, (double)posX, (double)posY, (double)posZ, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.2f + 0.8f);
                        if (player.func_184812_l_()) break;
                        stack.func_190920_e(stack.func_190916_E() - 1);
                        break;
                    }
                    if (!SwordSharpenHelper.canBeSharpened(stack) || SwordSharpenHelper.isSwordSharpened(stack)) break;
                    ItemStack toSet = stack.func_77946_l();
                    toSet.func_190920_e(1);
                    tgr.setGrindingItem(toSet);
                    world.func_184148_a(null, (double)posX, (double)posY, (double)posZ, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.2f + 0.8f);
                    if (player.func_184812_l_()) break;
                    stack.func_190920_e(stack.func_190916_E() - 1);
                    break;
                }
                ItemStack grind = tgr.getGrindingItem();
                if (grind.func_190926_b() || player.func_70093_af()) break;
                Item i = grind.func_77973_b();
                if (i instanceof IGrindable) {
                    if (!((IGrindable)i).canGrind(tgr, grind)) break;
                    for (int j = 0; j < 8; ++j) {
                        world.func_175688_a(EnumParticleTypes.CRIT, (double)posX + 0.5, (double)posY + 0.8, (double)posZ + 0.4, (double)((float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat()) * 0.3, (double)((float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat()) * 0.3, (double)((float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat()) * 0.3, new int[0]);
                    }
                } else {
                    if (!SwordSharpenHelper.canBeSharpened(grind) || SwordSharpenHelper.isSwordSharpened(grind)) break;
                    for (int j = 0; j < 8; ++j) {
                        world.func_175688_a(EnumParticleTypes.CRIT, (double)posX + 0.5, (double)posY + 0.8, (double)posZ + 0.4, (double)((float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat()) * 0.3, (double)((float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat()) * 0.3, (double)((float)(rand.nextBoolean() ? 1 : -1) * rand.nextFloat()) * 0.3, new int[0]);
                    }
                }
                break;
            }
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        switch ((MachineType)((Object)state.func_177229_b(MACHINE_TYPE))) {
            case TELESCOPE: {
                worldIn.func_175656_a(pos.func_177984_a(), BlocksAS.blockStructural.func_176223_P().func_177226_a(BlockStructural.BLOCK_TYPE, (Comparable)((Object)BlockStructural.BlockType.TELESCOPE_STRUCT)));
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        switch ((MachineType)((Object)state.func_177229_b(MACHINE_TYPE))) {
            case TELESCOPE: {
                if (!world.func_175623_d(pos.func_177984_a())) break;
                world.func_175698_g(pos);
            }
        }
        super.func_189540_a(state, world, pos, blockIn, fromPos);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (!(world instanceof World)) {
            super.onNeighborChange(world, pos, neighbor);
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        switch ((MachineType)((Object)state.func_177229_b(MACHINE_TYPE))) {
            case TELESCOPE: {
                if (!world.func_175623_d(pos.func_177984_a())) break;
                ((World)world).func_175698_g(pos);
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return meta < MachineType.values().length ? this.func_176223_P().func_177226_a(MACHINE_TYPE, (Comparable)((Object)MachineType.values()[meta])) : this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        MachineType type = (MachineType)((Object)state.func_177229_b(MACHINE_TYPE));
        return type == null ? 0 : type.ordinal();
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MACHINE_TYPE});
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public String getIdentifierForMeta(int meta) {
        MachineType mt = (MachineType)((Object)this.func_176203_a(meta).func_177229_b(MACHINE_TYPE));
        return mt.func_176610_l();
    }

    @Override
    public List<IBlockState> getValidStates() {
        LinkedList<IBlockState> ret = new LinkedList<IBlockState>();
        for (MachineType type : MachineType.values()) {
            ret.add(this.func_176223_P().func_177226_a(MACHINE_TYPE, (Comparable)((Object)type)));
        }
        return ret;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((MachineType)((Object)state.func_177229_b(MACHINE_TYPE))).func_176610_l();
    }

    public static enum MachineType implements IStringSerializable,
    IVariantTileProvider
    {
        TELESCOPE((world, pos) -> new TileTelescope()),
        GRINDSTONE((world, pos) -> new TileGrindstone());

        private final IVariantTileProvider provider;

        private MachineType(IVariantTileProvider provider) {
            this.provider = provider;
        }

        @Override
        public TileEntity provideTileEntity(World world, IBlockState state) {
            return this.provider.provideTileEntity(world, state);
        }

        public int getMeta() {
            return this.ordinal();
        }

        public ItemStack asStack() {
            return new ItemStack((Block)BlocksAS.blockMachine, 1, this.getMeta());
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

