/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.network;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.network.BlockCelestialCollectorCrystal;
import hellfirepvp.astralsorcery.common.block.network.BlockStarlightNetwork;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.data.research.EnumGatedKnowledge;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.base.render.ISpecialStackDescriptor;
import hellfirepvp.astralsorcery.common.item.block.ItemCollectorCrystal;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.network.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockCollectorCrystalBase
extends BlockStarlightNetwork
implements ISpecialStackDescriptor {
    private static AxisAlignedBB boxCrystal = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 1.0, 0.7);

    public BlockCollectorCrystalBase(Material material, MapColor color) {
        super(material, color);
        this.func_149722_s();
        this.func_149752_b(200000.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(0.7f);
        this.func_149647_a(RegistryItems.creativeTabAstralSorceryTunedCrystals);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        Color c = null;
        if (state.func_177230_c() instanceof BlockCelestialCollectorCrystal) {
            c = CollectorCrystalType.CELESTIAL_CRYSTAL.displayColor;
        }
        for (int i = 0; i < 1 + world.field_73012_v.nextInt(2); ++i) {
            AstralSorcery.proxy.fireLightning(world, new Vector3(target.func_178782_a()).add(0.5, 0.5, 0.5), new Vector3(target.func_178782_a()).add(0.5, 0.5, 0.5).add(-0.5 + (double)world.field_73012_v.nextFloat(), -2.0f + world.field_73012_v.nextFloat() * 4.0f, -0.5 + (double)world.field_73012_v.nextFloat()), c);
        }
        return true;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return boxCrystal;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        CollectorCrystalType type;
        CrystalProperties prop = CrystalProperties.getCrystalProperties(stack);
        Optional<Boolean> missing = CrystalProperties.addPropertyTooltip(prop, tooltip, (type = ItemCollectorCrystal.getType(stack)) == CollectorCrystalType.CELESTIAL_CRYSTAL ? 900 : 400);
        if (missing.isPresent()) {
            ProgressionTier tier = ResearchManager.clientProgress.getTierReached();
            IWeakConstellation c = ItemCollectorCrystal.getConstellation(stack);
            if (c != null) {
                if (EnumGatedKnowledge.COLLECTOR_TYPE.canSee(tier) && ResearchManager.clientProgress.hasConstellationDiscovered(c.getUnlocalizedName())) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"crystal.collect.type", (Object[])new Object[0]) + " " + TextFormatting.BLUE + I18n.func_135052_a((String)c.getUnlocalizedName(), (Object[])new Object[0]));
                } else if (!missing.get().booleanValue()) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"progress.missing.knowledge", (Object[])new Object[0]));
                }
            }
        }
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        TileCollectorCrystal te = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileCollectorCrystal.class, true);
        if (te != null && te.isPlayerMade()) {
            return 4.0f;
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer == null || !(placer instanceof EntityPlayer)) {
            return;
        }
        TileCollectorCrystal te = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileCollectorCrystal.class, true);
        if (te == null) {
            return;
        }
        IWeakConstellation c = ItemCollectorCrystal.getConstellation(stack);
        if (c != null) {
            te.onPlace(c, CrystalProperties.getCrystalProperties(stack), true, ItemCollectorCrystal.getType(stack));
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Lists.newArrayList();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCollectorCrystal();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileCollectorCrystal te = MiscUtils.getTileAt((IBlockAccess)world, pos, TileCollectorCrystal.class, true);
        if (te != null) {
            if (te.getCrystalProperties() == null || te.getConstellation() == null || te.getType() == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = new ItemStack((Block)this);
            CrystalProperties.applyCrystalProperties(stack, te.getCrystalProperties());
            ItemCollectorCrystal.setConstellation(stack, te.getConstellation());
            ItemCollectorCrystal.setType(stack, te.getType());
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public String func_149739_a() {
        PlayerProgress client = ResearchManager.clientProgress;
        if (EnumGatedKnowledge.COLLECTOR_CRYSTAL.canSee(client.getTierReached())) {
            return super.func_149739_a();
        }
        return "tile.blockcollectorcrystal.obf";
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileCollectorCrystal te = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileCollectorCrystal.class, true);
        if (te != null && !worldIn.field_72995_K) {
            PktParticleEvent event = new PktParticleEvent(PktParticleEvent.ParticleEventType.COLLECTOR_BURST, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            PacketChannel.CHANNEL.sendToAllAround((IMessage)event, PacketChannel.pointFromPos(worldIn, pos, 32.0));
            TileCollectorCrystal.breakDamage(worldIn, pos);
            if (te.isPlayerMade() && !player.func_184812_l_()) {
                ItemStack drop = new ItemStack((Block)(te.getType() == CollectorCrystalType.CELESTIAL_CRYSTAL ? BlocksAS.celestialCollectorCrystal : BlocksAS.collectorCrystal));
                if (te.getCrystalProperties() != null && te.getConstellation() != null) {
                    CrystalProperties.applyCrystalProperties(drop, te.getCrystalProperties());
                    ItemCollectorCrystal.setType(drop, te.getType() != null ? te.getType() : CollectorCrystalType.ROCK_CRYSTAL);
                    ItemCollectorCrystal.setConstellation(drop, te.getConstellation());
                    ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
                }
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public static enum CollectorCrystalType {
        ROCK_CRYSTAL(new Color(221, 221, 255)),
        CELESTIAL_CRYSTAL(new Color(0, 136, 255));

        public final Color displayColor;

        private CollectorCrystalType(Color c) {
            this.displayColor = c;
        }
    }
}

