/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.network;

import hellfirepvp.astralsorcery.common.base.WellLiquefaction;
import hellfirepvp.astralsorcery.common.block.fluid.FluidLiquidStarlight;
import hellfirepvp.astralsorcery.common.block.network.BlockStarlightNetwork;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.TileWell;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class BlockWell
extends BlockStarlightNetwork {
    private static final AxisAlignedBB boxWell = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);
    private static List<AxisAlignedBB> collisionBoxes;

    public BlockWell() {
        super(Material.field_151576_e, MapColor.field_151677_p);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149752_b(25.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileWell();
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileWell tw = MiscUtils.getTileAt(world, pos, TileWell.class, true);
        if (tw != null && tw.getHeldFluid() != null) {
            return tw.getHeldFluid().getLuminosity();
        }
        return super.getLightValue(state, world, pos);
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem;
        if (!worldIn.field_72995_K && !(heldItem = playerIn.func_184586_b(hand)).func_190926_b() && playerIn instanceof EntityPlayerMP) {
            FluidActionResult far;
            TileWell tw = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileWell.class, false);
            if (tw == null) {
                return false;
            }
            WellLiquefaction.LiquefactionEntry entry = WellLiquefaction.getLiquefactionEntry(heldItem);
            if (entry != null) {
                TileReceiverBaseInventory.ItemHandlerTile handle = tw.getInventoryHandler();
                if (!handle.getStackInSlot(0).func_190926_b()) {
                    return false;
                }
                if (!worldIn.func_175623_d(pos.func_177984_a())) {
                    return false;
                }
                handle.setStackInSlot(0, ItemUtils.copyStackWithSize(heldItem, 1));
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                if (MiscUtils.isPlayerFakeMP((EntityPlayerMP)playerIn) || entry.producing instanceof FluidLiquidStarlight) {
                    // empty if block
                }
                if (!playerIn.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
                if (heldItem.func_190916_E() <= 0) {
                    playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                }
            }
            if ((far = FluidUtil.tryFillContainerAndStow((ItemStack)heldItem, (IFluidHandler)((IFluidHandler)tw.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)), (IItemHandler)new InvWrapper((IInventory)playerIn.field_71071_by), (int)1000, (EntityPlayer)playerIn)).isSuccess()) {
                playerIn.func_184611_a(hand, far.getResult());
                SoundHelper.playSoundAround(SoundEvents.field_187630_M, worldIn, (Vec3i)pos, 1.0f, 1.0f);
                tw.markForUpdate();
            }
        }
        return true;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack stack;
        TileWell tw = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileWell.class, true);
        if (tw != null && !worldIn.field_72995_K && !(stack = tw.getInventoryHandler().getStackInSlot(0)).func_190926_b()) {
            tw.breakCatalyst();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        for (AxisAlignedBB box : collisionBoxes) {
            BlockWell.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return boxWell;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    static {
        LinkedList<AxisAlignedBB> boxes = new LinkedList<AxisAlignedBB>();
        boxes.add(new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.3125, 0.9375));
        boxes.add(new AxisAlignedBB(0.0625, 0.3125, 0.0625, 0.125, 1.0, 0.9375));
        boxes.add(new AxisAlignedBB(0.0625, 0.3125, 0.0625, 0.9375, 1.0, 0.125));
        boxes.add(new AxisAlignedBB(0.875, 0.3125, 0.0625, 0.9375, 1.0, 0.9375));
        boxes.add(new AxisAlignedBB(0.0625, 0.3125, 0.875, 0.9375, 1.0, 0.9375));
        collisionBoxes = Collections.unmodifiableList(boxes);
    }
}

